/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.achievement;

import com.almasb.fxgl.achievement.Achievement;
import com.almasb.fxgl.achievement.AchievementEvent;
import com.almasb.fxgl.achievement.AchievementProgressEvent;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.collection.PropertyChangeListener;
import com.almasb.fxgl.core.collection.PropertyMap;
import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.event.EventBus;
import com.almasb.sslogger.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.event.Event;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0015\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\"J \u0010#\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%H\u0002J \u0010&\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u001cH\u0002J \u0010'\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00052\u0006\u0010$\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/almasb/fxgl/achievement/AchievementManager;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "achievements", "", "Lcom/almasb/fxgl/achievement/Achievement;", "achievementsCopy", "", "getAchievementsCopy", "()Ljava/util/List;", "achievementsFromSettings", "eventBus", "Lcom/almasb/fxgl/event/EventBus;", "log", "Lcom/almasb/sslogger/Logger;", "bindToVars", "", "vars", "Lcom/almasb/fxgl/core/collection/PropertyMap;", "bindToVars$fxgl_achievement", "getAchievementByName", "name", "", "onExit", "onGameReady", "onMainLoopStarting", "onUpdate", "tpf", "", "read", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "registerAchievement", "a", "registerAchievement$fxgl_achievement", "registerBooleanAchievement", "value", "", "registerDoubleAchievement", "registerIntAchievement", "", "write", "fxgl-achievement"})
public final class AchievementManager
implements EngineService {
    private final Logger log = Logger.Companion.get(this.getClass());
    @Inject(value="achievements")
    private List<Achievement> achievementsFromSettings;
    @Inject(value="eventBus")
    private EventBus eventBus;
    private final List<Achievement> achievements;

    @NotNull
    public final List<Achievement> getAchievementsCopy() {
        List<Achievement> list = Collections.unmodifiableList(this.achievements);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.unmodifiableList(achievements)");
        return list;
    }

    @NotNull
    public final Achievement getAchievementByName(@NotNull String name) {
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Iterable iterable = this.achievements;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Achievement it = (Achievement)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        Achievement achievement = v0;
        if (achievement == null) {
            throw (Throwable)new IllegalArgumentException("Achievement with name [" + name + "] is not registered!");
        }
        return achievement;
    }

    public final void registerAchievement$fxgl_achievement(@NotNull Achievement a) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)a, (String)"a");
            Iterable $this$none$iv = this.achievements;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Achievement it = (Achievement)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)a.getName())) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        boolean bl3 = bl;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!bl3) {
            boolean bl6 = false;
            String string = "Achievement with name [" + a.getName() + "] exists";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.achievements.add(a);
        this.log.debug("Registered new achievement: " + a.getName());
    }

    public void onMainLoopStarting() {
        List<Achievement> list = this.achievementsFromSettings;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"achievementsFromSettings");
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Achievement it = (Achievement)element$iv;
            boolean bl = false;
            this.registerAchievement$fxgl_achievement(it);
        }
    }

    public void onGameReady(@NotNull PropertyMap vars) {
        Intrinsics.checkParameterIsNotNull((Object)vars, (String)"vars");
        this.bindToVars$fxgl_achievement(vars);
    }

    /*
     * WARNING - void declaration
     */
    public final void bindToVars$fxgl_achievement(@NotNull PropertyMap vars) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)vars, (String)"vars");
        Iterable $this$filter$iv = this.achievements;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Achievement it = (Achievement)element$iv$iv;
            boolean bl = false;
            if (!(!it.isAchieved())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Achievement it = (Achievement)element$iv;
            boolean bl = false;
            if (!vars.exists(it.getVarName())) {
                this.log.warning("Achievement " + it.getName() + " cannot find property " + it.getVarName());
                continue;
            }
            Object object = it.getVarValue();
            if (object instanceof Integer) {
                this.registerIntAchievement(vars, it, ((Number)it.getVarValue()).intValue());
                continue;
            }
            if (object instanceof Double) {
                this.registerDoubleAchievement(vars, it, ((Number)it.getVarValue()).doubleValue());
                continue;
            }
            if (object instanceof Boolean) {
                this.registerBooleanAchievement(vars, it, (Boolean)it.getVarValue());
                continue;
            }
            throw (Throwable)new IllegalArgumentException("Unknown value type for achievement: " + it.getVarValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerIntAchievement(PropertyMap vars, Achievement a, int value) {
        void listener;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        listener.element = (PropertyChangeListener)new PropertyChangeListener<Integer>(this, value, a, vars, (Ref.ObjectRef)listener){
            private boolean halfReached;
            final /* synthetic */ AchievementManager this$0;
            final /* synthetic */ int $value;
            final /* synthetic */ Achievement $a;
            final /* synthetic */ PropertyMap $vars;
            final /* synthetic */ Ref.ObjectRef $listener;

            public void onChange(int prev, int now) {
                if (!this.halfReached && now >= this.$value / 2) {
                    this.halfReached = true;
                    AchievementManager.access$getEventBus$p(this.this$0).fireEvent((Event)new AchievementProgressEvent(this.$a, now, this.$value));
                }
                if (now >= this.$value) {
                    this.$a.setAchieved$fxgl_achievement();
                    AchievementManager.access$getEventBus$p(this.this$0).fireEvent((Event)new AchievementEvent(AchievementEvent.ACHIEVED, this.$a));
                    String string = this.$a.getVarName();
                    PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.$listener.element;
                    if (propertyChangeListener == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$vars.removeListener(string, propertyChangeListener);
                }
            }
            {
                this.this$0 = $outer;
                this.$value = $captured_local_variable$1;
                this.$a = $captured_local_variable$2;
                this.$vars = $captured_local_variable$3;
                this.$listener = $captured_local_variable$4;
            }
        };
        vars.addListener(a.getVarName(), (PropertyChangeListener)listener.element);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerDoubleAchievement(PropertyMap vars, Achievement a, double value) {
        void listener;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        listener.element = (PropertyChangeListener)new PropertyChangeListener<Double>(this, value, a, vars, (Ref.ObjectRef)listener){
            private boolean halfReached;
            final /* synthetic */ AchievementManager this$0;
            final /* synthetic */ double $value;
            final /* synthetic */ Achievement $a;
            final /* synthetic */ PropertyMap $vars;
            final /* synthetic */ Ref.ObjectRef $listener;

            public void onChange(double prev, double now) {
                if (!this.halfReached && now >= this.$value / (double)2) {
                    this.halfReached = true;
                    AchievementManager.access$getEventBus$p(this.this$0).fireEvent((Event)new AchievementProgressEvent(this.$a, now, this.$value));
                }
                if (now >= this.$value) {
                    this.$a.setAchieved$fxgl_achievement();
                    AchievementManager.access$getEventBus$p(this.this$0).fireEvent((Event)new AchievementEvent(AchievementEvent.ACHIEVED, this.$a));
                    String string = this.$a.getVarName();
                    PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.$listener.element;
                    if (propertyChangeListener == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$vars.removeListener(string, propertyChangeListener);
                }
            }
            {
                this.this$0 = $outer;
                this.$value = $captured_local_variable$1;
                this.$a = $captured_local_variable$2;
                this.$vars = $captured_local_variable$3;
                this.$listener = $captured_local_variable$4;
            }
        };
        vars.addListener(a.getVarName(), (PropertyChangeListener)listener.element);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerBooleanAchievement(PropertyMap vars, Achievement a, boolean value) {
        void listener;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        listener.element = (PropertyChangeListener)new PropertyChangeListener<Boolean>(this, value, a, vars, (Ref.ObjectRef)listener){
            final /* synthetic */ AchievementManager this$0;
            final /* synthetic */ boolean $value;
            final /* synthetic */ Achievement $a;
            final /* synthetic */ PropertyMap $vars;
            final /* synthetic */ Ref.ObjectRef $listener;

            public void onChange(boolean prev, boolean now) {
                if (now == this.$value) {
                    this.$a.setAchieved$fxgl_achievement();
                    AchievementManager.access$getEventBus$p(this.this$0).fireEvent((Event)new AchievementEvent(AchievementEvent.ACHIEVED, this.$a));
                    String string = this.$a.getVarName();
                    PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.$listener.element;
                    if (propertyChangeListener == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$vars.removeListener(string, propertyChangeListener);
                }
            }
            {
                this.this$0 = $outer;
                this.$value = $captured_local_variable$1;
                this.$a = $captured_local_variable$2;
                this.$vars = $captured_local_variable$3;
                this.$listener = $captured_local_variable$4;
            }
        };
        vars.addListener(a.getVarName(), (PropertyChangeListener)listener.element);
    }

    public void onExit() {
    }

    public void onUpdate(double tpf) {
    }

    public void write(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        Iterable $this$forEach$iv = this.achievements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Achievement a = (Achievement)element$iv;
            boolean bl = false;
            bundle.put(a.getName(), (Serializable)Boolean.valueOf(a.isAchieved()));
        }
    }

    public void read(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        Iterable $this$forEach$iv = this.achievements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Achievement a = (Achievement)element$iv;
            boolean bl = false;
            boolean achieved = (Boolean)bundle.get(a.getName());
            if (!achieved) continue;
            a.setAchieved$fxgl_achievement();
        }
    }

    public AchievementManager() {
        List list;
        AchievementManager achievementManager = this;
        boolean bl = false;
        achievementManager.achievements = list = (List)new ArrayList();
    }

    public static final /* synthetic */ EventBus access$getEventBus$p(AchievementManager $this) {
        EventBus eventBus = $this.eventBus;
        if (eventBus == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventBus");
        }
        return eventBus;
    }

    public static final /* synthetic */ void access$setEventBus$p(AchievementManager $this, EventBus eventBus) {
        $this.eventBus = eventBus;
    }
}

