/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.concurrent;

import com.almasb.fxgl.core.concurrent.AsyncTask;
import com.almasb.fxgl.core.concurrent.Coroutine;
import com.almasb.fxgl.core.concurrent.Executor;
import com.almasb.fxgl.core.concurrent.FXCoroutine;
import com.almasb.fxgl.core.concurrent.FXGLThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0013\"\b\b\u0000\u0010\u0016*\u00020\u00172\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0013\"\b\b\u0000\u0010\u0016*\u00020\u00172\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/almasb/fxgl/core/concurrent/Async;", "Lcom/almasb/fxgl/core/concurrent/Executor;", "()V", "schedulerService", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "service", "Ljava/util/concurrent/ExecutorService;", "execute", "", "task", "Ljava/lang/Runnable;", "schedule", "Ljava/util/concurrent/ScheduledFuture;", "action", "delay", "Ljavafx/util/Duration;", "shutdownNow", "startAsync", "Lcom/almasb/fxgl/core/concurrent/AsyncTask;", "Ljava/lang/Void;", "func", "T", "", "Ljava/util/concurrent/Callable;", "startAsyncFX", "fxgl-core"})
public final class Async
implements Executor {
    private static final ExecutorService service;
    private static final ScheduledExecutorService schedulerService;
    public static final Async INSTANCE;

    @Override
    public void execute(@NotNull Runnable task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        service.submit(task);
    }

    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable action, @NotNull Duration delay) {
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        Intrinsics.checkParameterIsNotNull((Object)delay, (String)"delay");
        ScheduledFuture<?> scheduledFuture = schedulerService.schedule(action, (long)delay.toMillis(), TimeUnit.MILLISECONDS);
        Intrinsics.checkExpressionValueIsNotNull(scheduledFuture, (String)"schedulerService.schedul\u2026), TimeUnit.MILLISECONDS)");
        return scheduledFuture;
    }

    @Override
    @NotNull
    public <T> AsyncTask<T> startAsync(@NotNull Callable<T> func) {
        Intrinsics.checkParameterIsNotNull(func, (String)"func");
        ExecutorService executorService = service;
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"service");
        return new Coroutine<T>(func, executorService);
    }

    @NotNull
    public AsyncTask<Void> startAsync(@NotNull Runnable func) {
        Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
        Callable callable = new Callable<Void>(func){
            final /* synthetic */ Runnable $func;

            @Nullable
            public final Void call() {
                this.$func.run();
                return null;
            }
            {
                this.$func = runnable;
            }
        };
        ExecutorService executorService = service;
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"service");
        return new Coroutine(callable, executorService);
    }

    @Override
    @NotNull
    public <T> AsyncTask<T> startAsyncFX(@NotNull Callable<T> func) {
        Intrinsics.checkParameterIsNotNull(func, (String)"func");
        return new FXCoroutine<T>(func);
    }

    @NotNull
    public AsyncTask<Void> startAsyncFX(@NotNull Runnable func) {
        Intrinsics.checkParameterIsNotNull((Object)func, (String)"func");
        return new FXCoroutine((Callable)new Callable<Void>(func){
            final /* synthetic */ Runnable $func;

            @Nullable
            public final Void call() {
                this.$func.run();
                return null;
            }
            {
                this.$func = runnable;
            }
        });
    }

    @Override
    public void shutdownNow() {
        service.shutdownNow();
        schedulerService.shutdownNow();
    }

    private Async() {
    }

    static {
        Async async;
        INSTANCE = async = new Async();
        service = Executors.newCachedThreadPool(FXGLThreadFactory.INSTANCE);
        schedulerService = Executors.newScheduledThreadPool(2, FXGLThreadFactory.INSTANCE);
    }
}

