/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.animation;

import com.almasb.fxgl.animation.AnimatedValue;
import com.almasb.fxgl.core.math.FXGLMath;
import javafx.animation.Interpolator;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J(\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/almasb/fxgl/animation/AnimatedColor;", "Lcom/almasb/fxgl/animation/AnimatedValue;", "Ljavafx/scene/paint/Color;", "from", "to", "(Ljavafx/scene/paint/Color;Ljavafx/scene/paint/Color;)V", "animate", "val1", "val2", "progress", "", "interpolator", "Ljavafx/animation/Interpolator;", "clamp", "value", "fxgl-core"})
public final class AnimatedColor
extends AnimatedValue<Color> {
    public AnimatedColor(@NotNull Color from, @NotNull Color to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        super(from, to);
    }

    @Override
    @NotNull
    public Color animate(@NotNull Color val1, @NotNull Color val2, double progress, @NotNull Interpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)val1, (String)"val1");
        Intrinsics.checkNotNullParameter((Object)val2, (String)"val2");
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        Color color = Color.color((double)this.clamp(interpolator.interpolate(val1.getRed(), val2.getRed(), progress)), (double)this.clamp(interpolator.interpolate(val1.getGreen(), val2.getGreen(), progress)), (double)this.clamp(interpolator.interpolate(val1.getBlue(), val2.getBlue(), progress)), (double)this.clamp(interpolator.interpolate(val1.getOpacity(), val2.getOpacity(), progress)));
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"color(\n                c\u2026ity, progress))\n        )");
        return color;
    }

    private final double clamp(double value) {
        return FXGLMath.clamp((float)value, 0.0f, 1.0f);
    }
}

