/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.animation;

import com.almasb.fxgl.animation.AnimatedValue;
import java.util.HashMap;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.animation.PathTransition;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/almasb/fxgl/animation/AnimatedPath;", "Lcom/almasb/fxgl/animation/AnimatedValue;", "Ljavafx/geometry/Point3D;", "path", "Ljavafx/scene/shape/Shape;", "(Ljavafx/scene/shape/Shape;)V", "getPath", "()Ljavafx/scene/shape/Shape;", "points", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "animate", "val1", "val2", "progress", "", "interpolator", "Ljavafx/animation/Interpolator;", "fxgl-core"})
public final class AnimatedPath
extends AnimatedValue<Point3D> {
    @NotNull
    private final Shape path;
    @NotNull
    private final HashMap<Integer, Point3D> points;

    public AnimatedPath(@NotNull Shape path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Point3D point3D = Point3D.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)point3D, (String)"ZERO");
        Point3D point3D2 = Point3D.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)point3D2, (String)"ZERO");
        super(point3D, point3D2);
        this.path = path;
        this.points = new HashMap();
        Rectangle dummy = new Rectangle();
        PathTransition pt = new PathTransition(Duration.seconds((double)1.0), this.path, (Node)dummy);
        pt.play();
        double t = 0.0;
        int percent = 0;
        while (t < 1.0) {
            ((Map)this.points).put(percent++, new Point3D(dummy.getTranslateX(), dummy.getTranslateY(), 0.0));
            pt.jumpTo(Duration.seconds((double)(t += 0.01)));
        }
        pt.jumpTo(Duration.seconds((double)1.0));
        Map map = this.points;
        Integer n = 0;
        Point3D point3D3 = this.points.get(1);
        Intrinsics.checkNotNull((Object)point3D3);
        map.put(n, point3D3);
        ((Map)this.points).put(100, new Point3D(dummy.getTranslateX(), dummy.getTranslateY(), 0.0));
    }

    @NotNull
    public final Shape getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Point3D animate(@NotNull Point3D val1, @NotNull Point3D val2, double progress, @NotNull Interpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)val1, (String)"val1");
        Intrinsics.checkNotNullParameter((Object)val2, (String)"val2");
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        double t = interpolator.interpolate(0.0, 1.0, progress);
        int key = (int)(t * (double)100);
        Point3D point3D = this.points.get(key);
        Intrinsics.checkNotNull((Object)point3D);
        return point3D;
    }
}

