/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.animation;

import com.almasb.fxgl.animation.AnimatedQuadBezierPoint2D;
import com.almasb.fxgl.animation.AnimatedValue;
import javafx.animation.Interpolator;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.shape.QuadCurve;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/almasb/fxgl/animation/AnimatedQuadBezierPoint3D;", "Lcom/almasb/fxgl/animation/AnimatedValue;", "Ljavafx/geometry/Point3D;", "path", "Ljavafx/scene/shape/QuadCurve;", "(Ljavafx/scene/shape/QuadCurve;)V", "animated2D", "Lcom/almasb/fxgl/animation/AnimatedQuadBezierPoint2D;", "getPath", "()Ljavafx/scene/shape/QuadCurve;", "animate", "val1", "val2", "progress", "", "interpolator", "Ljavafx/animation/Interpolator;", "fxgl-core"})
public final class AnimatedQuadBezierPoint3D
extends AnimatedValue<Point3D> {
    @NotNull
    private final QuadCurve path;
    @NotNull
    private final AnimatedQuadBezierPoint2D animated2D;

    public AnimatedQuadBezierPoint3D(@NotNull QuadCurve path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Point3D point3D = Point3D.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)point3D, (String)"ZERO");
        Point3D point3D2 = Point3D.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)point3D2, (String)"ZERO");
        super(point3D, point3D2);
        this.path = path;
        this.animated2D = new AnimatedQuadBezierPoint2D(this.path);
    }

    @NotNull
    public final QuadCurve getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Point3D animate(@NotNull Point3D val1, @NotNull Point3D val2, double progress, @NotNull Interpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)val1, (String)"val1");
        Intrinsics.checkNotNullParameter((Object)val2, (String)"val2");
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        Point2D p = this.animated2D.animate(new Point2D(val1.getX(), val1.getY()), new Point2D(val2.getX(), val2.getY()), progress, interpolator);
        return new Point3D(p.getX(), p.getY(), 0.0);
    }
}

