/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.animation;

import com.almasb.fxgl.animation.Animatable;
import com.almasb.fxgl.animation.AnimatedCubicBezierPoint3D;
import com.almasb.fxgl.animation.AnimatedPath;
import com.almasb.fxgl.animation.AnimatedPoint3D;
import com.almasb.fxgl.animation.AnimatedQuadBezierPoint3D;
import com.almasb.fxgl.animation.AnimatedValue;
import com.almasb.fxgl.animation.Animation;
import com.almasb.fxgl.animation.AnimationBuilderKt;
import com.almasb.fxgl.core.UpdatableRunner;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.core.util.EmptyRunnable;
import com.almasb.fxgl.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.animation.Interpolator;
import javafx.beans.value.WritableValue;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.Shape;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001:\u0007[\\]^_`aB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003B\u0013\b\u0007\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010,\u001a\b\u0012\u0004\u0012\u0002H.0-\"\u0004\b\u0000\u0010.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.00J \u0010,\u001a\b\u0012\u0004\u0012\u0002H.01\"\u0004\b\u0000\u0010.2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H.03J\u000e\u00104\u001a\u00020\u00002\u0006\u00104\u001a\u00020\u0017J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u000208J\u000e\u00105\u001a\u0002062\u0006\u00109\u001a\u00020:J5\u0010;\u001a\b\u0012\u0004\u0012\u0002H.0<\"\u0004\b\u0000\u0010.2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H.002\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H.0?H\u0000\u00a2\u0006\u0002\b@J+\u0010A\u001a\u0006\u0012\u0002\b\u00030<2\u001a\u0010B\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030<0C\"\u0006\u0012\u0002\b\u00030<\u00a2\u0006\u0002\u0010DJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\bJ\u001f\u0010E\u001a\u00020F2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u0002080C\"\u000208\u00a2\u0006\u0002\u0010HJ\u001f\u0010E\u001a\u00020F2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020:0C\"\u00020:\u00a2\u0006\u0002\u0010IJ\u0014\u0010E\u001a\u00020F2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00010JJ\u001f\u0010K\u001a\u00020F2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u0002080C\"\u000208\u00a2\u0006\u0002\u0010HJ\u001f\u0010K\u001a\u00020F2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020:0C\"\u00020:\u00a2\u0006\u0002\u0010IJ\u001f\u0010L\u001a\u00020F2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u0002080C\"\u000208\u00a2\u0006\u0002\u0010HJ\u001f\u0010L\u001a\u00020F2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020:0C\"\u00020:\u00a2\u0006\u0002\u0010IJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u001cJ\u000e\u0010M\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\u0006\u0010N\u001a\u00020\u0000J\u001f\u0010O\u001a\u00020P2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u0002080C\"\u000208\u00a2\u0006\u0002\u0010QJ\u001f\u0010O\u001a\u00020P2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020:0C\"\u00020:\u00a2\u0006\u0002\u0010RJ\u0014\u0010O\u001a\u00020P2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00010JJ\u001f\u0010S\u001a\u00020T2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u0002080C\"\u000208\u00a2\u0006\u0002\u0010UJ\u001f\u0010S\u001a\u00020T2\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020:0C\"\u00020:\u00a2\u0006\u0002\u0010VJ\u0014\u0010S\u001a\u00020T2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00010JJ\u0010\u0010W\u001a\u0002082\u0006\u00107\u001a\u00020\u0001H\u0002J\u001f\u0010X\u001a\u0002062\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u0002080C\"\u000208\u00a2\u0006\u0002\u0010YJ\u001f\u0010X\u001a\u0002062\u0012\u0010G\u001a\n\u0012\u0006\b\u0001\u0012\u00020:0C\"\u00020:\u00a2\u0006\u0002\u0010ZJ\u0014\u0010X\u001a\u0002062\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00010JR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006b"}, d2={"Lcom/almasb/fxgl/animation/AnimationBuilder;", "", "copy", "(Lcom/almasb/fxgl/animation/AnimationBuilder;)V", "scene", "Lcom/almasb/fxgl/core/UpdatableRunner;", "(Lcom/almasb/fxgl/core/UpdatableRunner;)V", "delay", "Ljavafx/util/Duration;", "getDelay", "()Ljavafx/util/Duration;", "setDelay", "(Ljavafx/util/Duration;)V", "duration", "getDuration", "setDuration", "interpolator", "Ljavafx/animation/Interpolator;", "getInterpolator", "()Ljavafx/animation/Interpolator;", "setInterpolator", "(Ljavafx/animation/Interpolator;)V", "isAutoReverse", "", "()Z", "setAutoReverse", "(Z)V", "onCycleFinished", "Ljava/lang/Runnable;", "getOnCycleFinished", "()Ljava/lang/Runnable;", "setOnCycleFinished", "(Ljava/lang/Runnable;)V", "onFinished", "getOnFinished", "setOnFinished", "getScene", "()Lcom/almasb/fxgl/core/UpdatableRunner;", "times", "", "getTimes", "()I", "setTimes", "(I)V", "animate", "Lcom/almasb/fxgl/animation/AnimationBuilder$GenericAnimationBuilder;", "T", "value", "Lcom/almasb/fxgl/animation/AnimatedValue;", "Lcom/almasb/fxgl/animation/AnimationBuilder$PropertyAnimationBuilder;", "property", "Ljavafx/beans/value/WritableValue;", "autoReverse", "bobbleDown", "Lcom/almasb/fxgl/animation/AnimationBuilder$TranslationAnimationBuilder;", "obj", "Lcom/almasb/fxgl/animation/Animatable;", "node", "Ljavafx/scene/Node;", "buildAnimation", "Lcom/almasb/fxgl/animation/Animation;", "animatedValue", "onProgress", "Ljava/util/function/Consumer;", "buildAnimation$fxgl_core", "buildSequence", "anims", "", "([Lcom/almasb/fxgl/animation/Animation;)Lcom/almasb/fxgl/animation/Animation;", "fade", "Lcom/almasb/fxgl/animation/AnimationBuilder$FadeAnimationBuilder;", "entities", "([Lcom/almasb/fxgl/animation/Animatable;)Lcom/almasb/fxgl/animation/AnimationBuilder$FadeAnimationBuilder;", "([Ljavafx/scene/Node;)Lcom/almasb/fxgl/animation/AnimationBuilder$FadeAnimationBuilder;", "", "fadeIn", "fadeOut", "repeat", "repeatInfinitely", "rotate", "Lcom/almasb/fxgl/animation/AnimationBuilder$RotationAnimationBuilder;", "([Lcom/almasb/fxgl/animation/Animatable;)Lcom/almasb/fxgl/animation/AnimationBuilder$RotationAnimationBuilder;", "([Ljavafx/scene/Node;)Lcom/almasb/fxgl/animation/AnimationBuilder$RotationAnimationBuilder;", "scale", "Lcom/almasb/fxgl/animation/AnimationBuilder$ScaleAnimationBuilder;", "([Lcom/almasb/fxgl/animation/Animatable;)Lcom/almasb/fxgl/animation/AnimationBuilder$ScaleAnimationBuilder;", "([Ljavafx/scene/Node;)Lcom/almasb/fxgl/animation/AnimationBuilder$ScaleAnimationBuilder;", "toAnimatable", "translate", "([Lcom/almasb/fxgl/animation/Animatable;)Lcom/almasb/fxgl/animation/AnimationBuilder$TranslationAnimationBuilder;", "([Ljavafx/scene/Node;)Lcom/almasb/fxgl/animation/AnimationBuilder$TranslationAnimationBuilder;", "AM", "FadeAnimationBuilder", "GenericAnimationBuilder", "PropertyAnimationBuilder", "RotationAnimationBuilder", "ScaleAnimationBuilder", "TranslationAnimationBuilder", "fxgl-core"})
@SourceDebugExtension(value={"SMAP\nAnimationBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationBuilder.kt\ncom/almasb/fxgl/animation/AnimationBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,621:1\n11335#2:622\n11670#2,3:623\n11335#2:630\n11670#2,3:631\n11335#2:638\n11670#2,3:639\n11335#2:646\n11670#2,3:647\n11335#2:654\n11670#2,3:655\n11335#2:658\n11670#2,3:659\n13579#2,2:662\n1549#3:626\n1620#3,3:627\n1549#3:634\n1620#3,3:635\n1549#3:642\n1620#3,3:643\n1549#3:650\n1620#3,3:651\n1855#3,2:665\n1#4:664\n215#5,2:667\n*S KotlinDebug\n*F\n+ 1 AnimationBuilder.kt\ncom/almasb/fxgl/animation/AnimationBuilder\n*L\n113#1:622\n113#1:623,3\n125#1:630\n125#1:631,3\n137#1:638\n137#1:639,3\n149#1:646\n149#1:647,3\n167#1:654\n167#1:655,3\n175#1:658\n175#1:659,3\n192#1:662,2\n117#1:626\n117#1:627,3\n129#1:634\n129#1:635,3\n141#1:642\n141#1:643,3\n153#1:650\n153#1:651,3\n213#1:665,2\n226#1:667,2\n*E\n"})
public class AnimationBuilder {
    @Nullable
    private final UpdatableRunner scene;
    @NotNull
    private Duration duration;
    @NotNull
    private Duration delay;
    @NotNull
    private Interpolator interpolator;
    private int times;
    @NotNull
    private Runnable onCycleFinished;
    private boolean isAutoReverse;
    @NotNull
    private Runnable onFinished;

    @JvmOverloads
    public AnimationBuilder(@Nullable UpdatableRunner scene) {
        this.scene = scene;
        Duration duration = Duration.seconds((double)1.0);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"seconds(1.0)");
        this.duration = duration;
        Duration duration2 = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
        this.delay = duration2;
        Interpolator interpolator = Interpolator.LINEAR;
        Intrinsics.checkNotNullExpressionValue((Object)interpolator, (String)"LINEAR");
        this.interpolator = interpolator;
        this.times = 1;
        this.onCycleFinished = EmptyRunnable.INSTANCE;
        this.onFinished = EmptyRunnable.INSTANCE;
    }

    public /* synthetic */ AnimationBuilder(UpdatableRunner updatableRunner, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            updatableRunner = null;
        }
        this(updatableRunner);
    }

    @Nullable
    protected final UpdatableRunner getScene() {
        return this.scene;
    }

    @NotNull
    public final Duration getDuration() {
        return this.duration;
    }

    public final void setDuration(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.duration = duration;
    }

    @NotNull
    public final Duration getDelay() {
        return this.delay;
    }

    public final void setDelay(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.delay = duration;
    }

    @NotNull
    public final Interpolator getInterpolator() {
        return this.interpolator;
    }

    public final void setInterpolator(@NotNull Interpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"<set-?>");
        this.interpolator = interpolator;
    }

    public final int getTimes() {
        return this.times;
    }

    public final void setTimes(int n) {
        this.times = n;
    }

    @NotNull
    public final Runnable getOnCycleFinished() {
        return this.onCycleFinished;
    }

    public final void setOnCycleFinished(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"<set-?>");
        this.onCycleFinished = runnable;
    }

    public final boolean isAutoReverse() {
        return this.isAutoReverse;
    }

    public final void setAutoReverse(boolean bl) {
        this.isAutoReverse = bl;
    }

    @NotNull
    public final Runnable getOnFinished() {
        return this.onFinished;
    }

    public final void setOnFinished(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"<set-?>");
        this.onFinished = runnable;
    }

    public AnimationBuilder(@NotNull AnimationBuilder copy) {
        Intrinsics.checkNotNullParameter((Object)copy, (String)"copy");
        this(copy.scene);
        this.duration = copy.duration;
        this.delay = copy.delay;
        this.interpolator = copy.interpolator;
        this.times = copy.times;
        this.onFinished = copy.onFinished;
        this.onCycleFinished = copy.onCycleFinished;
        this.isAutoReverse = copy.isAutoReverse;
    }

    @NotNull
    public final AnimationBuilder duration(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this.duration = duration;
        return this;
    }

    @NotNull
    public final AnimationBuilder delay(@NotNull Duration delay) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        this.delay = delay;
        return this;
    }

    @NotNull
    public final AnimationBuilder interpolator(@NotNull Interpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        this.interpolator = interpolator;
        return this;
    }

    @NotNull
    public final AnimationBuilder repeat(int times) {
        this.times = times;
        return this;
    }

    @NotNull
    public final AnimationBuilder repeatInfinitely() {
        return this.repeat(Integer.MAX_VALUE);
    }

    @NotNull
    public final AnimationBuilder onCycleFinished(@NotNull Runnable onCycleFinished) {
        Intrinsics.checkNotNullParameter((Object)onCycleFinished, (String)"onCycleFinished");
        this.onCycleFinished = onCycleFinished;
        return this;
    }

    @NotNull
    public final AnimationBuilder autoReverse(boolean autoReverse) {
        this.isAutoReverse = autoReverse;
        return this;
    }

    @NotNull
    public final AnimationBuilder onFinished(@NotNull Runnable onFinished) {
        Intrinsics.checkNotNullParameter((Object)onFinished, (String)"onFinished");
        this.onFinished = onFinished;
        return this;
    }

    @NotNull
    public final <T> Animation<T> buildAnimation$fxgl_core(@NotNull AnimatedValue<T> animatedValue, @NotNull Consumer<T> onProgress) {
        Intrinsics.checkNotNullParameter(animatedValue, (String)"animatedValue");
        Intrinsics.checkNotNullParameter(onProgress, (String)"onProgress");
        return new Animation<T>(this, animatedValue, onProgress){
            final /* synthetic */ Consumer<T> $onProgress;
            {
                this.$onProgress = $onProgress;
                super($receiver, $animatedValue);
            }

            public void onProgress(T value) {
                this.$onProgress.accept(value);
            }
        };
    }

    @NotNull
    public final <T> GenericAnimationBuilder<T> animate(@NotNull AnimatedValue<T> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return new GenericAnimationBuilder<T>(this, value);
    }

    @NotNull
    public final <T> PropertyAnimationBuilder<T> animate(@NotNull WritableValue<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return new PropertyAnimationBuilder<T>(this, property);
    }

    @NotNull
    public final TranslationAnimationBuilder translate(Animatable ... entities) {
        TranslationAnimationBuilder translationAnimationBuilder;
        Intrinsics.checkNotNullParameter((Object)entities, (String)"entities");
        TranslationAnimationBuilder $this$translate_u24lambda_u240 = translationAnimationBuilder = new TranslationAnimationBuilder(this);
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$translate_u24lambda_u240.getObjects(), (Object[])entities);
        return translationAnimationBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TranslationAnimationBuilder translate(Node ... entities) {
        void $this$mapTo$iv$iv;
        TranslationAnimationBuilder translationAnimationBuilder;
        Intrinsics.checkNotNullParameter((Object)entities, (String)"entities");
        TranslationAnimationBuilder $this$translate_u24lambda_u242 = translationAnimationBuilder = new TranslationAnimationBuilder(this);
        boolean bl = false;
        Collection collection = $this$translate_u24lambda_u242.getObjects();
        Node[] $this$map$iv = entities;
        boolean $i$f$map = false;
        Node[] nodeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(AnimationBuilderKt.access$toAnimatable((Node)it));
        }
        Iterable iterable = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return translationAnimationBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TranslationAnimationBuilder translate(@NotNull Collection<? extends Object> entities) {
        void $this$mapTo$iv$iv;
        TranslationAnimationBuilder translationAnimationBuilder;
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        TranslationAnimationBuilder $this$translate_u24lambda_u244 = translationAnimationBuilder = new TranslationAnimationBuilder(this);
        boolean bl = false;
        Collection collection = $this$translate_u24lambda_u244.getObjects();
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(this.toAnimatable(it));
        }
        Iterable iterable2 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
        return translationAnimationBuilder;
    }

    @NotNull
    public final FadeAnimationBuilder fade(Animatable ... entities) {
        FadeAnimationBuilder fadeAnimationBuilder;
        Intrinsics.checkNotNullParameter((Object)entities, (String)"entities");
        FadeAnimationBuilder $this$fade_u24lambda_u245 = fadeAnimationBuilder = new FadeAnimationBuilder(this);
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$fade_u24lambda_u245.getObjects(), (Object[])entities);
        return fadeAnimationBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FadeAnimationBuilder fade(Node ... entities) {
        void $this$mapTo$iv$iv;
        FadeAnimationBuilder fadeAnimationBuilder;
        Intrinsics.checkNotNullParameter((Object)entities, (String)"entities");
        FadeAnimationBuilder $this$fade_u24lambda_u247 = fadeAnimationBuilder = new FadeAnimationBuilder(this);
        boolean bl = false;
        Collection collection = $this$fade_u24lambda_u247.getObjects();
        Node[] $this$map$iv = entities;
        boolean $i$f$map = false;
        Node[] nodeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(AnimationBuilderKt.access$toAnimatable((Node)it));
        }
        Iterable iterable = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return fadeAnimationBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FadeAnimationBuilder fade(@NotNull Collection<? extends Object> entities) {
        void $this$mapTo$iv$iv;
        FadeAnimationBuilder fadeAnimationBuilder;
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        FadeAnimationBuilder $this$fade_u24lambda_u249 = fadeAnimationBuilder = new FadeAnimationBuilder(this);
        boolean bl = false;
        Collection collection = $this$fade_u24lambda_u249.getObjects();
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(this.toAnimatable(it));
        }
        Iterable iterable2 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
        return fadeAnimationBuilder;
    }

    @NotNull
    public final ScaleAnimationBuilder scale(Animatable ... entities) {
        ScaleAnimationBuilder scaleAnimationBuilder;
        Intrinsics.checkNotNullParameter((Object)entities, (String)"entities");
        ScaleAnimationBuilder $this$scale_u24lambda_u2410 = scaleAnimationBuilder = new ScaleAnimationBuilder(this);
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$scale_u24lambda_u2410.getObjects(), (Object[])entities);
        return scaleAnimationBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScaleAnimationBuilder scale(Node ... entities) {
        void $this$mapTo$iv$iv;
        ScaleAnimationBuilder scaleAnimationBuilder;
        Intrinsics.checkNotNullParameter((Object)entities, (String)"entities");
        ScaleAnimationBuilder $this$scale_u24lambda_u2412 = scaleAnimationBuilder = new ScaleAnimationBuilder(this);
        boolean bl = false;
        Collection collection = $this$scale_u24lambda_u2412.getObjects();
        Node[] $this$map$iv = entities;
        boolean $i$f$map = false;
        Node[] nodeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(AnimationBuilderKt.access$toAnimatable((Node)it));
        }
        Iterable iterable = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return scaleAnimationBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScaleAnimationBuilder scale(@NotNull Collection<? extends Object> entities) {
        void $this$mapTo$iv$iv;
        ScaleAnimationBuilder scaleAnimationBuilder;
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        ScaleAnimationBuilder $this$scale_u24lambda_u2414 = scaleAnimationBuilder = new ScaleAnimationBuilder(this);
        boolean bl = false;
        Collection collection = $this$scale_u24lambda_u2414.getObjects();
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(this.toAnimatable(it));
        }
        Iterable iterable2 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
        return scaleAnimationBuilder;
    }

    @NotNull
    public final RotationAnimationBuilder rotate(Animatable ... entities) {
        RotationAnimationBuilder rotationAnimationBuilder;
        Intrinsics.checkNotNullParameter((Object)entities, (String)"entities");
        RotationAnimationBuilder $this$rotate_u24lambda_u2415 = rotationAnimationBuilder = new RotationAnimationBuilder(this);
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$rotate_u24lambda_u2415.getObjects(), (Object[])entities);
        return rotationAnimationBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RotationAnimationBuilder rotate(Node ... entities) {
        void $this$mapTo$iv$iv;
        RotationAnimationBuilder rotationAnimationBuilder;
        Intrinsics.checkNotNullParameter((Object)entities, (String)"entities");
        RotationAnimationBuilder $this$rotate_u24lambda_u2417 = rotationAnimationBuilder = new RotationAnimationBuilder(this);
        boolean bl = false;
        Collection collection = $this$rotate_u24lambda_u2417.getObjects();
        Node[] $this$map$iv = entities;
        boolean $i$f$map = false;
        Node[] nodeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(AnimationBuilderKt.access$toAnimatable((Node)it));
        }
        Iterable iterable = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return rotationAnimationBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RotationAnimationBuilder rotate(@NotNull Collection<? extends Object> entities) {
        void $this$mapTo$iv$iv;
        RotationAnimationBuilder rotationAnimationBuilder;
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        RotationAnimationBuilder $this$rotate_u24lambda_u2419 = rotationAnimationBuilder = new RotationAnimationBuilder(this);
        boolean bl = false;
        Collection collection = $this$rotate_u24lambda_u2419.getObjects();
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(this.toAnimatable(it));
        }
        Iterable iterable2 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
        return rotationAnimationBuilder;
    }

    private final Animatable toAnimatable(Object obj) {
        Animatable animatable;
        Object object = obj;
        if (object instanceof Node) {
            animatable = AnimationBuilderKt.access$toAnimatable((Node)obj);
        } else if (object instanceof Animatable) {
            animatable = (Animatable)obj;
        } else {
            throw new IllegalArgumentException(obj.getClass() + " must be Node or Animatable");
        }
        return animatable;
    }

    @NotNull
    public final FadeAnimationBuilder fadeIn(Animatable ... entities) {
        FadeAnimationBuilder fadeAnimationBuilder;
        Intrinsics.checkNotNullParameter((Object)entities, (String)"entities");
        FadeAnimationBuilder $this$fadeIn_u24lambda_u2420 = fadeAnimationBuilder = new FadeAnimationBuilder(this);
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$fadeIn_u24lambda_u2420.getObjects(), (Object[])entities);
        return fadeAnimationBuilder.from(0.0).to(1.0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FadeAnimationBuilder fadeIn(Node ... entities) {
        void $this$mapTo$iv$iv;
        FadeAnimationBuilder fadeAnimationBuilder;
        Intrinsics.checkNotNullParameter((Object)entities, (String)"entities");
        FadeAnimationBuilder $this$fadeIn_u24lambda_u2422 = fadeAnimationBuilder = new FadeAnimationBuilder(this);
        boolean bl = false;
        Collection collection = $this$fadeIn_u24lambda_u2422.getObjects();
        Node[] $this$map$iv = entities;
        boolean $i$f$map = false;
        Node[] nodeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(AnimationBuilderKt.access$toAnimatable((Node)it));
        }
        Iterable iterable = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return fadeAnimationBuilder.from(0.0).to(1.0);
    }

    @NotNull
    public final FadeAnimationBuilder fadeOut(Animatable ... entities) {
        FadeAnimationBuilder fadeAnimationBuilder;
        Intrinsics.checkNotNullParameter((Object)entities, (String)"entities");
        FadeAnimationBuilder $this$fadeOut_u24lambda_u2423 = fadeAnimationBuilder = new FadeAnimationBuilder(this);
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$fadeOut_u24lambda_u2423.getObjects(), (Object[])entities);
        return fadeAnimationBuilder.from(1.0).to(0.0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FadeAnimationBuilder fadeOut(Node ... entities) {
        void $this$mapTo$iv$iv;
        FadeAnimationBuilder fadeAnimationBuilder;
        Intrinsics.checkNotNullParameter((Object)entities, (String)"entities");
        FadeAnimationBuilder $this$fadeOut_u24lambda_u2425 = fadeAnimationBuilder = new FadeAnimationBuilder(this);
        boolean bl = false;
        Collection collection = $this$fadeOut_u24lambda_u2425.getObjects();
        Node[] $this$map$iv = entities;
        boolean $i$f$map = false;
        Node[] nodeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var14_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(AnimationBuilderKt.access$toAnimatable((Node)it));
        }
        Iterable iterable = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return fadeAnimationBuilder.from(1.0).to(0.0);
    }

    @NotNull
    public final TranslationAnimationBuilder bobbleDown(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.bobbleDown(AnimationBuilderKt.access$toAnimatable(node));
    }

    @NotNull
    public final TranslationAnimationBuilder bobbleDown(@NotNull Animatable obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Duration duration = Duration.seconds((double)0.15);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"seconds(0.15)");
        Animatable[] animatableArray = new Animatable[]{obj};
        TranslationAnimationBuilder translationAnimationBuilder = this.duration(duration).autoReverse(true).repeat(2).translate(animatableArray);
        Double d = obj.xProperty().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d, (String)"obj.xProperty().value");
        double d2 = ((Number)d).doubleValue();
        Double d3 = obj.yProperty().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"obj.yProperty().value");
        TranslationAnimationBuilder translationAnimationBuilder2 = translationAnimationBuilder.from(new Point2D(d2, ((Number)d3).doubleValue()));
        Double d4 = obj.xProperty().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)d4, (String)"obj.xProperty().value");
        return translationAnimationBuilder2.to(new Point2D(((Number)d4).doubleValue(), obj.yProperty().getValue() + 5.0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Animation<?> buildSequence(Animation<?> ... anims) {
        Intrinsics.checkNotNullParameter(anims, (String)"anims");
        LinkedHashMap ranges = new LinkedHashMap();
        double count = 0.0;
        Animation<?>[] $this$forEach$iv = anims;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Animation<?> element$iv;
            Animation<?> anim = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            ((Map)ranges).put(RangesKt.rangeTo((double)count, (double)(count + anim.getEndTime())), anim);
            count += anim.getEndTime();
        }
        Animation<?>[] animationArray = anims;
        double d = 0.0;
        int n2 = animationArray.length;
        for (int i = 0; i < n2; ++i) {
            void it;
            Animation<?> animation;
            Animation<?> animation2 = animation = animationArray[i];
            double d2 = d;
            boolean bl = false;
            double d3 = it.getEndTime();
            d = d2 + d3;
        }
        double totalDuration = d;
        Ref.BooleanRef isNewCycle = new Ref.BooleanRef();
        isNewCycle.element = true;
        Ref.ObjectRef a = new Ref.ObjectRef();
        AnimationBuilder animationBuilder = this.onCycleFinished(() -> AnimationBuilder.buildSequence$lambda$28(isNewCycle));
        Duration duration = Duration.seconds((double)totalDuration);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"seconds(totalDuration)");
        a.element = animationBuilder.duration(duration).animate(new AnimatedValue<Double>(0.0, totalDuration)).onProgress(arg_0 -> AnimationBuilder.buildSequence$lambda$31(isNewCycle, ranges, a, arg_0)).build();
        return (Animation)a.element;
    }

    @JvmOverloads
    public AnimationBuilder() {
        this(null, 1, null);
    }

    private static final void buildSequence$lambda$28(Ref.BooleanRef $isNewCycle) {
        Intrinsics.checkNotNullParameter((Object)$isNewCycle, (String)"$isNewCycle");
        $isNewCycle.element = true;
    }

    private static final void buildSequence$lambda$31(Ref.BooleanRef $isNewCycle, LinkedHashMap $ranges, Ref.ObjectRef $a, Double time) {
        Map.Entry element$iv;
        Iterator iterator;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$isNewCycle, (String)"$isNewCycle");
        Intrinsics.checkNotNullParameter((Object)$ranges, (String)"$ranges");
        Intrinsics.checkNotNullParameter((Object)$a, (String)"$a");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        if ($isNewCycle.element) {
            Collection collection = $ranges.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"ranges.values");
            $this$forEach$iv = collection;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                Animation it = (Animation)((Object)element$iv);
                boolean bl = false;
                it.stop();
                Object object = $a.element;
                Intrinsics.checkNotNull((Object)object);
                if (((Animation)object).isReverse()) {
                    it.startReverse();
                    continue;
                }
                it.start();
            }
            $isNewCycle.element = false;
        }
        $this$forEach$iv = $ranges;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            ClosedFloatingPointRange range = (ClosedFloatingPointRange)entry.getKey();
            Animation anim = (Animation)entry.getValue();
            if (!range.contains((Comparable)time)) continue;
            double mappedTime = FXGLMath.map(time, ((Number)((Object)range.getStart())).doubleValue(), ((Number)((Object)range.getEndInclusive())).doubleValue(), 0.0, anim.getEndTime());
            anim.setTimeTo(mappedTime);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\f\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH&J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/almasb/fxgl/animation/AnimationBuilder$AM;", "Lcom/almasb/fxgl/animation/AnimationBuilder;", "animationBuilder", "(Lcom/almasb/fxgl/animation/AnimationBuilder;)V", "objects", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/animation/Animatable;", "Lkotlin/collections/ArrayList;", "getObjects", "()Ljava/util/ArrayList;", "build", "Lcom/almasb/fxgl/animation/Animation;", "buildAndPlay", "", "scene", "Lcom/almasb/fxgl/core/UpdatableRunner;", "fxgl-core"})
    public static abstract class AM
    extends AnimationBuilder {
        @NotNull
        private final AnimationBuilder animationBuilder;
        @NotNull
        private final ArrayList<Animatable> objects;

        public AM(@NotNull AnimationBuilder animationBuilder) {
            Intrinsics.checkNotNullParameter((Object)animationBuilder, (String)"animationBuilder");
            super(animationBuilder);
            this.animationBuilder = animationBuilder;
            this.objects = new ArrayList();
        }

        @NotNull
        public final ArrayList<Animatable> getObjects() {
            return this.objects;
        }

        @NotNull
        public abstract Animation<?> build();

        public final void buildAndPlay() {
            if (this.animationBuilder.getScene() != null) {
                this.buildAndPlay(this.animationBuilder.getScene());
            } else {
                Logger.Companion.get(this.getClass()).warning("No game scene was set to AnimationBuilder");
            }
        }

        public final void buildAndPlay(@NotNull UpdatableRunner scene) {
            Animation<?> animation;
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            Animation<?> animation2 = animation = this.build();
            boolean bl = false;
            animation2.setOnFinished(() -> AM.buildAndPlay$lambda$1$lambda$0(scene, animation2, this));
            animation2.start();
            scene.addListener(animation2);
        }

        private static final void buildAndPlay$lambda$1$lambda$0(UpdatableRunner $scene, Animation $animation, AM this$0) {
            Intrinsics.checkNotNullParameter((Object)$scene, (String)"$scene");
            Intrinsics.checkNotNullParameter((Object)$animation, (String)"$animation");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            $scene.removeListener($animation);
            this$0.getOnFinished().run();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/almasb/fxgl/animation/AnimationBuilder$FadeAnimationBuilder;", "Lcom/almasb/fxgl/animation/AnimationBuilder$AM;", "animationBuilder", "Lcom/almasb/fxgl/animation/AnimationBuilder;", "(Lcom/almasb/fxgl/animation/AnimationBuilder;)V", "from", "", "to", "build", "Lcom/almasb/fxgl/animation/Animation;", "start", "end", "fxgl-core"})
    @SourceDebugExtension(value={"SMAP\nAnimationBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationBuilder.kt\ncom/almasb/fxgl/animation/AnimationBuilder$FadeAnimationBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,621:1\n1855#2,2:622\n*S KotlinDebug\n*F\n+ 1 AnimationBuilder.kt\ncom/almasb/fxgl/animation/AnimationBuilder$FadeAnimationBuilder\n*L\n347#1:622,2\n*E\n"})
    public static final class FadeAnimationBuilder
    extends AM {
        private double from;
        private double to;

        public FadeAnimationBuilder(@NotNull AnimationBuilder animationBuilder) {
            Intrinsics.checkNotNullParameter((Object)animationBuilder, (String)"animationBuilder");
            super(animationBuilder);
        }

        @NotNull
        public final FadeAnimationBuilder from(double start) {
            FadeAnimationBuilder fadeAnimationBuilder;
            FadeAnimationBuilder it = fadeAnimationBuilder = this;
            boolean bl = false;
            this.from = start;
            return fadeAnimationBuilder;
        }

        @NotNull
        public final FadeAnimationBuilder to(double end) {
            FadeAnimationBuilder fadeAnimationBuilder;
            FadeAnimationBuilder it = fadeAnimationBuilder = this;
            boolean bl = false;
            this.to = end;
            return fadeAnimationBuilder;
        }

        @Override
        @NotNull
        public Animation<?> build() {
            return this.buildAnimation$fxgl_core(new AnimatedValue<Double>(this.from, this.to), arg_0 -> FadeAnimationBuilder.build$lambda$3(this, arg_0));
        }

        private static final void build$lambda$3(FadeAnimationBuilder this$0, Double value) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Iterable $this$forEach$iv = this$0.getObjects();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Animatable it = (Animatable)element$iv;
                boolean bl = false;
                it.opacityProperty().setValue((Number)value);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/almasb/fxgl/animation/AnimationBuilder$GenericAnimationBuilder;", "T", "Lcom/almasb/fxgl/animation/AnimationBuilder$AM;", "animationBuilder", "Lcom/almasb/fxgl/animation/AnimationBuilder;", "animValue", "Lcom/almasb/fxgl/animation/AnimatedValue;", "(Lcom/almasb/fxgl/animation/AnimationBuilder;Lcom/almasb/fxgl/animation/AnimatedValue;)V", "getAnimValue", "()Lcom/almasb/fxgl/animation/AnimatedValue;", "progressConsumer", "Ljava/util/function/Consumer;", "build", "Lcom/almasb/fxgl/animation/Animation;", "onProgress", "fxgl-core"})
    public static final class GenericAnimationBuilder<T>
    extends AM {
        @NotNull
        private final AnimatedValue<T> animValue;
        @NotNull
        private Consumer<T> progressConsumer;

        public GenericAnimationBuilder(@NotNull AnimationBuilder animationBuilder, @NotNull AnimatedValue<T> animValue) {
            Intrinsics.checkNotNullParameter((Object)animationBuilder, (String)"animationBuilder");
            Intrinsics.checkNotNullParameter(animValue, (String)"animValue");
            super(animationBuilder);
            this.animValue = animValue;
            this.progressConsumer = GenericAnimationBuilder::progressConsumer$lambda$0;
        }

        @NotNull
        public final AnimatedValue<T> getAnimValue() {
            return this.animValue;
        }

        @NotNull
        public final GenericAnimationBuilder<T> onProgress(@NotNull Consumer<T> progressConsumer) {
            Intrinsics.checkNotNullParameter(progressConsumer, (String)"progressConsumer");
            this.progressConsumer = progressConsumer;
            return this;
        }

        @NotNull
        public Animation<T> build() {
            return this.buildAnimation$fxgl_core(this.animValue, this.progressConsumer);
        }

        private static final void progressConsumer$lambda$0(Object it) {
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0016J\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010R\u0010\u0010\b\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00028\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/almasb/fxgl/animation/AnimationBuilder$PropertyAnimationBuilder;", "T", "Lcom/almasb/fxgl/animation/AnimationBuilder$AM;", "animationBuilder", "Lcom/almasb/fxgl/animation/AnimationBuilder;", "property", "Ljavafx/beans/value/WritableValue;", "(Lcom/almasb/fxgl/animation/AnimationBuilder;Ljavafx/beans/value/WritableValue;)V", "endValue", "Ljava/lang/Object;", "progressConsumer", "Ljava/util/function/Consumer;", "startValue", "build", "Lcom/almasb/fxgl/animation/Animation;", "from", "(Ljava/lang/Object;)Lcom/almasb/fxgl/animation/AnimationBuilder$PropertyAnimationBuilder;", "to", "fxgl-core"})
    public static final class PropertyAnimationBuilder<T>
    extends AM {
        @NotNull
        private final WritableValue<T> property;
        private T startValue;
        private T endValue;
        @NotNull
        private Consumer<T> progressConsumer;

        public PropertyAnimationBuilder(@NotNull AnimationBuilder animationBuilder, @NotNull WritableValue<T> property) {
            Intrinsics.checkNotNullParameter((Object)animationBuilder, (String)"animationBuilder");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            super(animationBuilder);
            this.property = property;
            this.startValue = this.property.getValue();
            this.endValue = this.property.getValue();
            this.progressConsumer = arg_0 -> PropertyAnimationBuilder.progressConsumer$lambda$0(this, arg_0);
        }

        @NotNull
        public final PropertyAnimationBuilder<T> from(T startValue) {
            this.startValue = startValue;
            return this;
        }

        @NotNull
        public final PropertyAnimationBuilder<T> to(T endValue) {
            this.endValue = endValue;
            return this;
        }

        @NotNull
        public Animation<T> build() {
            return this.buildAnimation$fxgl_core(new AnimatedValue<T>(this.startValue, this.endValue), this.progressConsumer);
        }

        private static final void progressConsumer$lambda$0(PropertyAnimationBuilder this$0, Object it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.property.setValue(it);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0013J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0011R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/almasb/fxgl/animation/AnimationBuilder$RotationAnimationBuilder;", "Lcom/almasb/fxgl/animation/AnimationBuilder$AM;", "animationBuilder", "Lcom/almasb/fxgl/animation/AnimationBuilder;", "(Lcom/almasb/fxgl/animation/AnimationBuilder;)V", "endRotation", "Ljavafx/geometry/Point3D;", "kotlin.jvm.PlatformType", "is3DAnimation", "", "rotationOrigin", "startRotation", "build", "Lcom/almasb/fxgl/animation/Animation;", "from", "start", "startAngle", "", "origin", "Ljavafx/geometry/Point2D;", "to", "end", "endAngle", "fxgl-core"})
    @SourceDebugExtension(value={"SMAP\nAnimationBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationBuilder.kt\ncom/almasb/fxgl/animation/AnimationBuilder$RotationAnimationBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,621:1\n1855#2,2:622\n1855#2,2:624\n1855#2,2:626\n*S KotlinDebug\n*F\n+ 1 AnimationBuilder.kt\ncom/almasb/fxgl/animation/AnimationBuilder$RotationAnimationBuilder\n*L\n455#1:622,2\n461#1:624,2\n468#1:626,2\n*E\n"})
    public static final class RotationAnimationBuilder
    extends AM {
        private boolean is3DAnimation;
        private Point3D startRotation;
        private Point3D endRotation;
        @Nullable
        private Point3D rotationOrigin;

        public RotationAnimationBuilder(@NotNull AnimationBuilder animationBuilder) {
            Intrinsics.checkNotNullParameter((Object)animationBuilder, (String)"animationBuilder");
            super(animationBuilder);
            this.startRotation = Point3D.ZERO;
            this.endRotation = Point3D.ZERO;
        }

        @NotNull
        public final RotationAnimationBuilder from(double startAngle) {
            this.is3DAnimation = false;
            this.startRotation = new Point3D(0.0, 0.0, startAngle);
            return this;
        }

        @NotNull
        public final RotationAnimationBuilder to(double endAngle) {
            this.is3DAnimation = false;
            this.endRotation = new Point3D(0.0, 0.0, endAngle);
            return this;
        }

        @NotNull
        public final RotationAnimationBuilder from(@NotNull Point3D start) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            this.is3DAnimation = true;
            this.startRotation = start;
            return this;
        }

        @NotNull
        public final RotationAnimationBuilder to(@NotNull Point3D end) {
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            this.is3DAnimation = true;
            this.endRotation = end;
            return this;
        }

        @NotNull
        public final RotationAnimationBuilder origin(@NotNull Point2D rotationOrigin) {
            Intrinsics.checkNotNullParameter((Object)rotationOrigin, (String)"rotationOrigin");
            this.rotationOrigin = new Point3D(rotationOrigin.getX(), rotationOrigin.getY(), 0.0);
            return this;
        }

        @NotNull
        public final RotationAnimationBuilder origin(@NotNull Point3D rotationOrigin) {
            Intrinsics.checkNotNullParameter((Object)rotationOrigin, (String)"rotationOrigin");
            this.rotationOrigin = rotationOrigin;
            return this;
        }

        @Override
        @NotNull
        public Animation<?> build() {
            block3: {
                if (this.is3DAnimation) {
                    Iterable $this$forEach$iv = this.getObjects();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Animatable it = (Animatable)element$iv;
                        boolean bl = false;
                        Point3D point3D = Point3D.ZERO;
                        Intrinsics.checkNotNullExpressionValue((Object)point3D, (String)"ZERO");
                        it.setRotationOrigin(point3D);
                    }
                }
                Point3D point3D = this.rotationOrigin;
                if (point3D == null) break block3;
                Point3D origin = point3D;
                boolean bl = false;
                Iterable $this$forEach$iv = this.getObjects();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Animatable it = (Animatable)element$iv;
                    boolean bl2 = false;
                    it.setRotationOrigin(origin);
                }
            }
            return this.buildAnimation$fxgl_core(new AnimatedValue<Point3D>(this.startRotation, this.endRotation), arg_0 -> RotationAnimationBuilder.build$lambda$4(this, arg_0));
        }

        private static final void build$lambda$4(RotationAnimationBuilder this$0, Point3D value) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Iterable $this$forEach$iv = this$0.getObjects();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Animatable it = (Animatable)element$iv;
                boolean bl = false;
                if (this$0.is3DAnimation) {
                    it.rotationXProperty().setValue((Number)value.getX());
                    it.rotationYProperty().setValue((Number)value.getY());
                }
                it.rotationZProperty().setValue((Number)value.getZ());
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/almasb/fxgl/animation/AnimationBuilder$ScaleAnimationBuilder;", "Lcom/almasb/fxgl/animation/AnimationBuilder$AM;", "animationBuilder", "Lcom/almasb/fxgl/animation/AnimationBuilder;", "(Lcom/almasb/fxgl/animation/AnimationBuilder;)V", "endScale", "Ljavafx/geometry/Point3D;", "scaleOrigin", "startScale", "build", "Lcom/almasb/fxgl/animation/Animation;", "from", "start", "Ljavafx/geometry/Point2D;", "origin", "to", "end", "fxgl-core"})
    @SourceDebugExtension(value={"SMAP\nAnimationBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationBuilder.kt\ncom/almasb/fxgl/animation/AnimationBuilder$ScaleAnimationBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,621:1\n1855#2,2:622\n1855#2,2:624\n*S KotlinDebug\n*F\n+ 1 AnimationBuilder.kt\ncom/almasb/fxgl/animation/AnimationBuilder$ScaleAnimationBuilder\n*L\n393#1:622,2\n401#1:624,2\n*E\n"})
    public static final class ScaleAnimationBuilder
    extends AM {
        @NotNull
        private Point3D startScale;
        @NotNull
        private Point3D endScale;
        @Nullable
        private Point3D scaleOrigin;

        public ScaleAnimationBuilder(@NotNull AnimationBuilder animationBuilder) {
            Intrinsics.checkNotNullParameter((Object)animationBuilder, (String)"animationBuilder");
            super(animationBuilder);
            this.startScale = new Point3D(1.0, 1.0, 1.0);
            this.endScale = new Point3D(1.0, 1.0, 1.0);
        }

        @NotNull
        public final ScaleAnimationBuilder from(@NotNull Point2D start) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            this.startScale = new Point3D(start.getX(), start.getY(), 1.0);
            return this;
        }

        @NotNull
        public final ScaleAnimationBuilder to(@NotNull Point2D end) {
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            this.endScale = new Point3D(end.getX(), end.getY(), 1.0);
            return this;
        }

        @NotNull
        public final ScaleAnimationBuilder from(@NotNull Point3D start) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            this.startScale = start;
            return this;
        }

        @NotNull
        public final ScaleAnimationBuilder to(@NotNull Point3D end) {
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            this.endScale = end;
            return this;
        }

        @NotNull
        public final ScaleAnimationBuilder origin(@NotNull Point2D scaleOrigin) {
            Intrinsics.checkNotNullParameter((Object)scaleOrigin, (String)"scaleOrigin");
            this.scaleOrigin = new Point3D(scaleOrigin.getX(), scaleOrigin.getY(), 0.0);
            return this;
        }

        @NotNull
        public final ScaleAnimationBuilder origin(@NotNull Point3D scaleOrigin) {
            Intrinsics.checkNotNullParameter((Object)scaleOrigin, (String)"scaleOrigin");
            this.scaleOrigin = scaleOrigin;
            return this;
        }

        @Override
        @NotNull
        public Animation<?> build() {
            block1: {
                Point3D point3D = this.scaleOrigin;
                if (point3D == null) break block1;
                Point3D origin = point3D;
                boolean bl = false;
                Iterable $this$forEach$iv = this.getObjects();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Animatable it = (Animatable)element$iv;
                    boolean bl2 = false;
                    it.setScaleOrigin(origin);
                }
            }
            return this.buildAnimation$fxgl_core(new AnimatedPoint3D(this.startScale, this.endScale), arg_0 -> ScaleAnimationBuilder.build$lambda$3(this, arg_0));
        }

        private static final void build$lambda$3(ScaleAnimationBuilder this$0, Point3D value) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Iterable $this$forEach$iv = this$0.getObjects();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Animatable it = (Animatable)element$iv;
                boolean bl = false;
                it.scaleXProperty().setValue((Number)value.getX());
                it.scaleYProperty().setValue((Number)value.getY());
                it.scaleZProperty().setValue((Number)value.getZ());
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0006J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0006R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/almasb/fxgl/animation/AnimationBuilder$TranslationAnimationBuilder;", "Lcom/almasb/fxgl/animation/AnimationBuilder$AM;", "animationBuilder", "Lcom/almasb/fxgl/animation/AnimationBuilder;", "(Lcom/almasb/fxgl/animation/AnimationBuilder;)V", "fromPoint", "Ljavafx/geometry/Point3D;", "kotlin.jvm.PlatformType", "isFromSet", "", "path", "Ljavafx/scene/shape/Shape;", "toPoint", "alongPath", "build", "Lcom/almasb/fxgl/animation/Animation;", "from", "start", "Ljavafx/geometry/Point2D;", "makeAnim", "animValue", "Lcom/almasb/fxgl/animation/AnimatedValue;", "to", "end", "fxgl-core"})
    @SourceDebugExtension(value={"SMAP\nAnimationBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationBuilder.kt\ncom/almasb/fxgl/animation/AnimationBuilder$TranslationAnimationBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,621:1\n1855#2,2:622\n*S KotlinDebug\n*F\n+ 1 AnimationBuilder.kt\ncom/almasb/fxgl/animation/AnimationBuilder$TranslationAnimationBuilder\n*L\n321#1:622,2\n*E\n"})
    public static final class TranslationAnimationBuilder
    extends AM {
        @Nullable
        private Shape path;
        private Point3D fromPoint;
        private Point3D toPoint;
        private boolean isFromSet;

        public TranslationAnimationBuilder(@NotNull AnimationBuilder animationBuilder) {
            Intrinsics.checkNotNullParameter((Object)animationBuilder, (String)"animationBuilder");
            super(animationBuilder);
            this.fromPoint = Point3D.ZERO;
            this.toPoint = Point3D.ZERO;
        }

        @NotNull
        public final TranslationAnimationBuilder alongPath(@NotNull Shape path) {
            TranslationAnimationBuilder translationAnimationBuilder;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            TranslationAnimationBuilder it = translationAnimationBuilder = this;
            boolean bl = false;
            this.path = path;
            return translationAnimationBuilder;
        }

        @NotNull
        public final TranslationAnimationBuilder from(@NotNull Point2D start) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            return this.from(new Point3D(start.getX(), start.getY(), 0.0));
        }

        @NotNull
        public final TranslationAnimationBuilder to(@NotNull Point2D end) {
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            return this.to(new Point3D(end.getX(), end.getY(), 0.0));
        }

        @NotNull
        public final TranslationAnimationBuilder from(@NotNull Point3D start) {
            TranslationAnimationBuilder translationAnimationBuilder;
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            TranslationAnimationBuilder it = translationAnimationBuilder = this;
            boolean bl = false;
            this.fromPoint = start;
            this.isFromSet = true;
            return translationAnimationBuilder;
        }

        @NotNull
        public final TranslationAnimationBuilder to(@NotNull Point3D end) {
            TranslationAnimationBuilder translationAnimationBuilder;
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            TranslationAnimationBuilder it = translationAnimationBuilder = this;
            boolean bl = false;
            this.toPoint = end;
            return translationAnimationBuilder;
        }

        @Override
        @NotNull
        public Animation<?> build() {
            Shape shape = this.path;
            if (shape != null) {
                Shape curve = shape;
                boolean bl = false;
                Shape shape2 = curve;
                return shape2 instanceof QuadCurve ? this.makeAnim(new AnimatedQuadBezierPoint3D((QuadCurve)curve)) : (shape2 instanceof CubicCurve ? this.makeAnim(new AnimatedCubicBezierPoint3D((CubicCurve)curve)) : this.makeAnim(new AnimatedPath(curve)));
            }
            if (!this.isFromSet && this.getObjects().size() == 1) {
                Double d = this.getObjects().get(0).xProperty().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)d, (String)"objects[0].xProperty().value");
                double d2 = ((Number)d).doubleValue();
                Double d3 = this.getObjects().get(0).yProperty().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"objects[0].yProperty().value");
                double d4 = ((Number)d3).doubleValue();
                Double d5 = this.getObjects().get(0).zProperty().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)d5, (String)"objects[0].zProperty().value");
                this.from(new Point3D(d2, d4, ((Number)d5).doubleValue()));
            }
            Point3D point3D = this.fromPoint;
            Intrinsics.checkNotNullExpressionValue((Object)point3D, (String)"fromPoint");
            Point3D point3D2 = this.toPoint;
            Intrinsics.checkNotNullExpressionValue((Object)point3D2, (String)"toPoint");
            return this.makeAnim(new AnimatedPoint3D(point3D, point3D2));
        }

        private final Animation<Point3D> makeAnim(AnimatedValue<Point3D> animValue) {
            return this.buildAnimation$fxgl_core(animValue, arg_0 -> TranslationAnimationBuilder.makeAnim$lambda$5(this, arg_0));
        }

        private static final void makeAnim$lambda$5(TranslationAnimationBuilder this$0, Point3D value) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Iterable $this$forEach$iv = this$0.getObjects();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Animatable it = (Animatable)element$iv;
                boolean bl = false;
                it.xProperty().setValue((Number)value.getX());
                it.yProperty().setValue((Number)value.getY());
                it.zProperty().setValue((Number)value.getZ());
            }
        }
    }
}

