/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.collection.grid;

import com.almasb.fxgl.core.collection.grid.Cell;
import com.almasb.fxgl.core.collection.grid.CellGenerator;
import com.almasb.fxgl.core.math.FXGLMath;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Grid<T extends Cell> {
    private final T[][] data;
    private final int width;
    private final int height;
    private final int cellWidth;
    private final int cellHeight;

    public Grid(Class<T> type, int width, int height) {
        this(type, width, height, (x, y) -> null);
    }

    public Grid(Class<T> type, int width, int height, CellGenerator<T> populateFunction) {
        this(type, width, height, 0, 0, populateFunction);
    }

    public Grid(Class<T> type, int width, int height, int cellWidth, int cellHeight, CellGenerator<T> populateFunction) {
        if (cellWidth < 0 || cellHeight < 0) {
            throw new IllegalArgumentException("Cannot create grid with cells of negative size");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Cannot create grid with 0 or negative size");
        }
        this.width = width;
        this.height = height;
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.data = (Cell[][])Array.newInstance(type, width, height);
        this.populate(populateFunction);
    }

    public final void populate(CellGenerator<T> populateFunction) {
        for (int y = 0; y < this.data[0].length; ++y) {
            for (int x = 0; x < this.data.length; ++x) {
                this.set(x, y, (Cell)populateFunction.apply(x, y));
            }
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getCellWidth() {
        return this.cellWidth;
    }

    public final int getCellHeight() {
        return this.cellHeight;
    }

    public final boolean isWithin(int x, int y) {
        return x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight();
    }

    public final T[][] getData() {
        return this.data;
    }

    public final List<T> getCells() {
        ArrayList cells = new ArrayList();
        this.forEach(cells::add);
        return cells;
    }

    public final List<T> getNeighbors(int x, int y) {
        ArrayList result = new ArrayList();
        this.getLeft(x, y).ifPresent(result::add);
        this.getUp(x, y).ifPresent(result::add);
        this.getRight(x, y).ifPresent(result::add);
        this.getDown(x, y).ifPresent(result::add);
        return result;
    }

    public final T get(int x, int y) {
        return this.data[x][y];
    }

    public final void set(int x, int y, T node) {
        this.data[x][y] = node;
    }

    public final void forEach(Consumer<T> function) {
        for (int y = 0; y < this.data[0].length; ++y) {
            for (int x = 0; x < this.data.length; ++x) {
                function.accept(this.get(x, y));
            }
        }
    }

    public final Optional<T> getRight(Cell cell) {
        return this.getRight(cell.getX(), cell.getY());
    }

    public final Optional<T> getLeft(Cell cell) {
        return this.getLeft(cell.getX(), cell.getY());
    }

    public final Optional<T> getUp(Cell cell) {
        return this.getUp(cell.getX(), cell.getY());
    }

    public final Optional<T> getDown(Cell cell) {
        return this.getDown(cell.getX(), cell.getY());
    }

    public final Optional<T> getRight(int x, int y) {
        return this.getOptional(x + 1, y);
    }

    public final Optional<T> getLeft(int x, int y) {
        return this.getOptional(x - 1, y);
    }

    public final Optional<T> getUp(int x, int y) {
        return this.getOptional(x, y - 1);
    }

    public final Optional<T> getDown(int x, int y) {
        return this.getOptional(x, y + 1);
    }

    public final Optional<T> getOptionalByPixels(double x, double y) {
        if (this.getCellWidth() == 0 || this.getCellHeight() == 0) {
            return Optional.empty();
        }
        int cellX = (int)(x / (double)this.getCellWidth());
        int cellY = (int)(y / (double)this.getCellHeight());
        return this.getOptional(cellX, cellY);
    }

    public final Optional<T> getOptional(int x, int y) {
        if (this.isWithin(x, y)) {
            return Optional.of(this.get(x, y));
        }
        return Optional.empty();
    }

    public final T getRandomCell() {
        return this.getRandomCell(FXGLMath.getRandom());
    }

    public final T getRandomCell(Random random) {
        int x = random.nextInt(this.getWidth());
        int y = random.nextInt(this.getHeight());
        return this.get(x, y);
    }

    public final Optional<T> getRandomCell(Predicate<T> predicate) {
        return this.getRandomCell(FXGLMath.getRandom(), predicate);
    }

    public final Optional<T> getRandomCell(Random random, Predicate<T> predicate) {
        List filtered = this.getCells().stream().filter(predicate).collect(Collectors.toList());
        if (filtered.isEmpty()) {
            return Optional.empty();
        }
        int index = random.nextInt(filtered.size());
        return Optional.of((Cell)filtered.get(index));
    }
}

