/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.core.pool;

import com.almasb.fxgl.core.collection.Array;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.core.pool.Poolable;

public abstract class Pool<T> {
    private final int max;
    private final Array<T> freeObjects;

    public Pool() {
        this(16, Integer.MAX_VALUE);
    }

    public Pool(int initialCapacity) {
        this(initialCapacity, Integer.MAX_VALUE);
    }

    public Pool(int initialCapacity, int max) {
        this.freeObjects = new UnorderedArray(initialCapacity);
        this.max = max;
    }

    protected abstract T newObject();

    public T obtain() {
        return this.freeObjects.isEmpty() ? this.newObject() : this.freeObjects.pop();
    }

    public void free(T object) {
        if (this.freeObjects.size() < this.max) {
            this.freeObjects.add(object);
        }
        this.reset(object);
    }

    protected void reset(T object) {
        if (object instanceof Poolable) {
            ((Poolable)object).reset();
        }
    }

    public void clear() {
        this.freeObjects.clear();
    }
}

