/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.input.virtual;

import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.input.Input;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Parent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001aR\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\f\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00060\u00060\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\bR\u001c\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00060\u00060\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/almasb/fxgl/input/virtual/VirtualJoystick;", "Ljavafx/scene/Parent;", "input", "Lcom/almasb/fxgl/input/Input;", "(Lcom/almasb/fxgl/input/Input;)V", "center", "Ljavafx/geometry/Point2D;", "getCenter", "()Ljavafx/geometry/Point2D;", "maxDistance", "", "getMaxDistance", "()D", "maxForce", "getMaxForce", "setMaxForce", "(D)V", "vector", "getVector", "vectorProp", "Ljavafx/beans/property/ReadOnlyObjectWrapper;", "kotlin.jvm.PlatformType", "vectorWithForce", "getVectorWithForce", "vectorWithForceProp", "vectorProperty", "Ljavafx/beans/property/ReadOnlyObjectProperty;", "vectorWithForceProperty", "fxgl-core"})
public abstract class VirtualJoystick
extends Parent {
    @NotNull
    private final Input input;
    private double maxForce;
    @NotNull
    private final ReadOnlyObjectWrapper<Point2D> vectorProp;
    @NotNull
    private final ReadOnlyObjectWrapper<Point2D> vectorWithForceProp;

    public VirtualJoystick(@NotNull Input input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.maxForce = 1.0;
        this.vectorProp = new ReadOnlyObjectWrapper((Object)Point2D.ZERO);
        this.vectorWithForceProp = new ReadOnlyObjectWrapper((Object)Point2D.ZERO);
        Observable[] observableArray = new Observable[]{(Observable)this.input.mouseXUIProperty(), (Observable)this.input.mouseYUIProperty()};
        ObjectBinding vectorObservable = Bindings.createObjectBinding(() -> VirtualJoystick._init_$lambda$0(this), (Observable[])observableArray);
        Observable[] observableArray2 = new Observable[]{(Observable)this.input.mouseXUIProperty(), (Observable)this.input.mouseYUIProperty()};
        ObjectBinding vectorWithForceObservable = Bindings.createObjectBinding(() -> VirtualJoystick._init_$lambda$1(this), (Observable[])observableArray2);
        this.vectorProp.bind((ObservableValue)Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)this.pressedProperty())).then((ObservableObjectValue)vectorObservable).otherwise((Object)Point2D.ZERO));
        this.vectorWithForceProp.bind((ObservableValue)Bindings.when((ObservableBooleanValue)((ObservableBooleanValue)this.pressedProperty())).then((ObservableObjectValue)vectorWithForceObservable).otherwise((Object)Point2D.ZERO));
    }

    @NotNull
    public abstract Point2D getCenter();

    protected abstract double getMaxDistance();

    public final double getMaxForce() {
        return this.maxForce;
    }

    public final void setMaxForce(double d) {
        this.maxForce = d;
    }

    @NotNull
    public final Point2D getVector() {
        Object object = this.vectorProp.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"vectorProp.value");
        return (Point2D)object;
    }

    @NotNull
    public final Point2D getVectorWithForce() {
        Object object = this.vectorWithForceProp.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"vectorWithForceProp.value");
        return (Point2D)object;
    }

    @NotNull
    public final ReadOnlyObjectProperty<Point2D> vectorProperty() {
        ReadOnlyObjectProperty readOnlyObjectProperty = this.vectorProp.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyObjectProperty, (String)"vectorProp.readOnlyProperty");
        return readOnlyObjectProperty;
    }

    @NotNull
    public final ReadOnlyObjectProperty<Point2D> vectorWithForceProperty() {
        ReadOnlyObjectProperty readOnlyObjectProperty = this.vectorWithForceProp.getReadOnlyProperty();
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyObjectProperty, (String)"vectorWithForceProp.readOnlyProperty");
        return readOnlyObjectProperty;
    }

    private static final Point2D _init_$lambda$0(VirtualJoystick this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.input.getMousePositionUI().subtract(this$0.getCenter().add(this$0.getTranslateX(), this$0.getTranslateY())).normalize();
    }

    private static final Point2D _init_$lambda$1(VirtualJoystick this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Point2D v = this$0.input.getMousePositionUI().subtract(this$0.getCenter().add(this$0.getTranslateX(), this$0.getTranslateY()));
        double dist = Math.min(v.magnitude(), this$0.getMaxDistance());
        double distAdjusted = FXGLMath.map(dist, 0.0, this$0.getMaxDistance(), 0.0, this$0.maxForce);
        return v.normalize().multiply(distAdjusted);
    }
}

