/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.localization;

import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.localization.Language;
import com.almasb.fxgl.logging.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.SimpleObjectProperty;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aJ\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nJ(\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0018\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\n0\tJ\u000e\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006J\u0016\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u0006J\u0014\u0010\"\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00050\u00050\u0014RB\u0010\u0003\u001a6\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00040\u0004j\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0004`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\b\u001aB\u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\n0\t0\u0004j \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\n0\t`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00050\u00050\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/almasb/fxgl/localization/LocalizationService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "languagesData", "Ljava/util/HashMap;", "Lcom/almasb/fxgl/localization/Language;", "", "Lkotlin/collections/HashMap;", "languagesDataSuppliers", "Lkotlin/Function0;", "", "log", "Lcom/almasb/fxgl/logging/Logger;", "value", "selectedLanguage", "getSelectedLanguage", "()Lcom/almasb/fxgl/localization/Language;", "setSelectedLanguage", "(Lcom/almasb/fxgl/localization/Language;)V", "selectedLanguageProp", "Ljavafx/beans/property/SimpleObjectProperty;", "kotlin.jvm.PlatformType", "addLanguageData", "", "lang", "bundle", "Ljava/util/ResourceBundle;", "data", "addLanguageDataLazy", "dataSupplier", "getLocalizedString", "key", "localizedStringProperty", "Ljavafx/beans/binding/StringBinding;", "selectedLanguageProperty", "fxgl-core"})
@SourceDebugExtension(value={"SMAP\nLocalizationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationService.kt\ncom/almasb/fxgl/localization/LocalizationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1855#2,2:108\n*S KotlinDebug\n*F\n+ 1 LocalizationService.kt\ncom/almasb/fxgl/localization/LocalizationService\n*L\n44#1:108,2\n*E\n"})
public final class LocalizationService
extends EngineService {
    @NotNull
    private final Logger log = Logger.Companion.get(this.getClass());
    @NotNull
    private final HashMap<Language, Function0<Map<String, String>>> languagesDataSuppliers = new HashMap();
    @NotNull
    private final HashMap<Language, HashMap<String, String>> languagesData = new HashMap();
    @NotNull
    private final SimpleObjectProperty<Language> selectedLanguageProp = new SimpleObjectProperty((Object)Language.NONE);

    @NotNull
    public final SimpleObjectProperty<Language> selectedLanguageProperty() {
        return this.selectedLanguageProp;
    }

    @NotNull
    public final Language getSelectedLanguage() {
        Object object = this.selectedLanguageProp.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"selectedLanguageProp.value");
        return (Language)object;
    }

    public final void setSelectedLanguage(@NotNull Language value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.selectedLanguageProp.setValue((Object)value);
    }

    public final void addLanguageData(@NotNull Language lang, @NotNull ResourceBundle bundle) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        HashMap hashMap = this.languagesData.getOrDefault(lang, new HashMap());
        Intrinsics.checkNotNullExpressionValue(hashMap, (String)"languagesData.getOrDefault(lang, hashMapOf())");
        HashMap map = hashMap;
        Set<String> set = bundle.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"bundle.keySet()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            String it = (String)element$iv;
            boolean bl = false;
            Map map2 = map;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            String string2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)bundle.getString(it), (String)"bundle.getString(it)");
            map2.put(string2, string);
        }
        ((Map)this.languagesData).put(lang, map);
    }

    public final void addLanguageDataLazy(@NotNull Language lang, @NotNull Function0<? extends Map<String, String>> dataSupplier) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter(dataSupplier, (String)"dataSupplier");
        ((Map)this.languagesDataSuppliers).put(lang, dataSupplier);
    }

    public final void addLanguageData(@NotNull Language lang, @NotNull Map<String, String> data) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        HashMap<String, String> hashMap = this.languagesData.getOrDefault(lang, new HashMap());
        Intrinsics.checkNotNullExpressionValue(hashMap, (String)"languagesData.getOrDefault(lang, hashMapOf())");
        HashMap<String, String> map = hashMap;
        map.putAll(data);
        ((Map)this.languagesData).put(lang, map);
    }

    @NotNull
    public final StringBinding localizedStringProperty(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Observable[] observableArray = new Observable[]{(Observable)this.selectedLanguageProp};
        StringBinding stringBinding = Bindings.createStringBinding(() -> LocalizationService.localizedStringProperty$lambda$1(this, key), (Observable[])observableArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringBinding, (String)"createStringBinding(Call\u2026 }, selectedLanguageProp)");
        return stringBinding;
    }

    @NotNull
    public final String getLocalizedString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getLocalizedString(key, this.getSelectedLanguage());
    }

    @NotNull
    public final String getLocalizedString(@NotNull String key, @NotNull Language lang) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        if (Intrinsics.areEqual((Object)lang, (Object)Language.NONE)) {
            return "Language is NONE";
        }
        if (!((Map)this.languagesData).containsKey(lang)) {
            if (((Map)this.languagesDataSuppliers).containsKey(lang)) {
                Function0<Map<String, String>> function0 = this.languagesDataSuppliers.get(lang);
                Intrinsics.checkNotNull(function0);
                this.addLanguageData(lang, (Map)function0.invoke());
            } else {
                this.log.warning("No data for language " + lang);
                return "MISSING_LANG!";
            }
        }
        HashMap<String, String> hashMap = this.languagesData.get(lang);
        Intrinsics.checkNotNull(hashMap);
        HashMap<String, String> data = hashMap;
        if (!((Map)data).containsKey(key)) {
            this.log.warning(key + " is not localized for language " + lang);
            return "MISSING_KEY!";
        }
        String string = data.get(key);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private static final String localizedStringProperty$lambda$1(LocalizationService this$0, String $key) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        return this$0.getLocalizedString($key);
    }
}

