/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.texture;

import com.almasb.fxgl.animation.Animation;
import com.almasb.fxgl.animation.AnimationBuilder;
import com.almasb.fxgl.animation.Interpolators;
import com.almasb.fxgl.core.util.EmptyRunnable;
import com.almasb.fxgl.texture.AnimationChannel;
import com.almasb.fxgl.texture.FrameData;
import com.almasb.fxgl.texture.PreciseAnimatedIntValue;
import com.almasb.fxgl.texture.Texture;
import javafx.animation.Interpolator;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001a\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020\u0000J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003J\u0016\u0010$\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0007J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020\u0000J\u0006\u0010(\u001a\u00020\u001cJ\b\u0010)\u001a\u00020\u001cH\u0002J\b\u0010*\u001a\u00020\u001cH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Lcom/almasb/fxgl/texture/AnimatedTexture;", "Lcom/almasb/fxgl/texture/Texture;", "defaultChannel", "Lcom/almasb/fxgl/texture/AnimationChannel;", "(Lcom/almasb/fxgl/texture/AnimationChannel;)V", "animation", "Lcom/almasb/fxgl/animation/Animation;", "", "value", "animationChannel", "getAnimationChannel", "()Lcom/almasb/fxgl/texture/AnimationChannel;", "setAnimationChannel", "currentFrame", "Ljavafx/animation/Interpolator;", "interpolator", "getInterpolator", "()Ljavafx/animation/Interpolator;", "setInterpolator", "(Ljavafx/animation/Interpolator;)V", "onCycleFinished", "Ljava/lang/Runnable;", "getOnCycleFinished", "()Ljava/lang/Runnable;", "setOnCycleFinished", "(Ljava/lang/Runnable;)V", "loop", "loopAnimationChannel", "", "channel", "loopNoOverride", "loopReverse", "onUpdate", "tpf", "", "play", "playAnimationChannel", "startFrame", "playFrom", "playReverse", "stop", "updateAnimation", "updateImage", "fxgl-core"})
public final class AnimatedTexture
extends Texture {
    private int currentFrame;
    private Animation<Integer> animation;
    @NotNull
    private AnimationChannel animationChannel;
    @NotNull
    private Runnable onCycleFinished;
    @NotNull
    private Interpolator interpolator;

    public AnimatedTexture(@NotNull AnimationChannel defaultChannel) {
        Intrinsics.checkNotNullParameter((Object)defaultChannel, (String)"defaultChannel");
        super(defaultChannel.getImage());
        this.animationChannel = defaultChannel;
        this.onCycleFinished = EmptyRunnable.INSTANCE;
        this.interpolator = Interpolators.LINEAR.EASE_OUT();
        this.updateImage();
        this.updateAnimation();
    }

    @NotNull
    public final AnimationChannel getAnimationChannel() {
        return this.animationChannel;
    }

    private final void setAnimationChannel(AnimationChannel value) {
        this.animationChannel = value;
        this.updateAnimation();
    }

    @NotNull
    public final Runnable getOnCycleFinished() {
        return this.onCycleFinished;
    }

    public final void setOnCycleFinished(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"<set-?>");
        this.onCycleFinished = runnable;
    }

    @NotNull
    public final Interpolator getInterpolator() {
        return this.interpolator;
    }

    public final void setInterpolator(@NotNull Interpolator value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.interpolator = value;
        Animation<Integer> animation = this.animation;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation = null;
        }
        animation.setInterpolator(this.interpolator);
    }

    public final void playAnimationChannel(@NotNull AnimationChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.setAnimationChannel(channel);
        Animation<Integer> animation = this.animation;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation = null;
        }
        animation.stop();
        Animation<Integer> animation2 = this.animation;
        if (animation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation2 = null;
        }
        animation2.setCycleCount(1);
        Animation<Integer> animation3 = this.animation;
        if (animation3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation3 = null;
        }
        animation3.start();
    }

    public final void playAnimationChannel(@NotNull AnimationChannel channel, int startFrame) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.playAnimationChannel(channel);
        this.currentFrame = startFrame;
        Animation<Integer> animation = this.animation;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation = null;
        }
        animation.setTimeTo((double)this.currentFrame * this.animationChannel.getFrameDuration$fxgl_core());
    }

    public final void loopNoOverride(@NotNull AnimationChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        if (this.animationChannel == channel) {
            return;
        }
        this.loopAnimationChannel(channel);
    }

    public final void loopAnimationChannel(@NotNull AnimationChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.setAnimationChannel(channel);
        Animation<Integer> animation = this.animation;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation = null;
        }
        animation.stop();
        Animation<Integer> animation2 = this.animation;
        if (animation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation2 = null;
        }
        animation2.setCycleCount(Integer.MAX_VALUE);
        Animation<Integer> animation3 = this.animation;
        if (animation3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation3 = null;
        }
        animation3.start();
    }

    @NotNull
    public final AnimatedTexture playReverse() {
        Animation<Integer> animation = this.animation;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation = null;
        }
        animation.stop();
        Animation<Integer> animation2 = this.animation;
        if (animation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation2 = null;
        }
        animation2.setCycleCount(1);
        Animation<Integer> animation3 = this.animation;
        if (animation3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation3 = null;
        }
        animation3.startReverse();
        return this;
    }

    @NotNull
    public final AnimatedTexture loopReverse() {
        Animation<Integer> animation = this.animation;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation = null;
        }
        animation.stop();
        Animation<Integer> animation2 = this.animation;
        if (animation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation2 = null;
        }
        animation2.setCycleCount(Integer.MAX_VALUE);
        Animation<Integer> animation3 = this.animation;
        if (animation3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation3 = null;
        }
        animation3.startReverse();
        return this;
    }

    @NotNull
    public final AnimatedTexture play() {
        this.playAnimationChannel(this.animationChannel);
        return this;
    }

    @NotNull
    public final AnimatedTexture playFrom(int startFrame) {
        this.playAnimationChannel(this.animationChannel, startFrame);
        return this;
    }

    @NotNull
    public final AnimatedTexture loop() {
        this.loopAnimationChannel(this.animationChannel);
        return this;
    }

    public final void stop() {
        Animation<Integer> animation = this.animation;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation = null;
        }
        animation.stop();
        this.currentFrame = 0;
        this.updateImage();
    }

    @Override
    public void onUpdate(double tpf) {
        Animation<Integer> animation = this.animation;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation = null;
        }
        animation.onUpdate(tpf);
    }

    private final void updateImage() {
        FrameData frameData = this.animationChannel.getFrameData(this.currentFrame);
        this.setImage(this.animationChannel.getImage());
        this.setFitWidth(frameData.getWidth());
        this.setFitHeight(frameData.getHeight());
        this.setViewport(frameData.getViewport());
        this.setLayoutX(frameData.getOffsetX());
        this.setLayoutY(frameData.getOffsetY());
    }

    private final void updateAnimation() {
        AnimationBuilder animationBuilder = new AnimationBuilder(null, 1, null).onCycleFinished(() -> AnimatedTexture.updateAnimation$lambda$0(this));
        Duration duration = Duration.seconds((double)(this.animationChannel.getFrameDuration$fxgl_core() * (double)this.animationChannel.getSequence$fxgl_core().size()));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"seconds(animationChannel\u2026ionChannel.sequence.size)");
        this.animation = animationBuilder.duration(duration).interpolator(this.interpolator).animate(new PreciseAnimatedIntValue(0, this.animationChannel.getSequence$fxgl_core().size() - 1)).onProgress(arg_0 -> AnimatedTexture.updateAnimation$lambda$1(this, arg_0)).build();
    }

    private static final void updateAnimation$lambda$0(AnimatedTexture this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Animation<Integer> animation = this$0.animation;
        if (animation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"animation");
            animation = null;
        }
        if (animation.getCycleCount() > 1) {
            this$0.currentFrame = 0;
            this$0.updateImage();
        }
        this$0.onCycleFinished.run();
    }

    private static final void updateAnimation$lambda$1(AnimatedTexture this$0, Integer frameNum) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)frameNum, (String)"frameNum");
        this$0.currentFrame = Math.min(frameNum, this$0.animationChannel.getSequence$fxgl_core().size() - 1);
        this$0.updateImage();
    }
}

