/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.texture;

import com.almasb.fxgl.core.View;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B-\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0006H\u0016J\b\u0010#\u001a\u00020\u001eH\u0002J\b\u0010$\u001a\u00020\u001eH\u0002J\b\u0010%\u001a\u00020\u001eH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/almasb/fxgl/texture/ScrollingView;", "Ljavafx/scene/Parent;", "Lcom/almasb/fxgl/core/View;", "image", "Ljavafx/scene/image/Image;", "viewWidth", "", "viewHeight", "orientation", "Ljavafx/geometry/Orientation;", "(Ljavafx/scene/image/Image;DDLjavafx/geometry/Orientation;)V", "canvas", "Ljavafx/scene/canvas/Canvas;", "g", "Ljavafx/scene/canvas/GraphicsContext;", "kotlin.jvm.PlatformType", "getOrientation", "()Ljavafx/geometry/Orientation;", "value", "scrollX", "getScrollX", "()D", "setScrollX", "(D)V", "scrollY", "getScrollY", "setScrollY", "sx", "sy", "dispose", "", "getNode", "Ljavafx/scene/Node;", "onUpdate", "tpf", "redraw", "redrawX", "redrawY", "fxgl-core"})
public class ScrollingView
extends Parent
implements View {
    @NotNull
    private final Image image;
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final Canvas canvas;
    private final GraphicsContext g;
    private double sx;
    private double sy;
    private double scrollX;
    private double scrollY;

    @JvmOverloads
    public ScrollingView(@NotNull Image image2, double viewWidth, double viewHeight, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        Intrinsics.checkNotNullParameter((Object)orientation, (String)"orientation");
        this.image = image2;
        this.orientation = orientation;
        this.canvas = new Canvas(viewWidth, viewHeight);
        this.g = this.canvas.getGraphicsContext2D();
        ObservableList observableList = this.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"children");
        Collection collection = (Collection)observableList;
        collection.add(this.canvas);
        this.redraw();
    }

    public /* synthetic */ ScrollingView(Image image2, double d, double d2, Orientation orientation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = image2.getWidth();
        }
        if ((n & 4) != 0) {
            d2 = image2.getHeight();
        }
        if ((n & 8) != 0) {
            orientation = Orientation.HORIZONTAL;
        }
        this(image2, d, d2, orientation);
    }

    @NotNull
    public final Orientation getOrientation() {
        return this.orientation;
    }

    public final double getScrollX() {
        return this.scrollX;
    }

    public final void setScrollX(double value) {
        this.scrollX = value;
        this.sx = value % this.image.getWidth();
        if (this.sx < 0.0) {
            this.sx += this.image.getWidth();
        }
        this.redraw();
    }

    public final double getScrollY() {
        return this.scrollY;
    }

    public final void setScrollY(double value) {
        this.scrollY = value;
        this.sy = value % this.image.getHeight();
        if (this.sy < 0.0) {
            this.sy += this.image.getHeight();
        }
        this.redraw();
    }

    private final void redraw() {
        this.g.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        if (this.orientation == Orientation.HORIZONTAL) {
            this.redrawX();
        } else {
            this.redrawY();
        }
    }

    private final void redrawX() {
        boolean overflowX;
        double w = this.canvas.getWidth();
        double h = this.canvas.getHeight();
        boolean bl = overflowX = this.sx + w > this.image.getWidth();
        if (overflowX) {
            w = this.image.getWidth() - this.sx;
        }
        this.g.drawImage(this.image, this.sx, this.sy, w, h, 0.0, 0.0, w, h);
        if (overflowX) {
            this.g.drawImage(this.image, 0.0, 0.0, this.canvas.getWidth() - w, h, w, 0.0, this.canvas.getWidth() - w, h);
        }
    }

    private final void redrawY() {
        boolean overflowY;
        double w = this.canvas.getWidth();
        double h = this.canvas.getHeight();
        boolean bl = overflowY = this.sy + h > this.image.getHeight();
        if (overflowY) {
            h = this.image.getHeight() - this.sy;
        }
        this.g.drawImage(this.image, this.sx, this.sy, w, h, 0.0, 0.0, w, h);
        if (overflowY) {
            this.g.drawImage(this.image, 0.0, 0.0, w, this.canvas.getHeight() - h, 0.0, h, w, this.canvas.getHeight() - h);
        }
    }

    @Override
    public void onUpdate(double tpf) {
    }

    @Override
    @NotNull
    public Node getNode() {
        return (Node)this;
    }

    @Override
    public void dispose() {
    }

    @JvmOverloads
    public ScrollingView(@NotNull Image image2, double viewWidth, double viewHeight) {
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        this(image2, viewWidth, viewHeight, null, 8, null);
    }

    @JvmOverloads
    public ScrollingView(@NotNull Image image2, double viewWidth) {
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        this(image2, viewWidth, 0.0, null, 12, null);
    }

    @JvmOverloads
    public ScrollingView(@NotNull Image image2) {
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        this(image2, 0.0, 0.0, null, 14, null);
    }
}

