/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.texture;

import com.almasb.fxgl.core.Copyable;
import com.almasb.fxgl.core.View;
import com.almasb.fxgl.texture.AnimatedTexture;
import com.almasb.fxgl.texture.AnimationChannel;
import com.almasb.fxgl.texture.ImagesKt;
import com.almasb.fxgl.texture.Pixel;
import com.almasb.fxgl.texture.Texture;
import java.util.List;
import javafx.geometry.HorizontalDirection;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VerticalDirection;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0007\b\u0014\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0000J\b\u0010\u0015\u001a\u00020\u0000H\u0016J\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0000J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\tH\u0016J\u001a\u0010\"\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010#\u001a\u00020$H\u0007J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&J\u0016\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u001fJ\u0006\u0010+\u001a\u00020\u0000J\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u0000J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u000200J\u0016\u00101\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00002\u0006\u00102\u001a\u000203J\u0016\u00101\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00002\u0006\u00102\u001a\u000204J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u000208J\u0016\u00105\u001a\u0002062\u0006\u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020;J\u0006\u0010<\u001a\u00020\u0000J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010>\u001a\u00020\u0000J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006@"}, d2={"Lcom/almasb/fxgl/texture/Texture;", "Ljavafx/scene/image/ImageView;", "Lcom/almasb/fxgl/core/View;", "Lcom/almasb/fxgl/core/Copyable;", "image", "Ljavafx/scene/image/Image;", "(Ljavafx/scene/image/Image;)V", "()V", "height", "", "getHeight", "()D", "width", "getWidth", "blend", "node", "Ljavafx/scene/Node;", "blendMode", "Ljavafx/scene/effect/BlendMode;", "backgroundImage", "brighter", "copy", "darker", "desaturate", "discolor", "dispose", "", "getNode", "invert", "multiplyColor", "color", "Ljavafx/scene/paint/Color;", "onUpdate", "tpf", "outline", "offset", "", "pixels", "", "Lcom/almasb/fxgl/texture/Pixel;", "replaceColor", "oldColor", "newColor", "saturate", "set", "other", "subTexture", "area", "Ljavafx/geometry/Rectangle2D;", "superTexture", "direction", "Ljavafx/geometry/HorizontalDirection;", "Ljavafx/geometry/VerticalDirection;", "toAnimatedTexture", "Lcom/almasb/fxgl/texture/AnimatedTexture;", "defaultChannel", "Lcom/almasb/fxgl/texture/AnimationChannel;", "frames", "duration", "Ljavafx/util/Duration;", "toBlackWhite", "toColor", "toGrayscale", "transparentColor", "fxgl-core"})
@SourceDebugExtension(value={"SMAP\nTexture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Texture.kt\ncom/almasb/fxgl/texture/Texture\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n1#2:325\n*E\n"})
public class Texture
extends ImageView
implements View,
Copyable<Texture> {
    public Texture(@NotNull Image image2) {
        Intrinsics.checkNotNullParameter((Object)image2, (String)"image");
        super(image2);
    }

    protected Texture() {
    }

    public final double getWidth() {
        return this.getImage().getWidth();
    }

    public final double getHeight() {
        return this.getImage().getHeight();
    }

    @NotNull
    public final AnimatedTexture toAnimatedTexture(int frames, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"image");
        return this.toAnimatedTexture(new AnimationChannel(image2, duration, frames));
    }

    @NotNull
    public final AnimatedTexture toAnimatedTexture(@NotNull AnimationChannel defaultChannel) {
        Intrinsics.checkNotNullParameter((Object)defaultChannel, (String)"defaultChannel");
        return new AnimatedTexture(defaultChannel);
    }

    @Override
    @NotNull
    public Texture copy() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"image");
        return new Texture(image2);
    }

    @NotNull
    public final Texture subTexture(@NotNull Rectangle2D area) {
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        int minX = (int)area.getMinX();
        int minY = (int)area.getMinY();
        int maxX = (int)area.getMaxX();
        int maxY = (int)area.getMaxY();
        if (!(minX >= 0)) {
            boolean $i$a$-require-Texture$subTexture$52 = false;
            String $i$a$-require-Texture$subTexture$52 = "minX value of sub-texture cannot be negative";
            throw new IllegalArgumentException($i$a$-require-Texture$subTexture$52.toString());
        }
        if (!(minY >= 0)) {
            boolean $i$a$-require-Texture$subTexture$62 = false;
            String $i$a$-require-Texture$subTexture$62 = "minY value of sub-texture cannot be negative";
            throw new IllegalArgumentException($i$a$-require-Texture$subTexture$62.toString());
        }
        if (!((double)maxX <= this.getImage().getWidth())) {
            boolean $i$a$-require-Texture$subTexture$72 = false;
            String $i$a$-require-Texture$subTexture$72 = "maxX value of sub-texture cannot be greater than image width";
            throw new IllegalArgumentException($i$a$-require-Texture$subTexture$72.toString());
        }
        if (!((double)maxY <= this.getImage().getHeight())) {
            boolean $i$a$-require-Texture$subTexture$82 = false;
            String $i$a$-require-Texture$subTexture$82 = "maxY value of sub-texture cannot be greater than image height";
            throw new IllegalArgumentException($i$a$-require-Texture$subTexture$82.toString());
        }
        PixelReader pixelReader = this.getImage().getPixelReader();
        WritableImage newImage2 = new WritableImage(maxX - minX, maxY - minY);
        newImage2.getPixelWriter().setPixels(0, 0, (int)newImage2.getWidth(), (int)newImage2.getHeight(), pixelReader, minX, minY);
        return new Texture((Image)newImage2);
    }

    @NotNull
    public final Texture superTexture(@NotNull Texture other, @NotNull HorizontalDirection direction) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Image leftImage = null;
        Image rightImage = null;
        if (direction == HorizontalDirection.LEFT) {
            Image image2 = other.getImage();
            Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"other.image");
            leftImage = image2;
            Image image3 = this.getImage();
            Intrinsics.checkNotNullExpressionValue((Object)image3, (String)"this.image");
            rightImage = image3;
        } else {
            Image image4 = this.getImage();
            Intrinsics.checkNotNullExpressionValue((Object)image4, (String)"this.image");
            leftImage = image4;
            Image image5 = other.getImage();
            Intrinsics.checkNotNullExpressionValue((Object)image5, (String)"other.image");
            rightImage = image5;
        }
        int width = (int)(leftImage.getWidth() + rightImage.getWidth());
        int height = (int)Math.max(leftImage.getHeight(), rightImage.getHeight());
        PixelReader leftReader = leftImage.getPixelReader();
        PixelReader rightReader = rightImage.getPixelReader();
        WritableImage image6 = new WritableImage(width, height);
        PixelWriter pixelWriter = image6.getPixelWriter();
        pixelWriter.setPixels(0, 0, (int)leftImage.getWidth(), (int)leftImage.getHeight(), leftReader, 0, 0);
        pixelWriter.setPixels((int)leftImage.getWidth(), 0, (int)rightImage.getWidth(), (int)rightImage.getHeight(), rightReader, 0, 0);
        return new Texture((Image)image6);
    }

    @NotNull
    public final Texture superTexture(@NotNull Texture other, @NotNull VerticalDirection direction) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Image topImage = null;
        Image bottomImage = null;
        if (direction == VerticalDirection.DOWN) {
            Image image2 = this.getImage();
            Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"this.image");
            topImage = image2;
            Image image3 = other.getImage();
            Intrinsics.checkNotNullExpressionValue((Object)image3, (String)"other.image");
            bottomImage = image3;
        } else {
            Image image4 = other.getImage();
            Intrinsics.checkNotNullExpressionValue((Object)image4, (String)"other.image");
            topImage = image4;
            Image image5 = this.getImage();
            Intrinsics.checkNotNullExpressionValue((Object)image5, (String)"this.image");
            bottomImage = image5;
        }
        int width = (int)Math.max(topImage.getWidth(), bottomImage.getWidth());
        int height = (int)(topImage.getHeight() + bottomImage.getHeight());
        PixelReader topReader = topImage.getPixelReader();
        PixelReader bottomReader = bottomImage.getPixelReader();
        WritableImage image6 = new WritableImage(width, height);
        PixelWriter pixelWriter = image6.getPixelWriter();
        pixelWriter.setPixels(0, 0, (int)topImage.getWidth(), (int)topImage.getHeight(), topReader, 0, 0);
        pixelWriter.setPixels(0, (int)topImage.getHeight(), (int)bottomImage.getWidth(), (int)bottomImage.getHeight(), bottomReader, 0, 0);
        return new Texture((Image)image6);
    }

    @NotNull
    public final List<Pixel> pixels() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"image");
        return ImagesKt.toPixels(image2);
    }

    @NotNull
    public final Texture toGrayscale() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"image");
        return new Texture(ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)((Function1)toGrayscale.1.INSTANCE)));
    }

    @NotNull
    public final Texture toBlackWhite() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"image");
        return new Texture(ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)((Function1)toBlackWhite.1.INSTANCE)));
    }

    @NotNull
    public final Texture invert() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"image");
        return new Texture(ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)((Function1)invert.1.INSTANCE)));
    }

    @NotNull
    public final Texture brighter() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"image");
        return new Texture(ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)((Function1)brighter.1.INSTANCE)));
    }

    @NotNull
    public final Texture darker() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"image");
        return new Texture(ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)((Function1)darker.1.INSTANCE)));
    }

    @NotNull
    public final Texture saturate() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"image");
        return new Texture(ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)((Function1)saturate.1.INSTANCE)));
    }

    @NotNull
    public final Texture desaturate() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"image");
        return new Texture(ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)((Function1)desaturate.1.INSTANCE)));
    }

    @NotNull
    public final Texture discolor() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"image");
        return new Texture(ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)((Function1)discolor.1.INSTANCE)));
    }

    @NotNull
    public final Texture multiplyColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"image");
        return new Texture(ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)((Function1)new Function1<Pixel, Pixel>(color){
            final /* synthetic */ Color $color;
            {
                this.$color = $color;
                super(1);
            }

            @NotNull
            public final Pixel invoke(@NotNull Pixel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Color color = Color.color((double)(it.getR() * this.$color.getRed()), (double)(it.getG() * this.$color.getGreen()), (double)(it.getB() * this.$color.getBlue()), (double)(it.getA() * this.$color.getOpacity()));
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"color(\n                i\u2026* color.opacity\n        )");
                return it.copy(color);
            }
        })));
    }

    @NotNull
    public final Texture toColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Texture discolored = this.discolor();
        Texture colored = discolored.multiplyColor(color);
        discolored.dispose();
        return colored;
    }

    @NotNull
    public final Texture replaceColor(@NotNull Color oldColor, @NotNull Color newColor) {
        Intrinsics.checkNotNullParameter((Object)oldColor, (String)"oldColor");
        Intrinsics.checkNotNullParameter((Object)newColor, (String)"newColor");
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"image");
        Image newImage2 = ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)((Function1)new Function1<Pixel, Pixel>(oldColor, newColor){
            final /* synthetic */ Color $oldColor;
            final /* synthetic */ Color $newColor;
            {
                this.$oldColor = $oldColor;
                this.$newColor = $newColor;
                super(1);
            }

            @NotNull
            public final Pixel invoke(@NotNull Pixel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Color c = Intrinsics.areEqual((Object)it.getColor(), (Object)this.$oldColor) ? this.$newColor : it.getColor();
                return it.copy(c);
            }
        }));
        return new Texture(newImage2);
    }

    @NotNull
    public final Texture transparentColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Color color2 = Color.TRANSPARENT;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"TRANSPARENT");
        return this.replaceColor(color, color2);
    }

    @NotNull
    public final Texture blend(@NotNull Node node, @NotNull BlendMode blendMode) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)blendMode, (String)"blendMode");
        return this.blend(ImagesKt.toImage(node), blendMode);
    }

    @NotNull
    public final Texture blend(@NotNull Image backgroundImage, @NotNull BlendMode blendMode) {
        Intrinsics.checkNotNullParameter((Object)backgroundImage, (String)"backgroundImage");
        Intrinsics.checkNotNullParameter((Object)blendMode, (String)"blendMode");
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"image");
        return new Texture(ImagesKt.map(backgroundImage, image2, ImagesKt.operation(blendMode)));
    }

    @JvmOverloads
    @NotNull
    public final Texture outline(@NotNull Color color, int offset) {
        Texture coloredTexture;
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Group view = new Group();
        Texture outline1 = coloredTexture = this.toColor(color);
        outline1.setTranslateX(offset);
        Texture outline2 = coloredTexture.copy();
        outline2.setTranslateX(-((double)offset));
        Texture outline3 = coloredTexture.copy();
        outline3.setTranslateY(offset);
        Texture outline4 = coloredTexture.copy();
        outline4.setTranslateY(-((double)offset));
        Object[] objectArray = new Node[]{(Node)outline1, (Node)outline2, (Node)outline3, (Node)outline4, (Node)this.copy()};
        view.getChildren().addAll(objectArray);
        return new Texture(ImagesKt.toImage((Node)view));
    }

    public static /* synthetic */ Texture outline$default(Texture texture, Color color, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: outline");
        }
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return texture.outline(color, n);
    }

    public final void set(@NotNull Texture other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.setFitWidth(other.getFitWidth());
        this.setFitHeight(other.getFitHeight());
        this.setImage(other.getImage());
    }

    @Override
    public void onUpdate(double tpf) {
    }

    @Override
    @NotNull
    public Node getNode() {
        return (Node)this;
    }

    @Override
    public void dispose() {
        this.setImage(null);
    }

    @JvmOverloads
    @NotNull
    public final Texture outline(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return Texture.outline$default(this, color, 0, 2, null);
    }
}

