/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.time;

import com.almasb.fxgl.time.LocalTimer;
import com.almasb.fxgl.time.TimerAction;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u0019\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u001b\u001a\u00020\u0013J\u0016\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0013J\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0004R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/almasb/fxgl/time/Timer;", "", "()V", "<set-?>", "", "now", "getNow", "()D", "timerActions", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/almasb/fxgl/time/TimerAction;", "clear", "", "newLocalTimer", "Lcom/almasb/fxgl/time/LocalTimer;", "runAtInterval", "action", "Ljava/lang/Runnable;", "interval", "Ljavafx/util/Duration;", "limit", "", "runAtIntervalWhile", "whileCondition", "Ljavafx/beans/property/ReadOnlyBooleanProperty;", "runOnceAfter", "Lkotlin/Function0;", "delay", "update", "tpf", "fxgl-core"})
@SourceDebugExtension(value={"SMAP\nTimer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Timer.kt\ncom/almasb/fxgl/time/Timer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1855#2,2:149\n*S KotlinDebug\n*F\n+ 1 Timer.kt\ncom/almasb/fxgl/time/Timer\n*L\n37#1:149,2\n*E\n"})
public final class Timer {
    @NotNull
    private final CopyOnWriteArrayList<TimerAction> timerActions = new CopyOnWriteArrayList();
    private double now;

    public final double getNow() {
        return this.now;
    }

    public final void update(double tpf) {
        this.now += tpf;
        Iterable $this$forEach$iv = this.timerActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TimerAction it = (TimerAction)element$iv;
            boolean bl = false;
            it.update(tpf);
            if (!it.isExpired()) continue;
            this.timerActions.remove(it);
        }
    }

    @NotNull
    public final TimerAction runAtInterval(@NotNull Runnable action, @NotNull Duration interval) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.runAtInterval(action, interval, Integer.MAX_VALUE);
    }

    @NotNull
    public final TimerAction runAtInterval(@NotNull Runnable action, @NotNull Duration interval, int limit) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        TimerAction act = new TimerAction(interval, action, limit);
        this.timerActions.add(act);
        return act;
    }

    @NotNull
    public final TimerAction runAtIntervalWhile(@NotNull Runnable action, @NotNull Duration interval, @NotNull ReadOnlyBooleanProperty whileCondition) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)whileCondition, (String)"whileCondition");
        if (!whileCondition.get()) {
            return new TimerAction(interval, action, 0);
        }
        TimerAction act = new TimerAction(interval, action, 0, 4, null);
        this.timerActions.add(act);
        whileCondition.addListener((arg_0, arg_1, arg_2) -> Timer.runAtIntervalWhile$lambda$1((Function3)new Function3<ObservableValue<? extends Boolean>, Boolean, Boolean, Unit>(act){
            final /* synthetic */ TimerAction $act;
            {
                this.$act = $act;
                super(3);
            }

            public final void invoke(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean isTrue) {
                if (!isTrue.booleanValue()) {
                    this.$act.expire();
                }
            }
        }, arg_0, arg_1, arg_2));
        return act;
    }

    @NotNull
    public final TimerAction runOnceAfter(@NotNull Runnable action, @NotNull Duration delay) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        return this.runAtInterval(action, delay, 1);
    }

    @NotNull
    public final TimerAction runOnceAfter(@NotNull Function0<Unit> action, @NotNull Duration delay) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        return this.runOnceAfter(() -> Timer.runOnceAfter$lambda$2(action), delay);
    }

    public final void clear() {
        this.timerActions.clear();
    }

    @NotNull
    public final LocalTimer newLocalTimer() {
        return new LocalTimer(this){
            private double time;
            final /* synthetic */ Timer this$0;
            {
                this.this$0 = $receiver;
            }

            public void capture() {
                this.time = this.this$0.getNow();
            }

            public boolean elapsed(@NotNull Duration duration) {
                Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
                return this.this$0.getNow() - this.time >= duration.toSeconds();
            }
        };
    }

    private static final void runAtIntervalWhile$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void runOnceAfter$lambda$2(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }
}

