/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.localization;

import com.almasb.fxgl.localization.Language;
import com.almasb.sslogger.Logger;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Callable;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.SimpleObjectProperty;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0019J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nJ\u0016\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\nJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007RB\u0010\b\u001a6\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t0\tj\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/almasb/fxgl/localization/LocalizationService;", "", "()V", "languages", "", "Lcom/almasb/fxgl/localization/Language;", "getLanguages", "()Ljava/util/List;", "languagesData", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "log", "Lcom/almasb/sslogger/Logger;", "selectedLanguage", "getSelectedLanguage", "()Lcom/almasb/fxgl/localization/Language;", "selectedLanguageProp", "Ljavafx/beans/property/SimpleObjectProperty;", "addLanguageData", "", "lang", "bundle", "Ljava/util/ResourceBundle;", "data", "", "getLocalizedString", "key", "localizedStringProperty", "Ljavafx/beans/binding/StringBinding;", "selectedLanguageProperty", "fxgl-localization"})
public final class LocalizationService {
    private final Logger log = Logger.Companion.get(this.getClass());
    private final HashMap<Language, HashMap<String, String>> languagesData;
    private final SimpleObjectProperty<Language> selectedLanguageProp;

    @NotNull
    public final List<Language> getLanguages() {
        Set<Language> set = this.languagesData.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"languagesData.keys");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        Iterable iterable = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Language it = (Language)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Language)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    @NotNull
    public final SimpleObjectProperty<Language> selectedLanguageProperty() {
        return this.selectedLanguageProp;
    }

    @NotNull
    public final Language getSelectedLanguage() {
        Object object = this.selectedLanguageProp.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"selectedLanguageProp.value");
        return (Language)object;
    }

    public final void addLanguageData(@NotNull Language lang, @NotNull ResourceBundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        HashMap hashMap = this.languagesData.get(lang);
        if (hashMap == null) {
            boolean bl = false;
            hashMap = new HashMap();
        }
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"languagesData[lang] ?: hashMapOf()");
        HashMap map = hashMap;
        Set<String> set = bundle.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"bundle.keySet()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Map map2 = map;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            String string2 = bundle.getString(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"bundle.getString(it)");
            map2.put(string, string2);
        }
        ((Map)this.languagesData).put(lang, map);
    }

    public final void addLanguageData(@NotNull Language lang, @NotNull Map<String, String> data) {
        Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        HashMap<String, String> hashMap = this.languagesData.get(lang);
        if (hashMap == null) {
            boolean bl = false;
            hashMap = new HashMap<String, String>();
        }
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"languagesData[lang] ?: hashMapOf()");
        HashMap<String, String> map = hashMap;
        map.putAll(data);
        ((Map)this.languagesData).put(lang, map);
    }

    @NotNull
    public final StringBinding localizedStringProperty(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        StringBinding stringBinding = Bindings.createStringBinding((Callable)new Callable<String>(this, key){
            final /* synthetic */ LocalizationService this$0;
            final /* synthetic */ String $key;

            @NotNull
            public final String call() {
                return this.this$0.getLocalizedString(this.$key);
            }
            {
                this.this$0 = localizationService;
                this.$key = string;
            }
        }, (Observable[])new Observable[]{(Observable)this.selectedLanguageProp});
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBinding, (String)"Bindings.createStringBin\u2026 }, selectedLanguageProp)");
        return stringBinding;
    }

    @NotNull
    public final String getLocalizedString(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.getLocalizedString(key, this.getSelectedLanguage());
    }

    @NotNull
    public final String getLocalizedString(@NotNull String key, @NotNull Language lang) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
        Map map = this.languagesData;
        boolean bl = false;
        Map map2 = map;
        boolean bl2 = false;
        if (!map2.containsKey(lang)) {
            this.log.warning("No data for language " + lang);
            return "MISSING_LANG!";
        }
        HashMap<String, String> hashMap = this.languagesData.get(lang);
        if (hashMap == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(hashMap, (String)"languagesData[lang]!!");
        HashMap<String, String> data = hashMap;
        Map map3 = data;
        boolean bl3 = false;
        Map map4 = map3;
        boolean bl4 = false;
        if (!map4.containsKey(key)) {
            this.log.warning(key + " is not localized for language " + lang);
            return "MISSING_KEY!";
        }
        String string = data.get(key);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    public LocalizationService() {
        LocalizationService localizationService = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        localizationService.languagesData = hashMap;
        this.selectedLanguageProp = new SimpleObjectProperty();
    }
}

