/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.kafka.confluent;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.ExperimentalAvro4kApi;
import com.github.avrokotlin.avro4k.InternalAvro4kApi;
import com.github.avrokotlin.avro4k.kafka.confluent.AbstractAvro4kKafkaSerdeKt;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalAvro4kApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ0\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0005J&\u0010\u0014\u001a\u00020\f2\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0014J#\u0010%\u001a\u0004\u0018\u00018\u00002\b\u0010&\u001a\u0004\u0018\u00010\u00112\b\u0010'\u001a\u0004\u0018\u00010(H\u0016\u00a2\u0006\u0002\u0010)J-\u0010%\u001a\u0004\u0018\u00018\u00002\b\u0010&\u001a\u0004\u0018\u00010\u00112\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c8$X\u00a5\u0004\u00a2\u0006\f\u0012\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\u00198$X\u00a5\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010\u001e\u001a\u0004\b#\u0010$\u00a8\u0006."}, d2={"Lcom/github/avrokotlin/avro4k/kafka/confluent/AbstractAvro4kKafkaDeserializer;", "T", "", "Lorg/apache/kafka/common/serialization/Deserializer;", "Lio/confluent/kafka/serializers/AbstractKafkaAvroDeserializer;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "<init>", "(Lcom/github/avrokotlin/avro4k/Avro;)V", "getAvro", "()Lcom/github/avrokotlin/avro4k/Avro;", "initialize", "", "schemaRegistry", "Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "props", "", "", "isKey", "", "configure", "configs", "getDatumReader", "Lorg/apache/avro/io/DatumReader;", "writerSchema", "Lorg/apache/avro/Schema;", "readerSchema", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "getDeserializer$annotations", "()V", "getDeserializer", "()Lkotlinx/serialization/DeserializationStrategy;", "schema", "getSchema$annotations", "getSchema", "()Lorg/apache/avro/Schema;", "deserialize", "topic", "data", "", "(Ljava/lang/String;[B)Ljava/lang/Object;", "headers", "Lorg/apache/kafka/common/header/Headers;", "(Ljava/lang/String;Lorg/apache/kafka/common/header/Headers;[B)Ljava/lang/Object;", "close", "confluent-kafka-serializer"})
public abstract class AbstractAvro4kKafkaDeserializer<T>
extends AbstractKafkaAvroDeserializer
implements Deserializer<T> {
    @NotNull
    private final Avro avro;

    public AbstractAvro4kKafkaDeserializer(@NotNull Avro avro) {
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        this.avro = avro;
    }

    @NotNull
    protected final Avro getAvro() {
        return this.avro;
    }

    @InternalAvro4kApi
    protected final void initialize(@Nullable SchemaRegistryClient schemaRegistry, @NotNull Map<String, ? extends Object> props, boolean isKey) {
        Intrinsics.checkNotNullParameter(props, (String)"props");
        this.schemaRegistry = schemaRegistry;
        this.ticker = this.ticker(schemaRegistry);
        Map props2 = schemaRegistry != null && !props.containsKey("schema.registry.url") ? MapsKt.plus(props, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"schema.registry.url", (Object)""))) : props;
        this.configure(props2, isKey);
    }

    public void configure(@NotNull Map<String, ? extends Object> configs, boolean isKey) {
        Intrinsics.checkNotNullParameter(configs, (String)"configs");
        this.isKey = isKey;
        super.configure(this.deserializerConfig(configs));
    }

    @NotNull
    protected DatumReader<?> getDatumReader(@NotNull Schema writerSchema, @Nullable Schema readerSchema) {
        Intrinsics.checkNotNullParameter((Object)writerSchema, (String)"writerSchema");
        Schema schema = readerSchema;
        if (schema == null) {
            schema = writerSchema;
        }
        return AbstractAvro4kKafkaSerdeKt.getDatumReader(this.avro, schema, this.getDeserializer());
    }

    @NotNull
    protected abstract DeserializationStrategy<T> getDeserializer();

    @InternalAvro4kApi
    protected static /* synthetic */ void getDeserializer$annotations() {
    }

    @Nullable
    protected abstract Schema getSchema();

    @InternalAvro4kApi
    protected static /* synthetic */ void getSchema$annotations() {
    }

    @Nullable
    public T deserialize(@Nullable String topic, @Nullable byte[] data) {
        return this.deserialize(topic, null, data);
    }

    @Nullable
    public T deserialize(@Nullable String topic, @Nullable Headers headers, @Nullable byte[] data) {
        return (T)super.deserialize(topic, Boolean.valueOf(this.isKey), headers, data, this.getSchema());
    }

    public void close() {
        super.close();
    }
}

