/*
 * Decompiled with CFR 0.152.
 */
package com.github.avrokotlin.avro4k.kafka.confluent;

import com.github.avrokotlin.avro4k.Avro;
import com.github.avrokotlin.avro4k.ExperimentalAvro4kApi;
import com.github.avrokotlin.avro4k.internal.AvroInternalExtensionsKt;
import com.github.avrokotlin.avro4k.kafka.confluent.AbstractAvro4kKafkaDeserializer;
import com.github.avrokotlin.avro4k.kafka.confluent.AbstractAvro4kKafkaSerdeKt;
import com.github.avrokotlin.avro4k.kafka.confluent.KSerializerFinder;
import com.github.avrokotlin.avro4k.kafka.confluent.NoImplementedDecoder;
import com.github.avrokotlin.avro4k.kafka.confluent.ReflectKSerializer;
import com.github.avrokotlin.avro4k.kafka.confluent.SerializersKt;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializerConfig;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KClass;
import kotlin.reflect.KTypeParameter;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleCollector;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.util.Utf8;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.header.Headers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalAvro4kApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tBQ\b\u0016\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00020\r\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\b\u0010\u0011J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0016\u0010\u001f\u001a\u00020\u001c2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0002J\u0016\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\u000eH\u0002J\u0016\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\u000eH\u0002J\u001e\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010\u0015H\u0014J-\u0010'\u001a\u0004\u0018\u00018\u00002\b\u0010(\u001a\u0004\u0018\u00010\u000e2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016\u00a2\u0006\u0002\u0010-J\u001d\u0010.\u001a\u00028\u00002\u0006\u0010/\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u00100J\u001d\u00101\u001a\u00028\u00002\u0006\u00102\u001a\u00020,2\u0006\u0010%\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u00103R*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005@RX\u0094.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0015@RX\u0094.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/github/avrokotlin/avro4k/kafka/confluent/SpecificAvro4kKafkaDeserializer;", "T", "", "Lcom/github/avrokotlin/avro4k/kafka/confluent/AbstractAvro4kKafkaDeserializer;", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "avro", "Lcom/github/avrokotlin/avro4k/Avro;", "<init>", "(Lkotlinx/serialization/DeserializationStrategy;Lcom/github/avrokotlin/avro4k/Avro;)V", "isKey", "", "props", "", "", "schemaRegistry", "Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;", "(Lkotlinx/serialization/DeserializationStrategy;ZLcom/github/avrokotlin/avro4k/Avro;Ljava/util/Map;Lio/confluent/kafka/schemaregistry/client/SchemaRegistryClient;)V", "value", "getDeserializer", "()Lkotlinx/serialization/DeserializationStrategy;", "Lorg/apache/avro/Schema;", "schema", "getSchema", "()Lorg/apache/avro/Schema;", "currentWriterSchema", "Ljava/lang/ThreadLocal;", "configure", "", "config", "Lio/confluent/kafka/serializers/KafkaAvroDeserializerConfig;", "setDeserializer", "findKSerializerForClassName", "serialName", "findDeserializationStrategyInSerializersModule", "getDatumReader", "Lorg/apache/avro/io/DatumReader;", "writerSchema", "readerSchema", "deserialize", "topic", "headers", "Lorg/apache/kafka/common/header/Headers;", "data", "", "(Ljava/lang/String;Lorg/apache/kafka/common/header/Headers;[B)Ljava/lang/Object;", "wrapRootString", "rootString", "(Ljava/lang/String;Lorg/apache/avro/Schema;)Ljava/lang/Object;", "wrapRootByteArray", "rootBytes", "([BLorg/apache/avro/Schema;)Ljava/lang/Object;", "confluent-kafka-serializer"})
@SourceDebugExtension(value={"SMAP\nSpecificAvro4kKafkaSerde.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecificAvro4kKafkaSerde.kt\ncom/github/avrokotlin/avro4k/kafka/confluent/SpecificAvro4kKafkaDeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n1#2:356\n1563#3:357\n1634#3,3:358\n*S KotlinDebug\n*F\n+ 1 SpecificAvro4kKafkaSerde.kt\ncom/github/avrokotlin/avro4k/kafka/confluent/SpecificAvro4kKafkaDeserializer\n*L\n219#1:357\n219#1:358,3\n*E\n"})
public final class SpecificAvro4kKafkaDeserializer<T>
extends AbstractAvro4kKafkaDeserializer<T> {
    private DeserializationStrategy<? extends T> deserializer;
    private Schema schema;
    @NotNull
    private final ThreadLocal<Schema> currentWriterSchema;

    public SpecificAvro4kKafkaDeserializer(@Nullable DeserializationStrategy<? extends T> deserializer, @NotNull Avro avro) {
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        super(SerializersKt.withAnyKSerializer(avro, new ReflectKSerializer()));
        this.currentWriterSchema = new ThreadLocal();
        if (deserializer != null) {
            this.setDeserializer(deserializer);
        }
    }

    public /* synthetic */ SpecificAvro4kKafkaDeserializer(DeserializationStrategy deserializationStrategy, Avro avro, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            deserializationStrategy = null;
        }
        if ((n & 2) != 0) {
            avro = (Avro)Avro.Default;
        }
        this(deserializationStrategy, avro);
    }

    @Override
    @NotNull
    protected DeserializationStrategy<T> getDeserializer() {
        DeserializationStrategy<? extends T> deserializationStrategy = this.deserializer;
        if (deserializationStrategy != null) {
            return deserializationStrategy;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"deserializer");
        return null;
    }

    @Override
    @NotNull
    protected Schema getSchema() {
        Schema schema = this.schema;
        if (schema != null) {
            return schema;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"schema");
        return null;
    }

    public SpecificAvro4kKafkaDeserializer(@Nullable DeserializationStrategy<? extends T> deserializer, boolean isKey, @NotNull Avro avro, @NotNull Map<String, ? extends Object> props, @Nullable SchemaRegistryClient schemaRegistry) {
        Intrinsics.checkNotNullParameter((Object)avro, (String)"avro");
        Intrinsics.checkNotNullParameter(props, (String)"props");
        this(deserializer, avro);
        this.initialize(schemaRegistry, props, isKey);
    }

    public /* synthetic */ SpecificAvro4kKafkaDeserializer(DeserializationStrategy deserializationStrategy, boolean bl, Avro avro, Map map, SchemaRegistryClient schemaRegistryClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            deserializationStrategy = null;
        }
        if ((n & 4) != 0) {
            avro = (Avro)Avro.Default;
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            schemaRegistryClient = null;
        }
        this(deserializationStrategy, bl, avro, map, schemaRegistryClient);
    }

    protected void configure(@NotNull KafkaAvroDeserializerConfig config) {
        String string;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        boolean bl = this.isKey;
        if (bl) {
            string = "specific.avro.key.type";
        } else if (!bl) {
            string = "specific.avro.value.type";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String specificAvroClassLookupKey = string;
        String string2 = config.getString(specificAvroClassLookupKey);
        if (string2 != null) {
            String typeName = string2;
            boolean bl2 = false;
            DeserializationStrategy<?> deserializationStrategy = this.findKSerializerForClassName(typeName);
            if (deserializationStrategy == null && (deserializationStrategy = this.findDeserializationStrategyInSerializersModule(typeName)) == null) {
                throw new ConfigException(specificAvroClassLookupKey, (Object)typeName, "The configured type name was not found ");
            }
            DeserializationStrategy<?> foundKSerializer = deserializationStrategy;
            Intrinsics.checkNotNull(foundKSerializer, (String)"null cannot be cast to non-null type kotlinx.serialization.DeserializationStrategy<T of com.github.avrokotlin.avro4k.kafka.confluent.SpecificAvro4kKafkaDeserializer>");
            this.setDeserializer(foundKSerializer);
        }
        super.configure(config);
    }

    private final void setDeserializer(DeserializationStrategy<? extends T> deserializer) {
        this.deserializer = deserializer;
        this.schema = this.getAvro().schema(SerialDescriptorsKt.getNonNullOriginal((SerialDescriptor)deserializer.getDescriptor()));
    }

    /*
     * WARNING - void declaration
     */
    private final DeserializationStrategy<?> findKSerializerForClassName(String serialName) {
        KSerializer kSerializer;
        Object $this$findKSerializerForClassName_u24lambda_u241;
        SpecificAvro4kKafkaDeserializer specificAvro4kKafkaDeserializer = this;
        try {
            $this$findKSerializerForClassName_u24lambda_u241 = specificAvro4kKafkaDeserializer;
            boolean bl = false;
            Class<?> clazz = Class.forName(serialName);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
            $this$findKSerializerForClassName_u24lambda_u241 = Result.constructor-impl((Object)JvmClassMappingKt.getKotlinClass(clazz));
        }
        catch (Throwable bl) {
            $this$findKSerializerForClassName_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        specificAvro4kKafkaDeserializer = $this$findKSerializerForClassName_u24lambda_u241;
        KClass kClass = (KClass)(Result.isFailure-impl((Object)((Object)specificAvro4kKafkaDeserializer)) ? null : specificAvro4kKafkaDeserializer);
        if (kClass != null) {
            Collection<ReflectKSerializer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            KClass it = kClass;
            boolean bl = false;
            Iterable iterable = it.getTypeParameters();
            KClass kClass2 = it;
            SerializersModule serializersModule = this.getAvro().getSerializersModule();
            boolean $i$f$map = false;
            void var9_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                KTypeParameter kTypeParameter = (KTypeParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new ReflectKSerializer());
            }
            collection = (List)destination$iv$iv;
            kSerializer = kotlinx.serialization.SerializersKt.serializer((SerializersModule)serializersModule, (KClass)kClass2, (List)collection, (boolean)false);
        } else {
            kSerializer = null;
        }
        return (DeserializationStrategy)kSerializer;
    }

    private final DeserializationStrategy<?> findDeserializationStrategyInSerializersModule(String serialName) {
        KSerializerFinder it = new KSerializerFinder(serialName);
        boolean bl = false;
        this.getAvro().getSerializersModule().dumpTo((SerializersModuleCollector)it);
        return it.getFound();
    }

    @Override
    @NotNull
    protected DatumReader<?> getDatumReader(@NotNull Schema writerSchema, @Nullable Schema readerSchema) {
        Intrinsics.checkNotNullParameter((Object)writerSchema, (String)"writerSchema");
        Schema.Type type = writerSchema.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                this.currentWriterSchema.set(writerSchema);
                return AbstractAvro4kKafkaSerdeKt.getDatumReader(this.getAvro(), writerSchema, (DeserializationStrategy)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE));
            }
            case 2: {
                this.currentWriterSchema.set(writerSchema);
                return AbstractAvro4kKafkaSerdeKt.getDatumReader(this.getAvro(), writerSchema, (DeserializationStrategy)BuiltinSerializersKt.ByteArraySerializer());
            }
        }
        return super.getDatumReader(writerSchema, readerSchema);
    }

    @Override
    @Nullable
    public T deserialize(@Nullable String topic, @Nullable Headers headers, @Nullable byte[] data) {
        Object result = super.deserialize(topic, headers, data);
        Schema schema = this.currentWriterSchema.get();
        if (schema != null) {
            Object t;
            Schema writerSchema = schema;
            boolean bl = false;
            this.currentWriterSchema.set(null);
            Schema.Type type = writerSchema.getType();
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNull(result, (String)"null cannot be cast to non-null type kotlin.String");
                    t = this.wrapRootString((String)result, writerSchema);
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNull(result, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                    t = this.wrapRootByteArray((byte[])result, writerSchema);
                    break;
                }
                default: {
                    t = result;
                }
            }
            return t;
        }
        return result;
    }

    private final T wrapRootString(String rootString, Schema writerSchema) {
        return (T)AvroInternalExtensionsKt.decodeWithApacheDecoder((Avro)this.getAvro(), (Schema)writerSchema, this.getDeserializer(), (Decoder)new NoImplementedDecoder(rootString){
            final /* synthetic */ String $rootString;
            {
                this.$rootString = $rootString;
            }

            public Utf8 readString(Utf8 old) {
                return new Utf8(this.$rootString);
            }

            public String readString() {
                return this.$rootString;
            }
        });
    }

    private final T wrapRootByteArray(byte[] rootBytes, Schema writerSchema) {
        return (T)AvroInternalExtensionsKt.decodeWithApacheDecoder((Avro)this.getAvro(), (Schema)writerSchema, this.getDeserializer(), (Decoder)new NoImplementedDecoder(rootBytes){
            final /* synthetic */ byte[] $rootBytes;
            {
                this.$rootBytes = $rootBytes;
            }

            public ByteBuffer readBytes(ByteBuffer old) {
                return ByteBuffer.wrap(this.$rootBytes);
            }
        });
    }

    public SpecificAvro4kKafkaDeserializer() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Schema.Type.values().length];
            try {
                nArray[Schema.Type.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.BYTES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

