/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonObject;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpWifiService;
import me.chanjar.weixin.mp.bean.wifi.WxMpWifiShopDataResult;
import me.chanjar.weixin.mp.bean.wifi.WxMpWifiShopListResult;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;

public class WxMpWifiServiceImpl
implements WxMpWifiService {
    private final WxMpService wxMpService;

    @Override
    public WxMpWifiShopListResult listShop(int pageIndex, int pageSize) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("pageindex", (Number)pageIndex);
        json.addProperty("pagesize", (Number)pageSize);
        String result = this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Wifi.BIZWIFI_SHOP_LIST, json.toString());
        return WxMpWifiShopListResult.fromJson(result);
    }

    @Override
    public WxMpWifiShopDataResult getShopWifiInfo(int shopId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("shop_id", (Number)shopId);
        return WxMpWifiShopDataResult.fromJson(this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Wifi.BIZWIFI_SHOP_GET, json.toString()));
    }

    @Override
    public boolean updateShopWifiInfo(int shopId, String oldSsid, String ssid, String password) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("shop_id", (Number)shopId);
        json.addProperty("old_ssid", oldSsid);
        json.addProperty("ssid", ssid);
        if (password != null) {
            json.addProperty("password", password);
        }
        this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Wifi.BIZWIFI_SHOP_UPDATE, json.toString());
        return true;
    }

    public WxMpWifiServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

