/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import com.github.blutorange.maven.plugin.closurecompiler.common.TextFileModification;
import java.util.Iterator;
import java.util.Objects;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.Range;
import org.owasp.encoder.Encode;

final class HtmlModifier {
    HtmlModifier() {
    }

    public static TextFileModification clearTextContent(Element element) {
        boolean selfClosed = element.sourceRange().equals((Object)element.endSourceRange());
        if (selfClosed || element.childNodeSize() == 0) {
            return null;
        }
        Range firstChildSourceRange = element.childNode(0).sourceRange();
        Node lastChild = element.childNode(element.childNodeSize() - 1);
        Range lastChildSourceRange = lastChild instanceof Element ? ((Element)lastChild).endSourceRange() : lastChild.sourceRange();
        int from = firstChildSourceRange.startPos();
        int to = lastChildSourceRange.endPos();
        return to > from ? new TextFileModification(from, to, "") : null;
    }

    public static TextFileModification setAttribute(Element element, String name, String newValue, boolean html) {
        String escapedValue = html ? Encode.forHtmlAttribute((String)newValue) : Encode.forXmlAttribute((String)newValue);
        Attributes attributes = element.attributes();
        Iterator attributesIterator = attributes.iterator();
        boolean selfClosed = element.sourceRange().equals((Object)element.endSourceRange());
        while (attributesIterator.hasNext()) {
            Attribute attribute = (Attribute)attributesIterator.next();
            if (!Objects.equals(name, attribute.getKey())) continue;
            if (Objects.equals(newValue, attribute.getValue())) {
                return null;
            }
            Range.AttributeRange sourceRange = attribute.sourceRange();
            Range nameRange = sourceRange.valueRange();
            Range valueRange = sourceRange.valueRange();
            boolean hasValue = element.attributes().hasDeclaredValueForKey(name);
            if (hasValue) {
                boolean badEmptyRange;
                boolean bl = badEmptyRange = nameRange.endPos() == valueRange.startPos();
                if (badEmptyRange) {
                    Attribute nextAttribute;
                    Attribute attribute2 = nextAttribute = attributesIterator.hasNext() ? (Attribute)attributesIterator.next() : null;
                    int endPos = nextAttribute != null ? nextAttribute.sourceRange().nameRange().startPos() : element.sourceRange().endPos() - (selfClosed ? 2 : 1);
                    String quotedValue = "=\"" + escapedValue + "\"" + (nextAttribute != null ? " " : "");
                    return new TextFileModification(valueRange.startPos(), endPos, quotedValue);
                }
                return new TextFileModification(valueRange.startPos(), valueRange.endPos(), escapedValue);
            }
            String quotedValue = "=\"" + escapedValue + "\"";
            return new TextFileModification(valueRange.endPos(), valueRange.endPos(), quotedValue);
        }
        int endPos = selfClosed ? element.sourceRange().endPos() - 1 : element.sourceRange().endPos();
        String attributeValue = " " + name + "=\"" + escapedValue + "\"";
        return new TextFileModification(endPos - 1, endPos - 1, attributeValue);
    }
}

