/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero;

import java.io.ByteArrayOutputStream;
import org.slf4j.Logger;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.log.LogService;

public final class DataUnitBuilder {
    public static final String LOG_SERVICE = "Data-unit builder";
    private static final Logger logger = LogService.getLogger("Data-unit builder");
    private static final int T_DATA_CONNECTED = 64;
    private static final int T_CONNECT = 128;
    private static final int T_DISCONNECT = 129;
    private static final int T_ACK = 194;
    private static final int T_NAK = 195;

    private DataUnitBuilder() {
    }

    public static int getAPDUService(byte[] apdu) {
        if (apdu.length < 2) {
            throw new KNXIllegalArgumentException("getting APDU service from [0x" + DataUnitBuilder.toHex(apdu, "") + "], APCI length < 2");
        }
        int apci4 = (apdu[0] & 3) << 2 | (apdu[1] & 0xC0) >> 6;
        int apci6 = apdu[1] & 0x3F;
        if (apci4 == 0) {
            if (apci6 == 0) {
                return 0;
            }
        } else {
            if (apci4 == 1) {
                return 64;
            }
            if (apci4 == 2) {
                return 128;
            }
            if (apci4 == 3 || apci4 == 4 || apci4 == 5) {
                if (apci6 == 0) {
                    return apci4 << 6;
                }
            } else {
                if (apci4 == 6) {
                    return apci4 << 6;
                }
                if (apci4 == 7) {
                    if (apdu.length > 5 || apci6 > 48) {
                        return apci4 << 6 | apci6;
                    }
                    return apci4 << 6;
                }
                if (apci4 == 8 || apci4 == 9 || apci4 == 10) {
                    return apci4 << 6;
                }
                if (apci4 == 14 && (apci6 == 1 || apci6 == 33)) {
                    return apci4 << 6;
                }
                return apci4 << 6 | apci6;
            }
        }
        int code = apci4 << 6 | apci6;
        logger.warn("unknown APCI service code 0x" + Integer.toHexString(code));
        return code;
    }

    public static int getTPDUService(byte[] tpdu) {
        int ctrl = tpdu[0] & 0xFF;
        if ((ctrl & 0xFC) == 0) {
            return 0;
        }
        if ((ctrl & 0xFC) == 4) {
            return 4;
        }
        if ((ctrl & 0xC0) == 64) {
            return 64;
        }
        if (ctrl == 128) {
            return 128;
        }
        if (ctrl == 129) {
            return 129;
        }
        if ((ctrl & 0xC3) == 194) {
            return 194;
        }
        if ((ctrl & 0xC3) == 195) {
            return 195;
        }
        logger.warn("unknown TPCI service code 0x" + Integer.toHexString(ctrl));
        return ctrl;
    }

    public static byte[] createAPDU(int service, byte ... asdu) {
        if (asdu.length > 254) {
            throw new KNXIllegalArgumentException("ASDU length exceeds maximum of 254 bytes");
        }
        byte[] apdu = new byte[2 + asdu.length];
        apdu[0] = (byte)(service >> 8 & 3);
        apdu[1] = (byte)(apdu[1] | (byte)service);
        for (int i = 0; i < asdu.length; ++i) {
            apdu[i + 2] = asdu[i];
        }
        return apdu;
    }

    public static byte[] createLengthOptimizedAPDU(int service, byte ... asdu) {
        byte[] apdu = new byte[asdu != null && asdu.length > 0 ? 1 + asdu.length : 2];
        if (apdu.length > 255) {
            throw new KNXIllegalArgumentException("APDU length exceeds maximum of 255 bytes");
        }
        apdu[0] = (byte)(service >> 8 & 3);
        apdu[1] = (byte)service;
        if (asdu != null && asdu.length > 0) {
            apdu[1] = (byte)(apdu[1] | asdu[0] & 0x3F);
            for (int i = 1; i < asdu.length; ++i) {
                apdu[i + 1] = asdu[i];
            }
        }
        return apdu;
    }

    public static byte[] extractASDU(byte[] apdu) {
        int svc = DataUnitBuilder.getAPDUService(apdu);
        int offset = 2;
        int mask = 255;
        if (svc == 64 || svc == 128) {
            if (apdu.length <= 2) {
                offset = 1;
                mask = 63;
            }
        } else if (svc == 384 || svc == 448) {
            offset = 1;
            mask = 63;
        } else if (svc == 512 || svc == 576 || svc == 640) {
            offset = 1;
            mask = 63;
        } else if (svc == 768 || svc == 832) {
            offset = 1;
            mask = 63;
        } else if (svc == 256 || svc == 320) {
            offset = 1;
            mask = 63;
        } else if (svc == 896) {
            offset = 1;
            mask = 63;
        }
        byte[] asdu = new byte[apdu.length - offset];
        for (int i = 0; i < asdu.length; ++i) {
            asdu[i] = apdu[offset + i];
        }
        if (asdu.length > 0) {
            asdu[0] = (byte)(asdu[0] & mask);
        }
        return asdu;
    }

    public static String decode(byte[] tpdu, KNXAddress dst) {
        if (tpdu.length < 1) {
            throw new KNXIllegalArgumentException("TPDU length too short");
        }
        String s = DataUnitBuilder.decodeTPCI(tpdu[0] & 0xFF, dst);
        if (tpdu.length > 1) {
            return s + ", " + DataUnitBuilder.decodeAPCI(DataUnitBuilder.getAPDUService(tpdu));
        }
        return s;
    }

    public static String decodeTPCI(int tpci, KNXAddress dst) {
        int ctrl = tpci & 0xFF;
        if ((ctrl & 0xFC) == 0) {
            if (dst == null) {
                return "T_Broadcast/group/ind";
            }
            if (dst.getRawAddress() == 0) {
                return "T_Broadcast";
            }
            if (dst instanceof GroupAddress) {
                return "T_Group";
            }
            return "T-individual";
        }
        if ((ctrl & 0xC0) == 64) {
            return "T_Connected seq " + (ctrl >> 2 & 0xF);
        }
        if (ctrl == 128) {
            return "T_Connect";
        }
        if (ctrl == 129) {
            return "T_Disconnect";
        }
        if ((ctrl & 0xC3) == 194) {
            return "T_Ack seq " + (ctrl >> 2 & 0xF);
        }
        if ((ctrl & 0xC3) == 195) {
            return "T_Nak seq " + (ctrl >> 2 & 0xF);
        }
        if ((ctrl & 0xFC) == 4) {
            return "T_TagGroup";
        }
        return "unknown TPCI";
    }

    public static String decodeAPCI(int apci) {
        switch (apci) {
            case 0: {
                return "A_Group.read";
            }
            case 64: {
                return "A_Group.response";
            }
            case 128: {
                return "A_Group.write";
            }
            case 384: {
                return "A_ADC.read";
            }
            case 448: {
                return "A_ADC.response";
            }
            case 977: {
                return "A_Authorize.read";
            }
            case 978: {
                return "A_Authorize.response";
            }
            case 992: {
                return "A_Domain.write";
            }
            case 993: {
                return "A_Domain.read";
            }
            case 994: {
                return "A_Domain.response";
            }
            case 995: {
                return "A_Domain-selective.read";
            }
            case 256: {
                return "A_IndAddr.read";
            }
            case 320: {
                return "A_IndAddr.response";
            }
            case 192: {
                return "A_IndAddr.write";
            }
            case 988: {
                return "A_IndAddr-S/N.read";
            }
            case 989: {
                return "A_IndAddr-S/N.response";
            }
            case 990: {
                return "A_IndAddr-S/N.write";
            }
            case 768: {
                return "A_Device-desc.read";
            }
            case 832: {
                return "A_Device-desc.response";
            }
            case 979: {
                return "A_Key.write";
            }
            case 980: {
                return "A_Key.response";
            }
            case 512: {
                return "A_Memory.read";
            }
            case 576: {
                return "A_Memory.response";
            }
            case 640: {
                return "A_Memory.write";
            }
            case 984: {
                return "A_Property-desc.read";
            }
            case 985: {
                return "A_Property-desc.response";
            }
            case 981: {
                return "A_Property.read";
            }
            case 982: {
                return "A_Property.response";
            }
            case 983: {
                return "A_Property.write";
            }
            case 896: {
                return "A_Restart";
            }
            case 986: {
                return "A_NetworkParameter.read";
            }
            case 987: {
                return "A_NetworkParameter.response";
            }
            case 996: {
                return "A_NetworkParameter.write";
            }
            case 1000: {
                return "A_GroupPropValue.read";
            }
            case 1001: {
                return "A_GroupPropValue.response";
            }
            case 1002: {
                return "A_GroupPropValue.write";
            }
            case 1003: {
                return "A_GroupPropValue.info";
            }
            case 507: {
                return "A_MemoryExtended.write";
            }
            case 508: {
                return "A_MemoryExtended.write-response";
            }
            case 509: {
                return "A_MemoryExtended.read";
            }
            case 510: {
                return "A_MemoryExtended.read-response";
            }
            case 456: {
                return "A_SystemNetworkParameter.read";
            }
            case 457: {
                return "A_SystemNetworkParameter.response";
            }
            case 458: {
                return "A_SystemNetworkParameter.write";
            }
            case 1004: {
                return "A_DoA-S/N.read";
            }
            case 1005: {
                return "A_DoA-S/N.response";
            }
            case 1006: {
                return "A_DoA-S/N.write";
            }
            case 711: {
                return "A_FunctionPropertyCommand";
            }
            case 713: {
                return "A_FunctionPropertyState.response";
            }
            case 460: {
                return "A_PropertyExtValue.read";
            }
            case 461: {
                return "A_PropertyExtValue.response";
            }
            case 462: {
                return "A_PropertyExtValue.write";
            }
            case 463: {
                return "A_PropertyExtValue.write-response";
            }
            case 464: {
                return "A_PropertyExtValue.write-uncon";
            }
            case 465: {
                return "A_PropertyExtValue.info";
            }
            case 466: {
                return "A_PropertyExtDescription.read";
            }
            case 467: {
                return "A_PropertyExtDescription.response";
            }
            case 468: {
                return "A_FunctionPropertyExtCommand";
            }
            case 469: {
                return "A_FunctionPropertyExtState.read";
            }
            case 470: {
                return "A_FunctionPropertyExtState.response";
            }
            case 1009: {
                return "S-A_Data";
            }
        }
        return "APCI 0x" + Integer.toHexString(apci);
    }

    public static String toHex(byte[] data, String sep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int no = data[i] & 0xFF;
            if (no < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(no));
            if (sep == null || i >= data.length - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static byte[] fromHex(String hex) {
        String s = hex.replace(" ", "");
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static Builder apdu(int service) {
        return new Builder().putShort(service & 0x3FF);
    }

    public static final class Builder {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        private Builder() {
        }

        public Builder put(int oneByte) {
            this.baos.write(oneByte);
            return this;
        }

        public Builder putShort(int twoBytes) {
            return this.put(twoBytes >> 8).put(twoBytes);
        }

        public Builder put(byte[] bytes) {
            this.baos.writeBytes(bytes);
            return this;
        }

        public byte[] build() {
            return this.baos.toByteArray();
        }
    }
}

