/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero;

import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.link.medium.KnxIPSettings;
import tuwien.auto.calimero.link.medium.PLSettings;
import tuwien.auto.calimero.link.medium.RFSettings;
import tuwien.auto.calimero.link.medium.TPSettings;

public interface DeviceDescriptor {
    public static final int TYPE_SIZE = 2;
    public static final int TYPE2_SIZE = 14;

    @Deprecated(forRemoval=true)
    public static DeviceDescriptor fromType(byte[] data) throws KNXFormatException {
        return DeviceDescriptor.from(data);
    }

    public static DeviceDescriptor from(byte[] data) throws KNXFormatException {
        if (data.length == 2) {
            return DD0.from(data);
        }
        if (data.length == 14) {
            return new DD2(data);
        }
        throw new KNXFormatException("unknown device descriptor type of size " + data.length);
    }

    public byte[] toByteArray();

    public static enum DD0 implements DeviceDescriptor
    {
        Dummy(1, "Dummy"),
        TYPE_0010(16, "System 1 (BCU 1)"),
        TYPE_0011(17, "System 1 (BCU 1)"),
        TYPE_0012(18, "System 1 (BCU 1)"),
        TYPE_0013(19, "System 1 (BCU 1)"),
        TYPE_0020(32, "System 2 (BCU 2)"),
        TYPE_0021(33, "System 2 (BCU 2)"),
        TYPE_0025(37, "System 2 (BCU 2)"),
        TYPE_0300(768, "System 300"),
        TYPE_0310(784, "TP1 USB interface v1"),
        TYPE_0311(785, "TP1 USB interface v2"),
        TYPE_0700(1792, "BIM M112"),
        TYPE_0701(1793, "BIM M112"),
        TYPE_0705(1797, "BIM M112"),
        TYPE_07B0(1968, "System B"),
        TYPE_0810(2064, "IR-Decoder"),
        TYPE_0811(2065, "IR-Decoder"),
        TYPE_0900(2304, "Coupler 0900"),
        TYPE_0910(2320, "Coupler 1.0"),
        TYPE_0911(2321, "Coupler 1.1"),
        TYPE_0912(2322, "Coupler 1.2"),
        TYPE_091A(2330, "KNXnet/IP Router"),
        TYPE_0AFD(2813, "none"),
        TYPE_0AFE(2814, "none"),
        TYPE_1011(4113, "1.1"),
        TYPE_1012(4114, "BCU 1"),
        TYPE_1013(4115, "BCU 1"),
        TYPE_1310(4880, "PL110 USB interface v1"),
        TYPE_1311(4881, "PL110 USB interface v2"),
        TYPE_17B0(6064, "System B"),
        TYPE_1900(6400, "Media Coupler PL-TP"),
        TYPE_2010(8208, "Bidirectional devices"),
        TYPE_2110(8464, "Unidirectional devices"),
        TYPE_2311(8977, "RF USB interface v2"),
        TYPE_2705(9989, "RF 7.5"),
        TYPE_27B0(10160, "RF System B"),
        TYPE_2920(10528, "TP1/RF Media Coupler 2.0"),
        TYPE_3012(12306, "BCU 1"),
        TYPE_4012(16402, "BCU 1"),
        TYPE_5705(22277, "System 7"),
        TYPE_57B0(22448, "System B IP");

        private final int mv;
        private final String profile;

        public static DD0 from(byte[] data) {
            if (data.length != 2) {
                throw new KNXIllegalArgumentException("unspecified device descriptor type 0 using length " + data.length + ": " + DataUnitBuilder.toHex(data, ""));
            }
            int i = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
            return DD0.from(i);
        }

        public static DD0 from(int descriptor) {
            for (DD0 v : DD0.values()) {
                if (v.maskVersion() != descriptor) continue;
                return v;
            }
            throw new KNXIllegalArgumentException("unknown mask version " + DD0.maskVersionString(descriptor));
        }

        static String maskVersionString(int descriptor) {
            return String.format("%04X", descriptor);
        }

        private DD0(int mask, String profile) {
            this.mv = mask;
            this.profile = profile;
        }

        public int maskVersion() {
            return this.mv;
        }

        public int mediumType() {
            return this.mv >> 12 & 0xF;
        }

        public KNXMediumSettings medium() {
            int type = this.mediumType();
            switch (type) {
                case 0: {
                    return new TPSettings();
                }
                case 1: {
                    return new PLSettings();
                }
                case 2: {
                    return new RFSettings(KNXMediumSettings.BackboneRouter);
                }
                case 3: {
                    throw new KNXIllegalArgumentException("TP0 medium not supported any longer");
                }
                case 4: {
                    throw new KNXIllegalArgumentException("PL132 medium not supported any longer");
                }
                case 5: {
                    return new KnxIPSettings(KNXMediumSettings.BackboneRouter);
                }
            }
            throw new KNXIllegalArgumentException("unknown KNX medium type " + type);
        }

        public int firmwareType() {
            return this.mv >> 8 & 0xF;
        }

        public int firmwareVersion() {
            return this.mv >> 4 & 0xF;
        }

        public int firmwareSubcode() {
            return this.mv & 0xF;
        }

        public String deviceProfile() {
            return this.profile;
        }

        public String toString() {
            return DD0.maskVersionString(this.mv) + " - " + this.deviceProfile();
        }

        @Override
        public byte[] toByteArray() {
            return new byte[]{(byte)(this.mv >>> 8), (byte)this.mv};
        }
    }

    public static final class DD2
    implements DeviceDescriptor {
        private final byte[] d;

        public static DD2 from(byte[] data) {
            return new DD2(data);
        }

        private DD2(byte[] descriptor) {
            if (descriptor.length != 14) {
                throw new KNXIllegalArgumentException("unspecified device descriptor type 2 using length " + descriptor.length);
            }
            this.d = (byte[])descriptor.clone();
            int v = (this.d[5] & 0xC0) >> 6;
            if (v > 1) {
                throw new KNXIllegalArgumentException("undefined misc field value " + v + " (byte 5)");
            }
        }

        public DD2(int appManufacturer, int deviceType, int version, boolean supportsLinkMgmt, int logicalTagBase, int channelInfo1, int channelInfo2, int channelInfo3, int channelInfo4) {
            this.d = new byte[14];
            int i = 0;
            this.d[i++] = (byte)(appManufacturer >> 8);
            this.d[i++] = (byte)appManufacturer;
            this.d[i++] = (byte)(deviceType >> 8);
            this.d[i++] = (byte)deviceType;
            this.d[i++] = (byte)version;
            this.d[i++] = (byte)((supportsLinkMgmt ? 1 : 0) << 6 | logicalTagBase);
            this.d[i++] = (byte)(channelInfo1 >> 8);
            this.d[i++] = (byte)channelInfo1;
            this.d[i++] = (byte)(channelInfo2 >> 8);
            this.d[i++] = (byte)channelInfo2;
            this.d[i++] = (byte)(channelInfo3 >> 8);
            this.d[i++] = (byte)channelInfo3;
            this.d[i++] = (byte)(channelInfo4 >> 8);
            this.d[i++] = (byte)channelInfo4;
        }

        public int applicationManufacturer() {
            return this.get16Bits(0);
        }

        public int deviceType() {
            return this.get16Bits(2);
        }

        public int version() {
            return this.d[4] & 0xFF;
        }

        public boolean supportsLinkManagement() {
            int i = (this.d[5] & 0xC0) >> 6;
            return i == 1;
        }

        public int logicalTagBase() {
            return this.d[5] & 0x3F;
        }

        public int channels(Channel channelType) {
            int offset = channelType.ordinal() * 2;
            return (this.get16Bits(6 + offset) >> 13) + 1;
        }

        public int channelCode(Channel channelType) {
            int offset = channelType.ordinal() * 2;
            return this.get16Bits(6 + offset) & 0x1FFF;
        }

        public String toString() {
            return DataUnitBuilder.toHex(this.d, "");
        }

        @Override
        public byte[] toByteArray() {
            return (byte[])this.d.clone();
        }

        private int get16Bits(int byteOffset) {
            int v = (this.d[byteOffset] & 0xFF) << 8;
            return v |= this.d[byteOffset + 1] & 0xFF;
        }

        public static enum Channel {
            Channel1,
            Channel2,
            Channel3,
            Channel4;

        }
    }
}

