/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero;

import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlReader;

public class GroupAddress
extends KNXAddress {
    public static final GroupAddress Broadcast = new GroupAddress(0);
    static final String ATTR_GROUP = "group";
    private static volatile Presentation style = Presentation.ThreeLevelStyle;

    public GroupAddress(int address) {
        super(address);
    }

    public GroupAddress(int mainGroup, int middleGroup, int subGroup) {
        super(GroupAddress.address(mainGroup, middleGroup, subGroup));
    }

    public GroupAddress(int mainGroup, int subGroup) {
        super(GroupAddress.address(mainGroup, subGroup));
    }

    public GroupAddress(byte[] address) {
        super(address);
    }

    public GroupAddress(String address) throws KNXFormatException {
        super(GroupAddress.parse(address));
    }

    public GroupAddress(XmlReader r) throws KNXMLException {
        super(GroupAddress.parse(r));
    }

    public static void addressStyle(Presentation style) {
        GroupAddress.style = style;
    }

    public static Presentation addressStyle() {
        return style;
    }

    public final int getMainGroup() {
        return this.address >>> 11 & 0x1F;
    }

    public final int getMiddleGroup() {
        return this.address >>> 8 & 7;
    }

    public final int getSubGroup8() {
        return this.address & 0xFF;
    }

    public final int getSubGroup11() {
        return this.address & 0x7FF;
    }

    @Override
    public final String getType() {
        return ATTR_GROUP;
    }

    public String toString() {
        switch (style) {
            case ThreeLevelStyle: {
                return this.getMainGroup() + "/" + this.getMiddleGroup() + "/" + this.getSubGroup8();
            }
            case TwoLevelStyle: {
                return this.getMainGroup() + "/" + this.getSubGroup11();
            }
        }
        return Integer.toString(this.getRawAddress());
    }

    public boolean equals(Object obj) {
        if (obj instanceof GroupAddress) {
            return this.address == ((GroupAddress)obj).address;
        }
        return false;
    }

    public int hashCode() {
        return this.address;
    }

    private static int parse(XmlReader r) {
        try {
            return GroupAddress.parse(GroupAddress.address(r, ATTR_GROUP));
        }
        catch (KNXFormatException e) {
            throw new KNXMLException(e.getMessage(), r);
        }
    }

    private static int parse(String address) throws KNXFormatException {
        String[] tokens = GroupAddress.parse(address, true);
        try {
            int value;
            if (tokens.length == 1) {
                value = Integer.decode(tokens[0]);
            } else if (tokens.length == 2) {
                value = GroupAddress.address(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]));
            } else if (tokens.length == 3) {
                value = GroupAddress.address(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]));
            } else {
                throw new KNXFormatException("wrong group address syntax with " + tokens.length + " levels", address);
            }
            if (value < 0 || value > 65535) {
                throw new KNXFormatException("group address out of range [0..0xffff]", value);
            }
            return value;
        }
        catch (NumberFormatException | KNXIllegalArgumentException e) {
            throw new KNXFormatException("invalid group address", address, e);
        }
    }

    private static int address(int main, int middle, int sub) {
        if ((main & 0xFFFFFFE0) != 0 || (middle & 0xFFFFFFF8) != 0 || (sub & 0xFFFFFF00) != 0) {
            throw new KNXIllegalArgumentException("address group out of range");
        }
        return main << 11 | middle << 8 | sub;
    }

    private static int address(int main, int sub) {
        if ((main & 0xFFFFFFE0) != 0 || (sub & 0xFFFFF800) != 0) {
            throw new KNXIllegalArgumentException("address group out of range");
        }
        return main << 11 | sub;
    }

    public static enum Presentation {
        ThreeLevelStyle,
        TwoLevelStyle,
        FreeStyle;

    }
}

