/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero;

import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlReader;

public class IndividualAddress
extends KNXAddress {
    static final String ATTR_IND = "individual";

    public IndividualAddress(int address) {
        super(address);
    }

    public IndividualAddress(int area, int line, int device) {
        super(IndividualAddress.address(area, line, device));
    }

    public IndividualAddress(byte[] address) {
        super(address);
    }

    public IndividualAddress(String address) throws KNXFormatException {
        super(IndividualAddress.parse(address));
    }

    public IndividualAddress(XmlReader r) throws KNXMLException {
        super(IndividualAddress.parse(r));
    }

    public final int getArea() {
        return this.address >>> 12;
    }

    public final int getLine() {
        return this.address >>> 8 & 0xF;
    }

    public final int getDevice() {
        return this.address & 0xFF;
    }

    @Override
    public final String getType() {
        return ATTR_IND;
    }

    public String toString() {
        return this.getArea() + "." + this.getLine() + "." + this.getDevice();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IndividualAddress) {
            return this.address == ((IndividualAddress)obj).address;
        }
        return false;
    }

    public int hashCode() {
        int offset = 65536;
        return 0x10000 ^ this.address;
    }

    private static int parse(XmlReader r) {
        try {
            return IndividualAddress.parse(IndividualAddress.address(r, ATTR_IND));
        }
        catch (KNXFormatException e) {
            throw new KNXMLException(e.getMessage(), r);
        }
    }

    private static int parse(String address) throws KNXFormatException {
        String[] tokens = IndividualAddress.parse(address, false);
        try {
            int value;
            if (tokens.length == 1) {
                value = Integer.decode(tokens[0]);
            } else if (tokens.length == 3) {
                value = IndividualAddress.address(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]));
            } else {
                throw new KNXFormatException("wrong individual address syntax with " + tokens.length + " levels", address);
            }
            if (value < 0 || value > 65535) {
                throw new KNXFormatException("individual address out of range [0..0xffff]", value);
            }
            return value;
        }
        catch (NumberFormatException | KNXIllegalArgumentException e) {
            throw new KNXFormatException("invalid individual address", address, e);
        }
    }

    private static int address(int area, int line, int device) {
        if ((area & 0xFFFFFFF0) != 0 || (line & 0xFFFFFFF0) != 0 || (device & 0xFFFFFF00) != 0) {
            throw new KNXIllegalArgumentException("address value out of range");
        }
        return area << 12 | line << 8 | device;
    }
}

