/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero;

import java.util.StringTokenizer;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlReader;
import tuwien.auto.calimero.xml.XmlWriter;

public abstract class KNXAddress
implements Comparable<KNXAddress> {
    private static final String ATTR_TYPE = "type";
    private static final String TAG_ADDRESS = "knxAddress";
    final int address;

    KNXAddress(int address) {
        if (address < 0 || address > 65535) {
            throw new KNXIllegalArgumentException("address out of range [0..0xFFFF]");
        }
        this.address = address;
    }

    KNXAddress(byte[] address) {
        if (address.length < 2) {
            throw new KNXIllegalArgumentException("address byte array too short");
        }
        this.address = (address[0] & 0xFF) << 8 | address[1] & 0xFF;
    }

    static String address(XmlReader r, String type) {
        if (r.getEventType() != 1) {
            r.nextTag();
        }
        String typeAttr = r.getAttributeValue(null, ATTR_TYPE);
        if (r.getEventType() != 1 || !r.getLocalName().equals(TAG_ADDRESS) || typeAttr != null && !type.equals(typeAttr)) {
            throw new KNXMLException("XML element represents no KNX " + type + " address", r);
        }
        return r.getElementText();
    }

    public static KNXAddress create(XmlReader r) throws KNXMLException {
        if (r.getEventType() != 1) {
            r.nextTag();
        }
        if (r.getEventType() == 1) {
            String type = r.getAttributeValue(null, ATTR_TYPE);
            if ("group".equals(type)) {
                return new GroupAddress(r);
            }
            if ("individual".equals(type)) {
                return new IndividualAddress(r);
            }
            try {
                return KNXAddress.create(r.getElementText());
            }
            catch (KNXFormatException e) {
                throw new KNXMLException(e.getMessage(), r);
            }
        }
        throw new KNXMLException("not a KNX address", r);
    }

    public static KNXAddress create(String address) throws KNXFormatException {
        if (address.contains(".")) {
            return new IndividualAddress(address);
        }
        if (address.contains("/")) {
            return new GroupAddress(address);
        }
        throw new KNXFormatException("could not detect address type of " + address);
    }

    public abstract String getType();

    public final int getRawAddress() {
        return this.address;
    }

    public void save(XmlWriter w) throws KNXMLException {
        w.writeStartElement(TAG_ADDRESS);
        w.writeAttribute(ATTR_TYPE, this.getType());
        w.writeCharacters(this.toString());
        w.writeEndElement();
    }

    public final byte[] toByteArray() {
        return new byte[]{(byte)(this.address >>> 8), (byte)this.address};
    }

    @Override
    public int compareTo(KNXAddress other) {
        return this.address - other.address;
    }

    static String[] parse(String address, boolean groupAddress) throws KNXFormatException {
        StringTokenizer t = null;
        if (groupAddress && address.indexOf(47) > -1) {
            t = new StringTokenizer(address, "/");
        } else if (!groupAddress && address.indexOf(46) > -1) {
            t = new StringTokenizer(address, ".");
        } else {
            return new String[]{address};
        }
        int count = t.countTokens();
        if (count == 2) {
            return new String[]{t.nextToken(), t.nextToken()};
        }
        if (count == 3) {
            return new String[]{t.nextToken(), t.nextToken(), t.nextToken()};
        }
        throw new KNXFormatException("wrong KNX address syntax with " + count + " levels", address);
    }
}

