/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import tuwien.auto.calimero.KNXIllegalArgumentException;

public final class ReturnCode {
    static Map<Integer, ReturnCode> values = Collections.synchronizedMap(new HashMap());
    public static final ReturnCode Success = new ReturnCode(0, "success", "service, function or command executed sucessfully");
    public static final ReturnCode SuccessWithCrc = new ReturnCode(1, "success with crc", "positive message confirmation, CRC over original data");
    public static final ReturnCode MemoryError = new ReturnCode(241, "memory error", "memory cannot be accessed or only with fault(s)");
    public static final ReturnCode InvalidCommand = new ReturnCode(242, "invalid command", "server does not support the requested command");
    public static final ReturnCode ImpossibleCommand = new ReturnCode(243, "impossible command", "command cannot be executed because a dependency is not fulfilled");
    public static final ReturnCode ExceedsMaxApduLength = new ReturnCode(244, "exceeds max apdu length", "data will not fit into a frame supported by this server");
    public static final ReturnCode DataOverflow = new ReturnCode(245, "data overflow", "attempt to write data beyond what is reserved for the addressed resource");
    public static final ReturnCode OutOfMinRange = new ReturnCode(246, "out of min range", "write value below minimum supported value");
    public static final ReturnCode OutOfMaxRange = new ReturnCode(247, "out of max range", "write value exceeds maximum supported value");
    public static final ReturnCode DataVoid = new ReturnCode(248, "data void", "request contains invalid data");
    public static final ReturnCode TemporarilyNotAvailable = new ReturnCode(249, "temporarily not available", "data access not possible at this time");
    public static final ReturnCode AccessWriteOnly = new ReturnCode(250, "access write-only", "read access to write-only resource");
    public static final ReturnCode AccessReadOnly = new ReturnCode(251, "access read-only", "write access to read-only resource");
    public static final ReturnCode AccessDenied = new ReturnCode(252, "access denied", "access to recource is not allowed because of authorization/security");
    public static final ReturnCode AddressVoid = new ReturnCode(253, "address void", "resource is not present");
    public static final ReturnCode DataTypeConflict = new ReturnCode(254, "data type conflict", "write access with wrong datatype (datapoint length)");
    public static final ReturnCode Error = new ReturnCode(255, "error", "service, function or command failed");
    private final int code;
    private final String name;
    private final String description;

    private ReturnCode(int code, String name, String description) {
        this.code = code;
        this.name = name;
        this.description = description;
        values.put(code, this);
    }

    public static ReturnCode of(int code) {
        if (code < 0 || code > 255) {
            throw new KNXIllegalArgumentException("return code " + code + " out of range [0..0xff]");
        }
        ReturnCode rc = values.get(code);
        return rc != null ? rc : new ReturnCode(code, "0x" + Integer.toHexString(code), "unknown return code");
    }

    public int code() {
        return this.code;
    }

    public String friendly() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }
}

