/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero;

import java.nio.ByteBuffer;
import tuwien.auto.calimero.KNXIllegalArgumentException;

public final class SerialNumber {
    public static final int Size = 6;
    public static final SerialNumber Zero = SerialNumber.of(0L);
    private final long sno;

    private SerialNumber(long serialNumber) {
        this.sno = serialNumber & 0xFFFFFFFFFFFFL;
    }

    public static SerialNumber of(long serialNumber) {
        return new SerialNumber(serialNumber);
    }

    public static SerialNumber from(byte[] serialNumber) {
        return new SerialNumber(SerialNumber.unsigned(serialNumber));
    }

    public long number() {
        return this.sno;
    }

    public byte[] array() {
        return ByteBuffer.allocate(6).putShort((short)(this.sno >> 32)).putInt((int)this.sno).array();
    }

    public boolean equals(Object obj) {
        return obj instanceof SerialNumber && ((SerialNumber)obj).sno == this.sno;
    }

    public int hashCode() {
        return Long.hashCode(this.sno);
    }

    public String toString() {
        return String.format("%04x:%08x", this.sno >> 32, this.sno & 0xFFFFFFFFFFFFFFFFL);
    }

    private static long unsigned(byte[] data) {
        if (data.length != 6) {
            throw new KNXIllegalArgumentException("invalid size for a KNX serial number");
        }
        long l = 0L;
        for (byte b : data) {
            l = (l << 8) + (long)(b & 0xFF);
        }
        return l;
    }
}

