/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class Settings {
    private static final String version = "2.5-M1";
    private static final String library = "Calimero";
    private static final String desc = "A library for KNX network access";
    private static final String tuwien = "Vienna University of Technology";
    private static final String group = "Automation Systems Group";
    private static final String copyright = "Copyright \u00a9 2006-2021";
    private static final String sep = "\n";

    private Settings() {
    }

    public static String getLibraryVersion() {
        return version;
    }

    public static String getLibraryHeader(boolean verbose) {
        if (!verbose) {
            return "Calimero version 2.5-M1";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(library).append(" version ").append(version).append(" - ");
        buf.append(desc).append(sep);
        buf.append(group).append(", ");
        buf.append(tuwien).append(sep);
        buf.append(copyright);
        return buf.toString();
    }

    public static void main(String[] args) {
        if (args.length > 0 && (args[0].equals("--version") || args[0].equals("-v"))) {
            Settings.out(Settings.getLibraryHeader(false));
        } else {
            Settings.out(Settings.getLibraryHeader(true));
            Settings.out("\nSupported protocols: " + Settings.supportedProtocols().collect(Collectors.joining(", ")));
        }
    }

    private static Stream<String> supportedProtocols() {
        String[] proto = new String[]{"KNXnet/IP (Secure)", "KNX IP", "FT1.2", "TP-Uart", "KNX USB", "KNX RF USB", "BAOS"};
        String prefix = "tuwien.auto.calimero.";
        String[] check = new String[]{"knxnetip.KNXnetIPConnection", "knxnetip.KNXnetIPConnection", "serial.FT12Connection", "serial.TpuartConnection", "serial.usb.UsbConnection", "serial.usb.UsbConnection", "baos.Baos"};
        return IntStream.range(0, proto.length).filter(i -> Settings.loadable("tuwien.auto.calimero." + check[i])).mapToObj(i -> proto[i]);
    }

    private static boolean loadable(String className) {
        try {
            ClassLoader cl = Settings.class.getClassLoader();
            cl.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            return false;
        }
    }

    private static void out(String s) {
        System.out.println(s);
    }
}

