/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.baos;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.baos.BaosService;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.link.AbstractLink;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.NetworkLinkListener;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;

public final class Baos {
    public static KnxBaosLink asBaosLink(KNXNetworkLink link) {
        return new KnxBaosLink(link);
    }

    private Baos() {
    }

    public static final class KnxBaosLink
    implements KNXNetworkLink {
        static final MethodHandle CUSTOM_EVENTS;
        static final MethodHandle BAOS_MODE;
        static final MethodHandle ON_SEND;
        private final KNXNetworkLink link;

        KnxBaosLink(KNXNetworkLink link) {
            this.link = link;
            try {
                Map map = CUSTOM_EVENTS.invoke(link);
                map.put(BaosService.class, ConcurrentHashMap.newKeySet());
            }
            catch (Throwable e) {
                throw new KnxRuntimeException("adding custom BAOS event", e);
            }
            this.baosMode(true);
        }

        @Override
        public void setKNXMedium(KNXMediumSettings settings) {
            this.link.setKNXMedium(settings);
        }

        @Override
        public KNXMediumSettings getKNXMedium() {
            return this.link.getKNXMedium();
        }

        @Override
        public void addLinkListener(NetworkLinkListener l) {
            this.link.addLinkListener(l);
        }

        @Override
        public void removeLinkListener(NetworkLinkListener l) {
            this.link.removeLinkListener(l);
        }

        @Override
        public void setHopCount(int count) {
            this.link.setHopCount(count);
        }

        @Override
        public int getHopCount() {
            return this.link.getHopCount();
        }

        public void send(BaosService service) throws KNXTimeoutException, KNXLinkClosedException {
            IndividualAddress none = new IndividualAddress(0);
            try {
                ON_SEND.invoke(this.link, none, service.toByteArray(), true);
            }
            catch (KNXTimeoutException | KNXLinkClosedException e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public void sendRequest(KNXAddress dst, Priority p, byte[] nsdu) throws KNXTimeoutException, KNXLinkClosedException {
            this.link.sendRequest(dst, p, nsdu);
        }

        @Override
        public void sendRequestWait(KNXAddress dst, Priority p, byte[] nsdu) throws KNXTimeoutException, KNXLinkClosedException {
            this.link.sendRequestWait(dst, p, nsdu);
        }

        @Override
        public void send(CEMILData msg, boolean waitForCon) throws KNXTimeoutException, KNXLinkClosedException {
            this.link.send(msg, waitForCon);
        }

        @Override
        public String getName() {
            return this.link.getName();
        }

        @Override
        public boolean isOpen() {
            return this.link.isOpen();
        }

        public KNXNetworkLink detach() {
            this.baosMode(false);
            return this.link;
        }

        @Override
        public void close() {
            this.link.close();
        }

        private void baosMode(boolean enable) {
            try {
                BAOS_MODE.invoke(this.link, enable);
            }
            catch (Throwable e) {
                throw new KnxRuntimeException("switching BAOS mode", e);
            }
        }

        static {
            try {
                MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(AbstractLink.class, MethodHandles.lookup());
                CUSTOM_EVENTS = privateLookup.findGetter(AbstractLink.class, "customEvents", Map.class);
                MethodType baosModeType = MethodType.methodType(Void.TYPE, Boolean.TYPE);
                BAOS_MODE = privateLookup.findVirtual(AbstractLink.class, "baosMode", baosModeType);
                MethodType onSendType = MethodType.methodType(Void.TYPE, List.of(KNXAddress.class, byte[].class, Boolean.TYPE));
                ON_SEND = privateLookup.findVirtual(AbstractLink.class, "onSend", onSendType);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

