/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.baos;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;

public final class BaosService {
    private static final int MainService = 240;
    public static final int GetServerItem = 1;
    public static final int SetServerItem = 2;
    public static final int GetDatapointDescription = 3;
    public static final int GetDatapointDescriptionString = 4;
    public static final int GetDatapointValue = 5;
    public static final int SetDatapointValue = 6;
    public static final int GetParameterByte = 7;
    public static final int SetDatapointHistoryCommand = 8;
    public static final int GetDatapointHistoryState = 9;
    public static final int GetDatapointHistory = 10;
    public static final int GetTimer = 11;
    public static final int SetTimer = 12;
    public static final int DatapointValueIndication = 193;
    public static final int ServerItemIndication = 194;
    private static final int ResponseFlag = 128;
    private static final int MinimumFrameSize = 6;
    private final int subService;
    private final int start;
    private final int count;
    private final byte[] data;
    private final List<Item<?>> items;

    private static String subServiceString(int subService) {
        switch (subService & 0xFFFFFF7F) {
            case 1: {
                return "GetServerItem";
            }
            case 2: {
                return "SetServerItem";
            }
            case 3: {
                return "GetDatapointDescription";
            }
            case 4: {
                return "GetDescriptionString";
            }
            case 5: {
                return "GetDatapointValue";
            }
            case 6: {
                return "SetDatapointValue";
            }
            case 7: {
                return "GetParameterByte";
            }
            case 8: {
                return "SetDatapointHistoryCommand";
            }
            case 9: {
                return "GetDatapointHistoryState";
            }
            case 10: {
                return "GetDatapointHistory";
            }
            case 11: {
                return "GetTimer";
            }
            case 12: {
                return "SetTimer";
            }
            case 193: {
                return "DatapointValueIndication";
            }
            case 194: {
                return "ServerItemIndication";
            }
        }
        return "" + subService;
    }

    public static BaosService getServerItem(Property startItem, int items) {
        return new BaosService(1, startItem.id(), items, new byte[0]);
    }

    @SafeVarargs
    public static BaosService setServerItem(Item<Property> ... items) {
        return new BaosService(2, items);
    }

    public static BaosService getDatapointDescription(int startDatapointId, int datapoints) {
        return new BaosService(3, startDatapointId, datapoints, new byte[0]);
    }

    public static BaosService getDatapointDescriptionString(int startDatapointId, int datapoints) {
        return new BaosService(4, startDatapointId, datapoints, new byte[0]);
    }

    public static BaosService getDatapointValue(int startDatapointId, int datapoints, ValueFilter filter) {
        return new BaosService(5, startDatapointId, datapoints, (byte)filter.ordinal());
    }

    @SafeVarargs
    public static BaosService setDatapointValue(Item<DatapointCommand> ... items) {
        return new BaosService(6, items);
    }

    public static BaosService getParameter(int parameterStartIndex, int bytes) {
        return new BaosService(7, parameterStartIndex, bytes, new byte[0]);
    }

    public static BaosService setDatapointHistoryCommand(int startDatapoint, int datapoints, HistoryCommand command) {
        return new BaosService(8, startDatapoint, datapoints, (byte)command.ordinal());
    }

    public static BaosService getDatapointHistoryState(int startDatapoint, int datapoints) {
        return new BaosService(9, startDatapoint, datapoints, new byte[0]);
    }

    public static BaosService getDatapointHistory(int startDatapoint, int datapoints, Instant start, Instant end) {
        byte[] range = new byte[]{0, 0, 0, 0};
        return new BaosService(10, startDatapoint, datapoints, range);
    }

    public static BaosService getTimer(int startTimer, int timers) {
        return new BaosService(11, startTimer, timers, new byte[0]);
    }

    public static BaosService setTimer(Timer ... timers) {
        if (timers.length == 0) {
            throw new IllegalArgumentException("no timer supplied");
        }
        return new BaosService(12, timers[0].id(), timers.length, BaosService.timerByteArray(timers));
    }

    static BaosService errorResponse(int subService, int startItem, ErrorCode error) {
        return new BaosService(subService, startItem, 0, (byte)error.code());
    }

    public static BaosService from(ByteBuffer data) throws KNXFormatException {
        int size = data.remaining();
        BaosService.ensureMinSize(0, 6, size);
        int mainService = data.get() & 0xFF;
        if (mainService != 240) {
            throw new KNXFormatException("no BAOS service", mainService);
        }
        int i = data.get() & 0xFF;
        int subService = BaosService.extractSubService(i);
        boolean response = (i & 0xC0) == 128;
        int start = data.getShort() & 0xFFFF;
        int items = data.getShort() & 0xFFFF;
        if (response && size == 7 && items == 0) {
            ErrorCode error = ErrorCode.of(data.get() & 0xFF);
            return BaosService.errorResponse(subService, start, error);
        }
        if (subService == 7) {
            BaosService.ensureMinSize(7, 6 + items, size);
            byte[] bytes = new byte[items];
            data.get(bytes);
            return new BaosService(subService, start, items, bytes);
        }
        return new BaosService(subService, start, items, data);
    }

    private BaosService(int service, int startItem, int items, byte ... additionalData) {
        this.subService = service;
        this.start = startItem;
        this.count = items;
        this.data = additionalData;
        this.items = List.of();
    }

    private BaosService(int service, Item<?> ... items) {
        if (items.length == 0) {
            throw new KNXIllegalArgumentException("no item supplied");
        }
        this.subService = service;
        this.start = items[0].id();
        this.count = items.length;
        this.data = new byte[0];
        this.items = List.of(items);
    }

    private BaosService(int service, int start, int items, ByteBuffer buf) throws KNXFormatException {
        this.subService = service;
        this.start = start;
        this.count = items;
        this.data = new byte[0];
        this.items = List.copyOf(this.parseItems(buf));
    }

    public int subService() {
        return this.subService;
    }

    public ErrorCode error() {
        return this.count == 0 ? ErrorCode.of(this.data[0]) : ErrorCode.NoError;
    }

    public List<Item<?>> items() {
        return this.items;
    }

    public byte[] toByteArray() {
        int collectionSize = this.items.stream().mapToInt(Item::size).sum();
        int capacity = 6 + this.data.length + collectionSize;
        ByteBuffer frame = ByteBuffer.allocate(capacity);
        frame.put((byte)-16).put((byte)this.subService).putShort((short)this.start).putShort((short)this.count);
        frame.put(this.data);
        this.items.stream().map(Item::toByteArray).forEach(frame::put);
        return frame.array();
    }

    public String toString() {
        String response = (this.subService & 0x80) != 0 ? ".res" : "";
        String svc = BaosService.subServiceString(this.subService);
        if (this.count == 0) {
            return svc + response + " item " + this.start + " (" + ErrorCode.of(this.data[0] & 0xFF) + ")";
        }
        String s = svc + response + " start " + this.start + " items " + this.count;
        if (this.data.length > 0 || !this.items.isEmpty()) {
            return s + ", " + DataUnitBuilder.toHex(this.data, " ") + this.items.stream().map(item -> (Serializable)((this.subService & 0x7F) == 1 ? Property.of(item.id()) : Integer.valueOf(item.id())) + "=" + DataUnitBuilder.toHex(item.data, "")).collect(Collectors.joining(", "));
        }
        return s;
    }

    private List<Item<?>> parseItems(ByteBuffer buf) throws KNXFormatException {
        ArrayList list = new ArrayList();
        for (int item = 0; item < this.count; ++item) {
            int remaining = buf.remaining();
            BaosService.ensureMinSize(this.subService, 4, remaining);
            if (this.subService == 11 || this.subService == 12) {
                Timer timer = Timer.from(buf);
                list.add(timer.id(), new Item<Timer>(timer.id(), timer, timer.toByteArray()));
                continue;
            }
            int id = this.subService == 4 ? this.start + item : buf.getShort() & 0xFFFF;
            Object info = null;
            if (this.subService == 5 || this.subService == 193) {
                info = new DatapointState(buf.get() & 0xFF);
            } else if (this.subService == 9) {
                int dpState = buf.get() & 0xFF;
                info = dpState;
            } else if (this.subService == 6) {
                DatapointCommand command = DatapointCommand.of(buf.get() & 0xFF);
                info = command;
            } else if (this.subService == 1 || this.subService == 2) {
                info = Property.of(id);
            }
            if (this.subService == 3 || this.subService == 9) {
                int length = this.subService == 3 ? 3 : 4;
                byte[] data = new byte[length];
                buf.get(data);
                list.add(new Item<Object>(id, info, data));
                continue;
            }
            if (this.subService == 10) {
                long timestamp = (long)buf.getInt() & 0xFFFFFFFFL;
                info = Instant.ofEpochSecond(timestamp);
            }
            byte[] data = BaosService.getWithLengthPrefix(buf);
            list.add(new Item<Object>(id, info, data));
        }
        if (buf.remaining() > 0) {
            throw new KNXFormatException(String.format("%s invalid structure, %d leftover bytes", BaosService.subServiceString(this.subService), buf.remaining()));
        }
        if (list.size() != this.count) {
            throw new KNXFormatException(String.format("%s expected %d items, got %d", BaosService.subServiceString(this.subService), this.count, list.size()));
        }
        return list;
    }

    private static byte[] getWithLengthPrefix(ByteBuffer buf) throws KNXFormatException {
        int length = buf.get() & 0xFF;
        BaosService.ensureMinSize(0, length, buf.remaining());
        byte[] data = new byte[length];
        buf.get(data);
        return data;
    }

    private static byte[] timerByteArray(Timer ... timers) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (Timer timer : timers) {
            os.writeBytes(timer.toByteArray());
        }
        return os.toByteArray();
    }

    private static void ensureMinSize(int subService, int expected, int actual) throws KNXFormatException {
        if (expected > actual) {
            String svc = subService != 0 ? BaosService.subServiceString(subService) : "BAOS";
            throw new KNXFormatException(String.format("invalid %s structure, remaining length %d < %d (expected)", svc, actual, expected));
        }
    }

    private static int extractSubService(int subService) throws KNXFormatException {
        if (subService == 193 || subService == 194) {
            return subService;
        }
        int svc = subService & 0xFFFFFF7F;
        if (svc == 0 || svc > 12) {
            throw new KNXFormatException("unsupported BAOS service", subService);
        }
        return svc;
    }

    public static enum Property {
        Invalid(true, 0),
        HardwareType(true, 6),
        HardwareVersion(true, 1),
        FirmwareVersion(true, 1),
        Manufacturer(true, 2),
        ManufacturerApp(true, 2),
        ApplicationId(true, 2),
        ApplicationVersion(true, 2),
        SerialNumber(true, 6),
        TimeSinceReset(true, 4),
        ConnectionState(true, 1),
        MaxBufferSize(true, 2),
        LengthOfDescriptionString(true, 2),
        Baudrate(false, 1),
        CurrentBufferSize(false, 2),
        ProgrammingMode(false, 1),
        ProtocolVersionBinary(true, 1),
        IndicationSending(false, 1),
        ProtocolVersionWeb(true, 1),
        ProtocolVersionRest(true, 1),
        IndividualAddress(false, 2),
        MacAddress(true, 6),
        TunnelingEnabled(false, 1),
        BaosBinaryEnabled(false, 1),
        BaosWebEnabled(false, 1),
        BaosRestEnabled(false, 1),
        HttpFileEnabled(false, 1),
        SearchRequestEnabled(false, 1),
        StructuredDatabase(true, 1),
        MaxManagementClients(true, 1),
        ConnectedManagementClients(true, 1),
        MaxTunnelingClients(true, 1),
        ConnectedTunnelingClients(true, 1),
        MaxBaosUdpClients(true, 1),
        ConnectedBaosUdpClients(true, 1),
        MaxBaosTcpClients(true, 1),
        ConnectedBaosTcpClients(true, 1),
        DeviceFriendlyName(false, 30),
        MaxDatapoints(true, 2),
        ConfiguredDatapoints(true, 2),
        MaxParameterBytes(true, 2),
        DownloadCounter(true, 2),
        IpAssignment(false, 1),
        IpAddress(false, 4),
        SubnetMask(false, 4),
        DefaultGateway(false, 4),
        TimeSinceResetUnit(false, 1),
        SystemTime(false, -1),
        SystemTimezoneOffset(false, 1),
        MenuEnabled(false, 1),
        EnableSuspend(false, 1);

        private final boolean readOnly;

        public static Property of(int id) {
            return Property.values()[id];
        }

        private Property(boolean readOnly, int size) {
            this.readOnly = readOnly;
        }

        public int id() {
            return this.ordinal();
        }

        public String friendlyName() {
            return this.name().replaceAll("([A-Z])", " $1").trim();
        }

        public boolean readOnly() {
            return this.readOnly;
        }
    }

    public static final class Item<T> {
        private final int id;
        private final T info;
        private final byte[] data;

        public static Item<Property> property(Property p, byte[] data) {
            return new Item<Property>(p.id(), p, data);
        }

        public static Item<DatapointCommand> datapoint(int dpId, DatapointCommand cmd, byte[] data) {
            return new Item<DatapointCommand>(dpId, cmd, data);
        }

        private Item(int id, T info, byte[] data) {
            this.id = id;
            this.info = info;
            this.data = (byte[])data.clone();
        }

        public int id() {
            return this.id;
        }

        public T info() {
            return this.info;
        }

        public byte[] data() {
            return (byte[])this.data.clone();
        }

        int size() {
            if (this.info instanceof Timer) {
                return this.data.length;
            }
            if (this.info instanceof Instant) {
                return 7 + this.data.length;
            }
            if (this.info instanceof DatapointCommand) {
                return 4 + this.data.length;
            }
            return 3 + this.data.length;
        }

        byte[] toByteArray() {
            if (this.info instanceof Timer) {
                return this.data;
            }
            ByteBuffer buf = ByteBuffer.allocate(this.size()).putShort((short)this.id);
            if (this.info instanceof Instant) {
                buf.putInt((int)((Instant)this.info).getEpochSecond());
            } else if (this.info instanceof DatapointCommand) {
                buf.put((byte)((DatapointCommand)((Object)this.info)).ordinal());
            }
            return buf.put((byte)this.data.length).put(this.data).array();
        }
    }

    public static enum ValueFilter {
        All,
        ValidOnly,
        UpdatedOnly;


        public static ValueFilter of(int id) {
            return ValueFilter.values()[id];
        }
    }

    public static enum HistoryCommand {
        None,
        Clear,
        Start,
        ClearStart,
        Stop,
        StopClear;


        public static HistoryCommand of(String command) {
            for (HistoryCommand v : HistoryCommand.values()) {
                if (!v.name().equalsIgnoreCase(command)) continue;
                return v;
            }
            throw new KNXIllegalArgumentException("invalid history command '" + command + "'");
        }
    }

    public static final class Timer {
        private static final int TimerSize = 7;
        private static final int JobSetDatapointValue = 1;
        private final int id;
        private final int trigger;
        private final byte[] triggerParams;
        private static final int job = 1;
        private final byte[] jobParams;
        private final String desc;

        public static Timer delete(int timerId) {
            return new Timer(timerId, 0, new byte[0], new byte[0], "");
        }

        public static Timer oneShot(int timerId, ZonedDateTime dateTime, byte[] job, String description) {
            byte[] triggerParams = ByteBuffer.allocate(4).putInt((int)dateTime.toEpochSecond()).array();
            return new Timer(timerId, 1, triggerParams, job, description);
        }

        public static Timer interval(int timerId, ZonedDateTime start, ZonedDateTime end, Duration interval, byte[] job, String description) {
            if (end.isBefore(start)) {
                throw new KNXIllegalArgumentException("end " + end + " is before start " + start);
            }
            ByteBuffer triggerParams = ByteBuffer.allocate(14);
            triggerParams.putInt((int)start.toEpochSecond()).putInt((int)end.toEpochSecond());
            short weeks = (short)(interval.toDays() / 7L);
            byte days = (byte)(interval.toDays() % 7L);
            byte hours = (byte)interval.toHoursPart();
            byte minutes = (byte)interval.toMinutesPart();
            byte seconds = (byte)interval.toSecondsPart();
            triggerParams.putShort(weeks).put(days).put(hours).put(minutes).put(seconds);
            return new Timer(timerId, 2, triggerParams.array(), job, description);
        }

        public static Timer from(ByteBuffer buf) throws KNXFormatException {
            BaosService.ensureMinSize(0, 7, buf.remaining());
            int id = buf.getShort() & 0xFFFF;
            int trigger = buf.get() & 0xFF;
            byte[] triggerParams = BaosService.getWithLengthPrefix(buf);
            int job = buf.get() & 0xFF;
            if (job != 1) {
                throw new KNXFormatException("unsupported timer job type", job);
            }
            byte[] jobParams = BaosService.getWithLengthPrefix(buf);
            byte[] desc = BaosService.getWithLengthPrefix(buf);
            String description = new String(desc, StandardCharsets.UTF_8);
            return new Timer(id, trigger, triggerParams, jobParams, description);
        }

        private Timer(int id, int trigger, byte[] triggerParams, byte[] job, String description) {
            this.id = id;
            this.trigger = trigger;
            if (trigger > 2) {
                throw new KNXIllegalArgumentException("unsupported timer trigger " + trigger);
            }
            this.triggerParams = (byte[])triggerParams.clone();
            this.jobParams = (byte[])job.clone();
            this.desc = description;
        }

        public int id() {
            return this.id;
        }

        public String description() {
            return this.desc;
        }

        public byte[] toByteArray() {
            int capacity = 4 + this.triggerParams.length + 2 + this.jobParams.length + 2 + this.desc.length();
            ByteBuffer buf = ByteBuffer.allocate(capacity);
            buf.putShort((short)this.id).put((byte)this.trigger).put((byte)this.triggerParams.length).put(this.triggerParams);
            buf.put((byte)1).put((byte)this.jobParams.length).put(this.jobParams);
            byte[] descBytes = this.desc.getBytes(StandardCharsets.UTF_8);
            buf.putShort((short)descBytes.length).put(descBytes);
            return buf.array();
        }

        public String toString() {
            String action = (new String[]{"delete", "one-shot", "interval"})[this.trigger];
            String s = action + " timer " + this.id;
            s = s + (String)(this.desc.length() > 0 ? " (" + this.desc + ")" : "");
            if (this.jobParams.length > 4) {
                int dp = (this.jobParams[0] & 0xFF) << 8 | this.jobParams[1] & 0xFF;
                String jobInfo = ", set datapoint " + dp + ", command " + (this.jobParams[2] & 0xFF) + ": " + DataUnitBuilder.toHex(Arrays.copyOfRange(this.jobParams, 4, this.jobParams.length), " ");
                s = s + jobInfo;
            }
            return s;
        }
    }

    public static enum ErrorCode {
        NoError,
        InternalError,
        NoElementFound,
        BufferTooSmall,
        ItemNotWriteable,
        ServiceNotSupported,
        BadServiceParameter,
        BadIdentifier,
        BadCommandOrValue,
        BadLength,
        MessageInconsistent,
        ObjectServerBusy;


        public static ErrorCode of(int code) {
            return ErrorCode.values()[code];
        }

        public int code() {
            return this.ordinal();
        }

        public String toString() {
            return this.message();
        }

        private String message() {
            return this.name().replaceAll("(\\p{Lower})\\B([A-Z])", "$1 $2").toLowerCase();
        }
    }

    public static final class DatapointState {
        private final int state;

        DatapointState(int state) throws KNXFormatException {
            if ((state & 0xFFFFFFE0) != 0) {
                throw new KNXFormatException("invalid datapoint state", state);
            }
            this.state = state;
        }

        public boolean valid() {
            return (this.state & 0x10) != 0;
        }

        public boolean updated() {
            return (this.state & 8) != 0;
        }

        public boolean readRequest() {
            return (this.state & 4) != 0;
        }

        public TransmissionStatus transmissionStatus() {
            return TransmissionStatus.values()[this.state & 3];
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(" ");
            if (this.valid()) {
                joiner.add("valid");
            }
            if (this.updated()) {
                joiner.add("updated");
            }
            joiner.add("tx=" + this.transmissionStatus());
            return joiner.toString();
        }

        public static enum TransmissionStatus {
            IdleOk,
            IdleError,
            InProgress,
            Request;

        }
    }

    public static enum DatapointCommand {
        NoCommand,
        SetValue,
        SendValueOnBus,
        SetValueAndSendOnBus,
        ReadValueViaBus,
        ClearTransmissionState;


        public static DatapointCommand of(int command) {
            return DatapointCommand.values()[command];
        }
    }
}

