/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.buffer;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.buffer.Configuration;
import tuwien.auto.calimero.buffer.LDataObjectQueue;
import tuwien.auto.calimero.buffer.cache.Cache;
import tuwien.auto.calimero.buffer.cache.CacheObject;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMIFactory;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.datapoint.DatapointModel;
import tuwien.auto.calimero.log.LogService;

public class CommandFilter
implements Configuration.NetworkFilter,
Configuration.RequestFilter {
    private final Deque<CacheObject> indicationKeys = new ArrayDeque<CacheObject>();
    private volatile Consumer<LDataObjectQueue> userListener;
    private final Consumer<LDataObjectQueue> queueFull = queue -> {
        try {
            Optional.ofNullable(this.userListener).ifPresent(listener -> listener.accept(queue));
        }
        catch (RuntimeException e) {
            LogService.getLogger("calimero.buffer").error("L-Data queue listener unexpected behavior", (Throwable)e);
        }
    };

    @Override
    public void init(Configuration c) {
    }

    public void setQueueListener(Consumer<LDataObjectQueue> l) {
        this.userListener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNewIndication() {
        Deque<CacheObject> deque = this.indicationKeys;
        synchronized (deque) {
            return !this.indicationKeys.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDataObjectQueue.QueueItem getNextIndication() {
        Deque<CacheObject> deque = this.indicationKeys;
        synchronized (deque) {
            return ((LDataObjectQueue)this.indicationKeys.remove()).getItem();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CEMILData request(KNXAddress dst, Configuration c) {
        Datapoint dp;
        if (!(dst instanceof GroupAddress)) {
            return null;
        }
        DatapointModel<? extends Datapoint> m = c.getDatapointModel();
        if (m != null && ((dp = m.get((GroupAddress)dst)) == null || dp.isStateBased())) {
            return null;
        }
        Deque<CacheObject> deque = this.indicationKeys;
        synchronized (deque) {
            Iterator<CacheObject> i = this.indicationKeys.iterator();
            while (i.hasNext()) {
                CacheObject co = i.next();
                if (!co.getKey().equals(dst)) continue;
                i.remove();
                return ((LDataObjectQueue)co).getItem().getFrame();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(CEMI frame, Configuration c) {
        CEMILData copy;
        Datapoint dp;
        Cache cache = c.getCache();
        if (cache == null || !(frame instanceof CEMILData)) {
            return;
        }
        CEMILData f = (CEMILData)frame;
        if (!(f.getDestination() instanceof GroupAddress)) {
            return;
        }
        GroupAddress dst = (GroupAddress)f.getDestination();
        DatapointModel<? extends Datapoint> m = c.getDatapointModel();
        if (m != null && ((dp = m.get(dst)) == null || dp.isStateBased())) {
            return;
        }
        byte[] d = f.getPayload();
        int svc = d[0] & 3 | d[1] & 0xC0;
        if (svc != 64 && svc != 128) {
            return;
        }
        try {
            copy = (CEMILData)CEMIFactory.create(41, d, f);
        }
        catch (KNXFormatException e) {
            LogService.getLogger("calimero").error("create L_Data.ind for network buffer: {}", (Object)f, (Object)e);
            return;
        }
        CacheObject co = cache.get(dst);
        if (co == null) {
            co = new LDataObjectQueue(dst, true, 10, false, this.queueFull);
        }
        cache.put(co);
        Deque<CacheObject> deque = this.indicationKeys;
        synchronized (deque) {
            this.indicationKeys.add(co);
        }
        ((LDataObjectQueue)co).setFrame(copy);
    }
}

