/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.buffer;

import java.util.function.Consumer;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.buffer.LDataObject;
import tuwien.auto.calimero.cemi.CEMILData;

public class LDataObjectQueue
extends LDataObject {
    private static final int STD_BUFSIZE = 30;
    private int next;
    private int size;
    private long[] timestamps;
    private final boolean overwrite;
    private final boolean consuming;
    private final boolean max;
    private final Consumer<LDataObjectQueue> queueFull;

    public LDataObjectQueue(GroupAddress addr) {
        this(addr, false);
    }

    public LDataObjectQueue(GroupAddress addr, boolean consumingRead) {
        super(addr, (Object)new CEMILData[30]);
        this.timestamps = new long[30];
        this.consuming = consumingRead;
        this.overwrite = false;
        this.max = false;
        this.queueFull = q -> {};
    }

    public LDataObjectQueue(GroupAddress addr, boolean consumingRead, int maxSize, boolean overwrite, Consumer<LDataObjectQueue> queueFull) {
        super(addr, (Object)new CEMILData[maxSize]);
        if (maxSize == 0) {
            throw new KNXIllegalArgumentException("queue size 0 not allowed");
        }
        this.timestamps = new long[maxSize];
        this.overwrite = overwrite;
        this.consuming = consumingRead;
        this.max = true;
        this.queueFull = queueFull;
    }

    @Override
    public synchronized void setFrame(CEMILData frame) {
        if (!frame.getDestination().equals(this.getKey())) {
            throw new KNXIllegalArgumentException("frame key differs from this key");
        }
        if (!this.max) {
            this.ensureCapacity();
        } else if (!this.overwrite && this.size == this.timestamps.length) {
            return;
        }
        CEMILData[] c = (CEMILData[])this.value;
        boolean notifyListener = this.max && this.size == c.length - 1;
        this.resetTimestamp();
        c[this.next] = frame;
        this.timestamps[this.next] = this.getTimestamp();
        ++this.next;
        this.next %= c.length;
        if (this.size < c.length) {
            ++this.size;
        }
        if (notifyListener) {
            this.fireQueueFilled();
        }
    }

    @Override
    public synchronized CEMILData getFrame() {
        CEMILData[] c = (CEMILData[])this.value;
        int first = this.first();
        CEMILData f = c[first];
        if (this.size > 0 && this.consuming) {
            --this.size;
            c[first] = null;
            this.timestamps[first] = 0L;
            if (this.size == 0) {
                this.next = 0;
            }
        }
        return f;
    }

    @Override
    public Object getValue() {
        return this.getFrames();
    }

    public synchronized QueueItem getItem() {
        long ts = this.timestamps[this.first()];
        return new QueueItem(this.getFrame(), ts);
    }

    public final synchronized CEMILData[] getFrames() {
        CEMILData[] buf = new CEMILData[this.size];
        CEMILData[] c = (CEMILData[])this.value;
        this.copyFifo(c, buf);
        if (this.consuming) {
            this.clear();
        }
        return buf;
    }

    public final synchronized long[] getTimestamps() {
        long[] buf = new long[this.size];
        this.copyFifo(this.timestamps, buf);
        return buf;
    }

    public final synchronized int getSize() {
        return this.size;
    }

    public final boolean isOverwrite() {
        return this.overwrite;
    }

    public final boolean isConsuming() {
        return this.consuming;
    }

    public final synchronized void clear() {
        this.timestamps = new long[this.max ? this.timestamps.length : 30];
        this.value = new CEMILData[this.timestamps.length];
        this.next = 0;
        this.size = 0;
    }

    private void copyFifo(Object src, Object dst) {
        int start = this.first();
        int length = Math.min(this.timestamps.length - start, this.size);
        System.arraycopy(src, start, dst, 0, length);
        if (length < this.size) {
            System.arraycopy(src, 0, dst, length, this.size - length);
        }
    }

    private void ensureCapacity() {
        if (this.size == this.timestamps.length) {
            int newCapacity = this.size * 3 / 2 + 1;
            CEMILData[] newData = new CEMILData[newCapacity];
            this.copyFifo(this.value, newData);
            this.value = newData;
            long[] newTS = new long[newCapacity];
            this.copyFifo(this.timestamps, newTS);
            this.timestamps = newTS;
            this.next = this.size;
        }
    }

    private void fireQueueFilled() {
        try {
            this.queueFull.accept(this);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private int first() {
        return (this.next + this.timestamps.length - this.size) % this.timestamps.length;
    }

    public static final class QueueItem {
        private final CEMILData f;
        private final long ts;

        public QueueItem(CEMILData frame, long timestamp) {
            this.f = frame;
            this.ts = timestamp;
        }

        public long getTimestamp() {
            return this.ts;
        }

        public CEMILData getFrame() {
            return this.f;
        }
    }
}

