/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.buffer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.buffer.Configuration;
import tuwien.auto.calimero.buffer.LDataObject;
import tuwien.auto.calimero.buffer.cache.Cache;
import tuwien.auto.calimero.buffer.cache.CacheObject;
import tuwien.auto.calimero.buffer.cache.LFUCache;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.datapoint.DatapointModel;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.NetworkLinkListener;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;

public final class NetworkBuffer
implements AutoCloseable {
    private final List<ConfigImpl> configs = Collections.synchronizedList(new ArrayList());

    private NetworkBuffer() {
    }

    public static NetworkBuffer createBuffer(String installationId) {
        return new NetworkBuffer();
    }

    public Configuration addConfiguration(KNXNetworkLink link) {
        ConfigImpl c = new ConfigImpl(link);
        this.configs.add(c);
        return c;
    }

    public void removeConfiguration(Configuration c) {
        if (this.configs.remove(c)) {
            ((ConfigImpl)c).unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfiguration(KNXNetworkLink bufferedLink) {
        List<ConfigImpl> list = this.configs;
        synchronized (list) {
            for (ConfigImpl lc : this.configs) {
                if (lc.getBufferedLink() != bufferedLink) continue;
                return lc;
            }
        }
        return null;
    }

    public Configuration[] getAllConfigurations() {
        return this.configs.toArray(new Configuration[this.configs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<ConfigImpl> list = this.configs;
        synchronized (list) {
            while (!this.configs.isEmpty()) {
                this.removeConfiguration(this.configs.get(this.configs.size() - 1));
            }
        }
    }

    private static final class ConfigImpl
    implements Configuration {
        private final SquirrelLink lnk;
        private final NetworkLinkListener ll;
        private Cache cache;
        private Configuration.NetworkFilter nwFilter;
        private Configuration.RequestFilter reqFilter;
        private volatile boolean active;
        private volatile boolean queryBufferOnly;
        private DatapointModel<?> model;

        ConfigImpl(KNXNetworkLink link) {
            this.lnk = new SquirrelLink(link);
            this.ll = new SquirrelListener();
            link.addLinkListener(this.ll);
        }

        @Override
        public void activate(boolean activate) {
            this.active = activate;
            if (this.active && this.getCache() == null) {
                this.setCache(new LFUCache(0, 0));
            }
            if (this.active && this.nwFilter == null) {
                this.nwFilter = new Configuration.NetworkFilter(){

                    @Override
                    public void accept(CEMI frame, Configuration c) {
                        Cache localCache = c.getCache();
                        if (localCache == null || !(frame instanceof CEMILData)) {
                            return;
                        }
                        CEMILData f = (CEMILData)frame;
                        CacheObject co = localCache.get(f.getDestination());
                        if (co != null) {
                            ((LDataObject)co).setFrame(f);
                            c.getCache().put(co);
                        } else {
                            localCache.put(new LDataObject(f));
                        }
                    }

                    @Override
                    public void init(Configuration c) {
                    }
                };
            }
            if (this.nwFilter != null) {
                this.nwFilter.init(this);
            }
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public KNXNetworkLink getBaseLink() {
            return this.lnk.base;
        }

        @Override
        public KNXNetworkLink getBufferedLink() {
            return this.lnk;
        }

        @Override
        public void setQueryBufferOnly(boolean bufferOnly) {
            this.queryBufferOnly = bufferOnly;
        }

        @Override
        public synchronized void setCache(Cache c) {
            if (c == null && this.active) {
                this.activate(false);
            }
            this.cache = c;
        }

        @Override
        public synchronized Cache getCache() {
            return this.cache;
        }

        public synchronized void setDatapointModel(DatapointModel<?> m) {
            this.model = m;
            if (this.nwFilter != null) {
                this.nwFilter.init(this);
            }
        }

        public synchronized DatapointModel<?> getDatapointModel() {
            return this.model;
        }

        @Override
        public void setFilter(Configuration.NetworkFilter nf, Configuration.RequestFilter rf) {
            this.nwFilter = nf;
            this.reqFilter = rf;
            if (this.nwFilter != null) {
                this.nwFilter.init(this);
            }
        }

        @Override
        public Configuration.NetworkFilter getNetworkFilter() {
            return this.nwFilter;
        }

        @Override
        public Configuration.RequestFilter getRequestFilter() {
            return this.reqFilter;
        }

        void unregister() {
            this.activate(false);
            this.getBaseLink().removeLinkListener(this.ll);
        }

        private final class SquirrelLink
        implements KNXNetworkLink {
            private final KNXNetworkLink base;
            private final EventListeners<NetworkLinkListener> listeners = new EventListeners();

            SquirrelLink(KNXNetworkLink baseLink) {
                this.base = baseLink;
            }

            @Override
            public void addLinkListener(NetworkLinkListener l) {
                this.base.addLinkListener(l);
                this.listeners.add(l);
            }

            @Override
            public void removeLinkListener(NetworkLinkListener l) {
                this.base.removeLinkListener(l);
                this.listeners.remove(l);
            }

            @Override
            public int getHopCount() {
                return this.base.getHopCount();
            }

            @Override
            public void setHopCount(int count) {
                this.base.setHopCount(count);
            }

            @Override
            public KNXMediumSettings getKNXMedium() {
                return this.base.getKNXMedium();
            }

            @Override
            public void setKNXMedium(KNXMediumSettings a) {
                this.base.setKNXMedium(a);
            }

            @Override
            public void sendRequest(KNXAddress dst, Priority p, byte[] nsdu) throws KNXLinkClosedException, KNXTimeoutException {
                if (!this.doBufferedResponse(dst, nsdu)) {
                    this.base.sendRequest(dst, p, nsdu);
                }
            }

            @Override
            public void sendRequestWait(KNXAddress dst, Priority p, byte[] nsdu) throws KNXTimeoutException, KNXLinkClosedException {
                if (!this.doBufferedResponse(dst, nsdu)) {
                    this.base.sendRequestWait(dst, p, nsdu);
                }
            }

            @Override
            public void send(CEMILData msg, boolean waitForCon) throws KNXTimeoutException, KNXLinkClosedException {
                if (!this.doBufferedResponse(msg.getDestination(), msg.getPayload())) {
                    this.base.send(msg, waitForCon);
                }
            }

            @Override
            public String getName() {
                return "buffered " + this.base.getName();
            }

            @Override
            public boolean isOpen() {
                return this.base.isOpen();
            }

            @Override
            public void close() {
                ConfigImpl.this.activate(false);
                this.base.close();
                this.listeners.removeAll();
            }

            public String toString() {
                return "network buffer " + this.base;
            }

            private boolean doBufferedResponse(KNXAddress dst, byte[] nsdu) throws KNXTimeoutException {
                Configuration.RequestFilter rf = ConfigImpl.this.reqFilter;
                if (rf == null || !this.isOpen() || nsdu.length < 2 || DataUnitBuilder.getAPDUService(nsdu) != 0) {
                    return false;
                }
                CEMILData cemi = rf.request(dst, ConfigImpl.this);
                if (cemi != null) {
                    this.fireIndication(cemi);
                    return true;
                }
                if (ConfigImpl.this.queryBufferOnly) {
                    throw new KNXTimeoutException("query limited to network buffer");
                }
                return false;
            }

            private void fireIndication(CEMILData frame) {
                FrameEvent e = new FrameEvent((Object)this, frame);
                this.listeners.fire(l -> l.indication(e));
            }
        }

        private final class SquirrelListener
        implements NetworkLinkListener {
            private SquirrelListener() {
            }

            @Override
            public void confirmation(FrameEvent e) {
                if (ConfigImpl.this.active && ((CEMILData)e.getFrame()).isPositiveConfirmation()) {
                    this.updateBuffer(e.getFrame());
                }
            }

            @Override
            public void indication(FrameEvent e) {
                if (ConfigImpl.this.active) {
                    this.updateBuffer(e.getFrame());
                }
            }

            @Override
            public void linkClosed(CloseEvent e) {
                ConfigImpl.this.activate(false);
            }

            private void updateBuffer(CEMI frame) {
                if (ConfigImpl.this.nwFilter != null) {
                    ConfigImpl.this.nwFilter.accept(frame, ConfigImpl.this);
                }
            }
        }
    }
}

