/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.buffer.cache;

import tuwien.auto.calimero.KNXIllegalArgumentException;

public class CacheObject {
    protected Object value;
    private final Object key;
    private int count;
    private volatile long timestamp;
    private volatile int usage;

    public CacheObject(Object key, Object value) {
        if (key == null || value == null) {
            throw new KNXIllegalArgumentException("key and value must not be null");
        }
        this.key = key;
        this.value = value;
        this.resetTimestamp();
    }

    public Object getKey() {
        return this.key;
    }

    public synchronized Object getValue() {
        return this.value;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final void resetTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    public final synchronized int getCount() {
        return this.count;
    }

    public final synchronized void incCount() {
        ++this.count;
    }

    protected final synchronized void resetCount() {
        this.count = 0;
    }

    public final int getUsage() {
        return this.usage;
    }

    protected final void setUsage(int newUsage) {
        this.usage = newUsage;
    }
}

