/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.buffer.cache;

import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.buffer.cache.Cache;

public final class CacheSweeper
extends Thread {
    private int sweepInterval;
    private final Cache cache;
    private final Object lock = new Object();

    public CacheSweeper(Cache cache, int sweepInterval) {
        super("Cache sweeper");
        this.cache = cache;
        this.setSweepInterval(sweepInterval);
        this.setPriority(3);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSweepInterval(int interval) {
        if (interval <= 0) {
            throw new KNXIllegalArgumentException("sweep interval has to be > 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.sweepInterval = interval;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSweepInterval() {
        Object object = this.lock;
        synchronized (object) {
            return this.sweepInterval;
        }
    }

    public void stopSweeper() {
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                long start = System.currentTimeMillis();
                Object object = this.lock;
                synchronized (object) {
                    long remaining = (long)this.sweepInterval * 1000L;
                    while (remaining > 0L) {
                        this.lock.wait(remaining);
                        remaining = start + (long)(this.sweepInterval * 1000) - System.currentTimeMillis();
                    }
                }
                this.cache.removeExpired();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

