/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.buffer.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import tuwien.auto.calimero.buffer.cache.Cache;
import tuwien.auto.calimero.buffer.cache.CacheObject;
import tuwien.auto.calimero.buffer.cache.ExpiringCache;
import tuwien.auto.calimero.buffer.cache.StatisticImpl;

public class PositiveListCache
extends ExpiringCache {
    private Set<Object> posList = new HashSet<Object>();
    private long hits;
    private long misses;

    public PositiveListCache(int timeToExpire) {
        super(timeToExpire);
    }

    public PositiveListCache(Collection<? extends Object> positiveList, int timeToExpire) {
        this(timeToExpire);
        this.setPositiveList(positiveList);
    }

    public final synchronized void setPositiveList(Collection<? extends Object> positiveList) {
        if (this.posList.size() == 0) {
            this.posList.addAll(positiveList);
        } else {
            this.posList = new HashSet<Object>(positiveList);
            Iterator i = this.map.keySet().iterator();
            while (i.hasNext()) {
                if (this.posList.contains(i.next())) continue;
                i.remove();
            }
        }
    }

    public final synchronized void addToPositiveList(Object key) {
        this.posList.add(key);
    }

    public final synchronized void removeFromPositiveList(Object key) {
        if (this.posList.remove(key)) {
            this.remove(key);
        }
    }

    public final synchronized Object[] getPositiveList() {
        return this.posList.toArray();
    }

    @Override
    public synchronized void put(CacheObject obj) {
        if (this.posList.contains(obj.getKey())) {
            this.startSweeper();
            obj.resetTimestamp();
            if (this.map instanceof LinkedHashMap) {
                this.map.remove(obj.getKey());
            }
            this.map.put(obj.getKey(), obj);
        }
    }

    @Override
    public synchronized CacheObject get(Object key) {
        CacheObject o = (CacheObject)this.map.get(key);
        if (o != null) {
            PositiveListCache.updateAccess(o);
            ++this.hits;
        } else {
            ++this.misses;
        }
        return o;
    }

    @Override
    public synchronized void remove(Object key) {
        this.map.remove(key);
    }

    @Override
    public synchronized void clear() {
        this.stopSweeper();
        this.map.clear();
    }

    @Override
    public synchronized Cache.Statistic statistic() {
        return new StatisticImpl(this.hits, this.misses);
    }
}

