/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.cemi;

import java.io.ByteArrayInputStream;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.cemi.CEMI;

public class CEMIBusMon
implements CEMI {
    public static final int MC_BUSMON_IND = 43;
    public static final int TYPEID_STATUSINFO = 3;
    public static final int TYPEID_TIMESTAMP = 4;
    public static final int TYPEID_TIMESTAMP_EXT = 6;
    private static final int MIN_ADDINFO_LENGTH = 7;
    private byte[] raw;
    private int status;
    private long tstamp;
    private int tstampType = 4;

    private CEMIBusMon(int status, long timestamp, boolean extTimestamp, byte[] rawFrame) {
        this.status = status;
        this.init(timestamp, extTimestamp, rawFrame);
    }

    public CEMIBusMon(boolean frameError, boolean bitError, boolean parityError, boolean lost, int seqNumber, long timestamp, boolean extTimestamp, byte[] rawFrame) {
        if (seqNumber < 0 || seqNumber > 7) {
            throw new KNXIllegalArgumentException("sequence number out of range [0..7]");
        }
        this.status |= frameError ? 128 : 0;
        this.status |= bitError ? 64 : 0;
        this.status |= parityError ? 32 : 0;
        this.status |= lost ? 8 : 0;
        this.status |= seqNumber;
        this.init(timestamp, extTimestamp, rawFrame);
    }

    public CEMIBusMon(byte[] data, int offset, int length) throws KNXFormatException {
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset, length);
        if (is.available() < 10) {
            throw new KNXFormatException("bus monitor frame length too short", is.available());
        }
        int mc = is.read();
        if (mc != 43) {
            throw new KNXFormatException("msg code indicates no bus monitor frame", mc);
        }
        int ail = is.read();
        if (ail < 7) {
            throw new KNXFormatException("bus monitor add.info length too short", ail);
        }
        boolean statusRead = false;
        boolean timeRead = false;
        int body = is.available() - ail;
        byte[] addInfo = new byte[20];
        while (is.available() > body) {
            int id = is.read();
            int len = is.read();
            is.read(addInfo, 0, len);
            if (!statusRead) {
                statusRead = this.readStatus(id, len, addInfo);
            }
            if (timeRead) continue;
            timeRead = this.readTimestamp(id, len, addInfo);
        }
        if (!timeRead) {
            throw new KNXFormatException("no additional info for timestamp");
        }
        if (!statusRead) {
            throw new KNXFormatException("no additional info for status info");
        }
        this.raw = new byte[is.available()];
        is.read(this.raw, 0, this.raw.length);
    }

    public static CEMIBusMon newWithStatus(int status, long timestamp, boolean extTimestamp, byte[] rawFrame) {
        if (status < 0 || status > 255) {
            throw new KNXIllegalArgumentException("status byte out of range [0..255]");
        }
        return new CEMIBusMon(status, timestamp, extTimestamp, rawFrame);
    }

    public static CEMIBusMon newWithSequenceNumber(int seqNumber, long timestamp, boolean extTimestamp, byte[] rawFrame) {
        if (seqNumber < 0 || seqNumber > 7) {
            throw new KNXIllegalArgumentException("sequence number out of range [0..7]");
        }
        return new CEMIBusMon(seqNumber, timestamp, extTimestamp, rawFrame);
    }

    @Override
    public final int getMessageCode() {
        return 43;
    }

    @Override
    public final byte[] getPayload() {
        return (byte[])this.raw.clone();
    }

    public final boolean getBitError() {
        return (this.status & 0x40) == 64;
    }

    public final boolean getFrameError() {
        return (this.status & 0x80) == 128;
    }

    public final boolean getLost() {
        return (this.status & 8) == 8;
    }

    public final boolean getParityError() {
        return (this.status & 0x20) == 32;
    }

    public final int getSequenceNumber() {
        return this.status & 7;
    }

    public final long getTimestamp() {
        return this.tstamp;
    }

    public final int getTimestampType() {
        return this.tstampType;
    }

    @Override
    public final int getStructLength() {
        return 7 + (this.tstampType == 4 ? 2 : 4) + this.raw.length;
    }

    @Override
    public byte[] toByteArray() {
        byte stampLen = (byte)(this.tstampType == 4 ? 2 : 4);
        byte[] buf = new byte[this.raw.length + 7 + stampLen];
        int i = 0;
        buf[i++] = 43;
        buf[i++] = (byte)(5 + stampLen);
        buf[i++] = 3;
        buf[i++] = 1;
        buf[i++] = (byte)this.status;
        buf[i++] = (byte)this.tstampType;
        buf[i++] = stampLen;
        if (this.tstampType == 6) {
            buf[i++] = (byte)(this.tstamp >> 24);
            buf[i++] = (byte)(this.tstamp >> 16);
        }
        buf[i++] = (byte)(this.tstamp >> 8);
        buf[i++] = (byte)this.tstamp;
        for (int k = 0; k < this.raw.length; ++k) {
            buf[i++] = this.raw[k];
        }
        return buf;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(30);
        buf.append("Busmon.ind ");
        if (this.tstampType == 6) {
            buf.append("ext.");
        }
        buf.append("timestamp ");
        buf.append(this.tstamp);
        buf.append(" seq ").append(this.getSequenceNumber());
        if ((this.status & 0xFFFFFFF8) == 0) {
            buf.append(" (no error)");
        } else {
            buf.append(" (");
            if (this.getBitError()) {
                buf.append("bit error ");
            }
            if (this.getFrameError()) {
                buf.append("frame error ");
            }
            if (this.getLost()) {
                buf.append("lost ");
            }
            if (this.getParityError()) {
                buf.append("parity error");
            }
            if (buf.charAt(buf.length() - 1) == ' ') {
                buf.deleteCharAt(buf.length() - 1);
            }
            buf.append(")");
        }
        buf.append(": ").append(DataUnitBuilder.toHex(this.raw, " "));
        return buf.toString();
    }

    int getStatus() {
        return this.status;
    }

    private boolean readStatus(int typeID, int len, byte[] addInfo) throws KNXFormatException {
        if (typeID != 3) {
            return false;
        }
        if (len != 1) {
            throw new KNXFormatException("wrong status info length", len);
        }
        this.status = addInfo[0] & 0xFF;
        return true;
    }

    private boolean readTimestamp(int typeID, int len, byte[] addInfo) throws KNXFormatException {
        if (typeID != 4 && typeID != 6) {
            return false;
        }
        if (len != 2 && len != 4) {
            throw new KNXFormatException("wrong timestamp info length", len);
        }
        for (int i = 0; i < len; ++i) {
            this.tstamp = this.tstamp << 8 | (long)(addInfo[i] & 0xFF);
        }
        if (len == 4) {
            this.tstampType = 6;
        }
        return true;
    }

    private void init(long timestamp, boolean extTimestamp, byte[] rawFrame) {
        long max;
        this.tstamp = timestamp;
        if (extTimestamp) {
            this.tstampType = 6;
        }
        long l = max = extTimestamp ? 0xFFFFFFFFL : 65535L;
        if (this.tstamp < 0L || this.tstamp > max) {
            throw new KNXIllegalArgumentException("timestamp out of range");
        }
        this.raw = (byte[])rawFrame.clone();
        if (this.raw.length == 0 || this.raw.length > 254) {
            throw new KNXIllegalArgumentException("raw frame length out of range [1..254]");
        }
    }
}

