/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.cemi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.cemi.AdditionalInfo;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.cemi.RFMediumInfo;

public class CEMILDataEx
extends CEMILData
implements Cloneable {
    @Deprecated(forRemoval=true)
    public static final int ADDINFO_PLMEDIUM = 1;
    @Deprecated(forRemoval=true)
    public static final int ADDINFO_RFMEDIUM = 2;
    @Deprecated(forRemoval=true)
    public static final int ADDINFO_TIMESTAMP = 4;
    @Deprecated(forRemoval=true)
    public static final int ADDINFO_TIMEDELAY = 5;
    @Deprecated(forRemoval=true)
    public static final int ADDINFO_TIMESTAMP_EXT = 6;
    @Deprecated(forRemoval=true)
    public static final int ADDINFO_BIBAT = 7;
    private static final int ADDINFO_ESC = 255;
    private static final int[] ADDINFO_LENGTHS = new int[]{0, 2, 8, 1, 2, 4, 4, 2, 4, 3};
    private final List<AdditionalInfo> addInfo = Collections.synchronizedList(new ArrayList());

    public CEMILDataEx(byte[] data, int offset, int length) throws KNXFormatException {
        if (data.length - offset < length || length < 10) {
            throw new KNXFormatException("buffer too short for frame");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset, length);
        this.readMC(is);
        this.readAddInfo(is);
        this.readCtrlAndAddr(is);
        this.readPayload(is);
    }

    public CEMILDataEx(int msgCode, IndividualAddress src, KNXAddress dst, byte[] tpdu, Priority p) {
        this(msgCode, src, dst, tpdu, p, true, true, false, 6);
    }

    public CEMILDataEx(int msgCode, IndividualAddress src, KNXAddress dst, byte[] tpdu, Priority p, boolean confirm) {
        super(msgCode, src, dst, tpdu, p, confirm);
        if (tpdu.length > 16) {
            this.ctrl1 &= 0xFFFFFF7F;
        }
    }

    public CEMILDataEx(int msgCode, IndividualAddress src, KNXAddress dst, byte[] tpdu, Priority p, boolean repeat, boolean domainBroadcast, boolean ack, int hopCount) {
        super(msgCode, src, dst, tpdu, p, repeat, domainBroadcast, ack, hopCount);
        if (tpdu.length > 16) {
            this.ctrl1 &= 0xFFFFFF7F;
        }
    }

    public CEMILDataEx(int msgCode, IndividualAddress src, KNXAddress dst, byte[] tpdu, Priority p, boolean repeat, int hopCount) {
        this(msgCode, src, dst, tpdu, p, repeat, true, false, hopCount);
    }

    private CEMILDataEx(CEMILDataEx rhs) {
        super(rhs.getMessageCode(), rhs.getSource(), rhs.getDestination(), rhs.getPayload(), rhs.getPriority(), rhs.isRepetition(), !rhs.isSystemBroadcast(), rhs.isAckRequested(), rhs.getHopCount());
        this.ctrl1 = rhs.ctrl1;
        this.ctrl2 |= rhs.ctrl2 & 0xF;
        rhs.additionalInfo().forEach(info -> this.addInfo.add(AdditionalInfo.of(info.type(), info.info())));
    }

    public List<AdditionalInfo> additionalInfo() {
        return this.addInfo;
    }

    @Deprecated(forRemoval=true)
    public synchronized void addAdditionalInfo(int infoType, byte[] info) {
        if (infoType < 0 || infoType >= 255) {
            throw new KNXIllegalArgumentException("info type out of range [0..254]");
        }
        if (!CEMILDataEx.checkAddInfoLength(infoType, info.length)) {
            throw new KNXIllegalArgumentException("wrong info data length, expected " + ADDINFO_LENGTHS[infoType] + " bytes");
        }
        this.addInfo.add(new AddInfo(infoType, info));
    }

    @Deprecated(forRemoval=true)
    public synchronized List<? extends AdditionalInfo> getAdditionalInfo() {
        return new ArrayList<AdditionalInfo>(this.addInfo);
    }

    public synchronized byte[] getAdditionalInfo(int infoType) {
        for (AdditionalInfo info : this.addInfo) {
            if (info.type() != infoType) continue;
            return info.info();
        }
        return null;
    }

    @Override
    public int getStructLength() {
        return super.getStructLength() + this.getAddInfoLength();
    }

    public synchronized boolean isExtendedFrame() {
        return (this.ctrl1 & 0x80) == 0;
    }

    @Override
    public synchronized void setBroadcast(boolean domainOnly) {
        super.setBroadcast(domainOnly);
    }

    public synchronized boolean isDomainBroadcast() {
        return (this.ctrl1 & 0x10) != 0;
    }

    @Deprecated(forRemoval=true)
    public synchronized void removeAdditionalInfo(int infoType) {
        this.addInfo.removeIf(info -> info.type() == infoType);
    }

    @Override
    public final synchronized void setHopCount(int hobbes) {
        super.setHopCount(hobbes);
    }

    @Override
    public final void setPriority(Priority p) {
        super.setPriority(p);
    }

    @Override
    public synchronized byte[] toByteArray() {
        return super.toByteArray();
    }

    @Override
    public String toString() {
        String s = super.toString();
        StringBuilder buf = new StringBuilder(s.length() + 50);
        buf.append(this.getSource()).append("->");
        if ((this.ctrl2 & 4) == 4) {
            buf.append(CEMILDataEx.lteTag(this.ctrl2, this.getDestination())).append(" LTE");
        } else {
            buf.append(this.getDestination());
        }
        int svcStart = s.indexOf(32);
        int split = s.indexOf(44);
        buf.append(s.substring(svcStart, split + 1));
        for (AdditionalInfo infoField : this.addInfo) {
            buf.append(" ");
            buf.append(infoField);
            buf.append(",");
        }
        buf.append(s.substring(split + 1));
        return buf.toString();
    }

    private static String lteTag(int extFormat, KNXAddress dst) {
        int ext = extFormat & 3;
        int rawAddress = dst.getRawAddress();
        if (rawAddress == 0) {
            return "broadcast";
        }
        if (ext <= 1) {
            int aptFloor = ext << 6 | (rawAddress & 0xFC00) >> 10;
            int room = (rawAddress & 0x3F0) >> 4;
            int subzone = rawAddress & 0xF;
            return (Serializable)(aptFloor == 0 ? "*" : Integer.valueOf(aptFloor)) + "/" + (Serializable)(room == 0 ? "*" : Integer.valueOf(room)) + "/" + (Serializable)(subzone == 0 ? "*" : Integer.valueOf(subzone));
        }
        if (ext == 2) {
            int domain = rawAddress & 0xF000;
            if (domain == 0) {
                int mapping = rawAddress >> 5;
                int producer = rawAddress >> 5 & 0xF;
                int zone = rawAddress & 0x1F;
                if (mapping < 7) {
                    String[] zones = new String[]{"", "D HotWater", "D ColdWater", "D Vent", "DHW", "Outside", "Calendar"};
                    return zone + " (Z HVAC " + zones[mapping] + ")";
                }
                if ((mapping & 0x70) == 16) {
                    return producer + "/" + zone + " (P/Z HVAC HotWater)";
                }
                if ((mapping & 0x70) == 32) {
                    return producer + "/" + zone + " (P/Z HVAC ColdWater)";
                }
                String s = String.format("%8s", Integer.toBinaryString(rawAddress & 0xFFF)).replace(' ', '0');
                return "0b" + s + " (HVAC)";
            }
            return domain + "/0x" + Integer.toHexString(rawAddress & 0xFFF) + " (app)";
        }
        return "0x" + Integer.toHexString(rawAddress & 0xFFF) + " (?)";
    }

    public CEMILDataEx clone() {
        return new CEMILDataEx(this);
    }

    @Override
    void readAddInfo(ByteArrayInputStream is) throws KNXFormatException {
        int ail = is.read();
        if (ail == 0) {
            return;
        }
        if (ail > is.available()) {
            throw new KNXFormatException("additional info length exceeds frame length", ail);
        }
        for (int remaining = ail; remaining > 0; remaining -= 2) {
            if (remaining < 3) {
                throw new KNXFormatException("invalid additional info, remaining length " + remaining + " < 3 bytes");
            }
            int type = is.read();
            int len = is.read();
            if (len > remaining) {
                throw new KNXFormatException("additional info length of type " + type + " exceeds info block", len);
            }
            byte[] info = new byte[len];
            is.read(info, 0, len);
            try {
                this.addInfo.add(new AddInfo(type, info));
            }
            catch (KNXIllegalArgumentException e) {
                throw new KNXFormatException(e.getMessage());
            }
            remaining -= len;
        }
    }

    @Override
    void readPayload(ByteArrayInputStream is) throws KNXFormatException {
        int len = is.read();
        if (len == 0) {
            len = is.available();
        } else if (++len > is.available()) {
            throw new KNXFormatException("length of tpdu exceeds available data", len);
        }
        this.data = new byte[len];
        is.read(this.data, 0, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void writeAddInfo(ByteArrayOutputStream os) {
        List<AdditionalInfo> list = this.addInfo;
        synchronized (list) {
            os.write(this.getAddInfoLength());
            this.addInfo.sort((lhs, rhs) -> lhs.type() - rhs.type());
            for (AdditionalInfo infoField : this.addInfo) {
                os.write(infoField.type());
                byte[] info = infoField.info();
                os.write(info.length);
                os.write(info, 0, info.length);
            }
        }
    }

    @Override
    void writePayload(ByteArrayOutputStream os) {
        os.write(this.data.length - 1);
        os.write(this.data, 0, this.data.length);
    }

    @Override
    boolean isValidTPDULength(byte[] tpdu) {
        return tpdu.length <= 255;
    }

    private static boolean checkAddInfoLength(int infoType, int len) {
        if (len > 255) {
            throw new KNXIllegalArgumentException("additional info exceeds maximum length of 255 bytes");
        }
        return infoType >= ADDINFO_LENGTHS.length || len == ADDINFO_LENGTHS[infoType];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAddInfoLength() {
        int len = 0;
        List<AdditionalInfo> list = this.addInfo;
        synchronized (list) {
            for (AdditionalInfo field : this.addInfo) {
                len += 2 + field.info().length;
            }
        }
        return len;
    }

    @Deprecated(forRemoval=true)
    public static class AddInfo
    extends AdditionalInfo {
        @Deprecated(forRemoval=true)
        public AddInfo(int infoType, byte[] info) {
            super(infoType, info);
            if (infoType < 0 || infoType >= 255) {
                throw new KNXIllegalArgumentException("cEMI additional info type " + infoType + " out of range [0..254]");
            }
            if (info.length > 255) {
                throw new KNXIllegalArgumentException("cEMI additional info of type " + infoType + " exceeds maximum length of 255 bytes");
            }
            if (infoType < ADDINFO_LENGTHS.length && info.length != ADDINFO_LENGTHS[infoType]) {
                throw new KNXIllegalArgumentException("invalid length " + info.length + " for cEMI additional info type " + infoType);
            }
        }

        public final byte[] getInfo() {
            return this.info();
        }

        public final int getType() {
            return this.type();
        }

        @Override
        public String toString() {
            switch (this.type()) {
                case 2: {
                    return new RFMediumInfo(this.info(), false).toString();
                }
            }
            return super.toString();
        }
    }
}

