/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.cemi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.cemi.AdditionalInfo;
import tuwien.auto.calimero.cemi.CEMI;

public class CemiTData
implements CEMI {
    public static final int IndividualRequest = 74;
    public static final int IndividualIndication = 148;
    public static final int ConnectedRequest = 65;
    public static final int ConnectedIndication = 137;
    private static final int basicLength = 9;
    private final int mc;
    private final byte[] tpdu;
    private final List<AdditionalInfo> additionalInfo = Collections.synchronizedList(new ArrayList());

    public CemiTData(byte[] data, int offset, int length) throws KNXFormatException {
        if (data.length - offset < length || length < 10) {
            throw new KNXFormatException("buffer too short for frame");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset, length);
        this.mc = is.read();
        if (this.mc != 74 && this.mc != 148 && this.mc != 65 && this.mc != 137) {
            throw new KNXFormatException("invalid msg code for T-data frame", this.mc);
        }
        this.readAddInfo(is);
        is.skip(6L);
        int len = is.read();
        if (len == 0) {
            len = is.available();
        } else if (++len > is.available()) {
            throw new KNXFormatException("length of tpdu exceeds available data", len);
        }
        this.tpdu = new byte[len];
        if (!CemiTData.isValidTpduLength(data)) {
            throw new KNXFormatException("length of tpdu exceeds maximum length of 255", len);
        }
        is.read(data, 0, len);
    }

    public CemiTData(int msgCode, byte[] tpdu) {
        this.mc = msgCode;
        if (this.mc != 74 && this.mc != 148 && this.mc != 65 && this.mc != 137) {
            throw new KNXIllegalArgumentException("invalid msg code for T-data frame");
        }
        this.tpdu = (byte[])tpdu.clone();
        if (!CemiTData.isValidTpduLength(tpdu)) {
            throw new KNXIllegalArgumentException("tpdu length " + tpdu.length + " out of range [0..255]");
        }
    }

    @Override
    public int getMessageCode() {
        return this.mc;
    }

    public List<AdditionalInfo> additionalInfo() {
        return this.additionalInfo;
    }

    @Override
    public byte[] getPayload() {
        return (byte[])this.tpdu.clone();
    }

    @Override
    public int getStructLength() {
        return 9 + this.tpdu.length;
    }

    @Override
    public synchronized byte[] toByteArray() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(this.mc);
        this.writeAddInfo(os);
        os.writeBytes(new byte[6]);
        this.writePayload(os);
        return os.toByteArray();
    }

    public String toString() {
        String svc = this.mc == 74 ? "Individual.req" : (this.mc == 148 ? "Individual.ind" : (this.mc == 137 ? "Connected.ind" : (this.mc == 65 ? "Connected.req" : "Unknown")));
        StringBuilder buf = new StringBuilder();
        buf.append("T-Data");
        buf.append(svc);
        for (AdditionalInfo additionalInfo : this.additionalInfo) {
            buf.append(" ");
            buf.append(additionalInfo);
            buf.append(",");
        }
        buf.append(" tpdu ").append(DataUnitBuilder.toHex(this.tpdu, " "));
        return buf.toString();
    }

    private void readAddInfo(ByteArrayInputStream is) throws KNXFormatException {
        int ail = is.read();
        if (ail == 0) {
            return;
        }
        if (ail > is.available()) {
            throw new KNXFormatException("additional info length exceeds frame length", ail);
        }
        for (int remaining = ail; remaining > 0; remaining -= 2) {
            AdditionalInfo info = AdditionalInfo.from(is);
            this.additionalInfo.add(info);
            remaining -= info.info().length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAddInfo(ByteArrayOutputStream os) {
        List<AdditionalInfo> list = this.additionalInfo;
        synchronized (list) {
            os.write(this.additionalInfoLength());
            this.additionalInfo.sort((lhs, rhs) -> lhs.type() - rhs.type());
            for (AdditionalInfo info : this.additionalInfo) {
                os.write(info.type());
                os.write(info.info().length);
                os.writeBytes(info.info());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int additionalInfoLength() {
        int len = 0;
        List<AdditionalInfo> list = this.additionalInfo;
        synchronized (list) {
            for (AdditionalInfo info : this.additionalInfo) {
                len += 2 + info.info().length;
            }
        }
        return len;
    }

    private void writePayload(ByteArrayOutputStream os) {
        boolean rf = this.additionalInfo.stream().anyMatch(info -> info.type() == 2);
        os.write(rf ? 0 : this.tpdu.length - 1);
        os.write(this.tpdu, 0, this.tpdu.length);
    }

    private static boolean isValidTpduLength(byte[] tpdu) {
        return tpdu.length > 0 && tpdu.length <= 255;
    }
}

