/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.datapoint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.datapoint.ChangeListener;
import tuwien.auto.calimero.datapoint.ChangeNotifier;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.datapoint.DatapointModel;
import tuwien.auto.calimero.internal.EventListeners;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlReader;
import tuwien.auto.calimero.xml.XmlWriter;

public class DatapointMap<T extends Datapoint>
implements DatapointModel<T>,
ChangeNotifier {
    private static final String TAG_DATAPOINTS = "datapoints";
    private final Map<GroupAddress, T> points;
    private final EventListeners<ChangeListener> listeners = new EventListeners();
    private final Class<? extends Datapoint> dpTypeRef;

    public DatapointMap() {
        this(Datapoint.class);
    }

    DatapointMap(Class<? extends Datapoint> type) {
        this.points = Collections.synchronizedMap(new HashMap(20));
        this.dpTypeRef = type;
    }

    public DatapointMap(Collection<T> datapoints) {
        HashMap<GroupAddress, Datapoint> m = new HashMap<GroupAddress, Datapoint>(Math.max(2 * datapoints.size(), 11));
        for (Datapoint dp : datapoints) {
            if (m.containsKey(dp.getMainAddress())) {
                throw new KNXIllegalArgumentException("duplicate datapoint " + dp.getMainAddress());
            }
            m.put(dp.getMainAddress(), dp);
        }
        this.points = Collections.synchronizedMap(m);
        this.dpTypeRef = Datapoint.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(T dp) {
        Map<GroupAddress, T> map = this.points;
        synchronized (map) {
            if (this.points.containsKey(((Datapoint)dp).getMainAddress())) {
                throw new KNXIllegalArgumentException("duplicate datapoint " + ((Datapoint)dp).getMainAddress());
            }
            this.points.put(((Datapoint)dp).getMainAddress(), dp);
            this.fireChangeNotification(dp, true);
        }
    }

    @Override
    public void remove(T dp) {
        if (this.points.remove(((Datapoint)dp).getMainAddress()) != null) {
            this.fireChangeNotification(dp, false);
        }
    }

    @Override
    public void removeAll() {
        this.points.clear();
    }

    @Override
    public T get(GroupAddress main) {
        return (T)((Datapoint)this.points.get(main));
    }

    public Collection<T> getDatapoints() {
        return Collections.unmodifiableCollection(this.points.values());
    }

    @Override
    public boolean contains(GroupAddress main) {
        return this.points.containsKey(main);
    }

    @Override
    public boolean contains(T dp) {
        return this.points.containsKey(((Datapoint)dp).getMainAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(XmlReader r) throws KNXMLException {
        if (r.getEventType() != 1) {
            r.nextTag();
        }
        if (r.getEventType() != 1 || !r.getLocalName().equals(TAG_DATAPOINTS)) {
            throw new KNXMLException("datapoints element not found", r);
        }
        Map<GroupAddress, T> map = this.points;
        synchronized (map) {
            while (r.nextTag() == 1) {
                Datapoint dp = Datapoint.create(r);
                if (this.points.containsKey(dp.getMainAddress())) {
                    throw new KNXMLException("KNX address " + dp.getMainAddress().toString() + " in datapoint \"" + dp.getName() + "\" already used", r);
                }
                if (!this.dpTypeRef.isAssignableFrom(dp.getClass())) {
                    throw new KNXMLException("datapoint not of type " + this.dpTypeRef.getTypeName(), r);
                }
                Datapoint castDp = dp;
                this.points.put(dp.getMainAddress(), castDp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(XmlWriter w) throws KNXMLException {
        w.writeStartElement(TAG_DATAPOINTS);
        Map<GroupAddress, T> map = this.points;
        synchronized (map) {
            Iterator<T> i = this.points.values().iterator();
            while (i.hasNext()) {
                ((Datapoint)i.next()).save(w);
            }
        }
        w.writeEndElement();
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChangeNotification(T dp, boolean added) {
        if (added) {
            this.listeners.fire(l -> l.onDatapointAdded(this, (Datapoint)dp));
        } else {
            this.listeners.fire(l -> l.onDatapointRemoved(this, (Datapoint)dp));
        }
    }
}

