/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.datapoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlReader;
import tuwien.auto.calimero.xml.XmlWriter;

public class StateDP
extends Datapoint {
    private static final String TAG_EXPIRATION = "expiration";
    private static final String ATTR_TIMEOUT = "timeout";
    private static final String TAG_UPDATING = "updatingAddresses";
    private static final String TAG_INVALIDATING = "invalidatingAddresses";
    private final List<GroupAddress> invalidating;
    private final List<GroupAddress> updating;
    private volatile int timeout;
    private final List<String> locations = Collections.synchronizedList(new ArrayList());

    public StateDP(GroupAddress main, String name) {
        super(main, name, true);
        this.invalidating = Collections.synchronizedList(new ArrayList());
        this.updating = Collections.synchronizedList(new ArrayList());
    }

    public StateDP(GroupAddress main, String name, int mainNumber, String dptID) {
        this(main, name);
        this.setDPT(mainNumber, dptID);
    }

    public StateDP(GroupAddress main, String name, Collection<GroupAddress> invalidatingAddresses, Collection<GroupAddress> updatingAddresses) {
        super(main, name, true);
        this.invalidating = Collections.synchronizedList(new ArrayList<GroupAddress>(invalidatingAddresses));
        this.updating = Collections.synchronizedList(new ArrayList<GroupAddress>(updatingAddresses));
    }

    public StateDP(XmlReader r) throws KNXMLException {
        super(r);
        if (!this.isStateBased()) {
            throw new KNXMLException("no state based KNX datapoint element", r);
        }
        this.invalidating = Collections.synchronizedList(new ArrayList());
        this.updating = Collections.synchronizedList(new ArrayList());
        this.doLoad(r);
    }

    public final void setExpirationTimeout(int timeout) {
        this.timeout = timeout;
    }

    public final int getExpirationTimeout() {
        return this.timeout;
    }

    public void addUpdatingAddress(GroupAddress ga) {
        if (this.getMainAddress().equals(ga)) {
            throw new KNXIllegalArgumentException("updating address " + ga + " equals main address of this datapoint '" + this.getName() + "'");
        }
        if (!this.updating.contains(ga)) {
            this.updating.add(ga);
        }
    }

    public void addInvalidatingAddress(GroupAddress ga) {
        if (this.getMainAddress().equals(ga)) {
            throw new KNXIllegalArgumentException("updating address " + ga + " equals main address of this datapoint '" + this.getName() + "'");
        }
        if (!this.invalidating.contains(ga)) {
            this.invalidating.add(ga);
        }
    }

    public final void removeAddress(GroupAddress ga) {
        this.updating.remove(ga);
        this.invalidating.remove(ga);
    }

    public Collection<GroupAddress> getAddresses(boolean updatingAddresses) {
        return Collections.unmodifiableCollection(updatingAddresses ? this.updating : this.invalidating);
    }

    public final boolean isInvalidating(GroupAddress a) {
        return this.invalidating.contains(a);
    }

    public final boolean isUpdating(GroupAddress a) {
        return this.updating.contains(a);
    }

    @Override
    public String toString() {
        return "state DP " + this.locations + " " + super.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void doLoad(XmlReader r) throws KNXMLException {
        boolean main = false;
        int event = r.getEventType();
        while (r.hasNext()) {
            if (event == 1) {
                String tag = r.getLocalName();
                if (tag.equals(TAG_EXPIRATION)) {
                    String a = r.getAttributeValue("", ATTR_TIMEOUT);
                    r.getElementText();
                    if (a != null) {
                        try {
                            this.timeout = Integer.decode(a);
                        }
                        catch (NumberFormatException e) {
                            throw new KNXMLException("malformed attribute timeout", r);
                        }
                    }
                } else if (tag.equals("location")) {
                    this.locations.add(r.getElementText());
                } else if (tag.equals(TAG_UPDATING)) {
                    while (r.nextTag() == 1) {
                        this.updating.add(new GroupAddress(r));
                    }
                } else if (tag.equals(TAG_INVALIDATING)) {
                    while (r.nextTag() == 1) {
                        this.invalidating.add(new GroupAddress(r));
                    }
                } else {
                    if (main) throw new KNXMLException("invalid element", r);
                    super.doLoad(r);
                    main = true;
                }
            } else if (event == 2 && r.getLocalName().equals("datapoint")) break;
            event = r.next();
        }
        if (main) return;
        throw new KNXMLException("Datapoint is missing its address", r);
    }

    @Override
    void doSave(XmlWriter w) throws KNXMLException {
        if (this.timeout > 0) {
            w.writeEmptyElement(TAG_EXPIRATION);
            w.writeAttribute(ATTR_TIMEOUT, Integer.toString(this.timeout));
        }
        this.writeList(w, true);
        this.writeList(w, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeList(XmlWriter w, boolean updatingList) {
        List<GroupAddress> list;
        List<GroupAddress> list2 = list = updatingList ? this.updating : this.invalidating;
        synchronized (list2) {
            if (list.isEmpty()) {
                return;
            }
            w.writeStartElement(updatingList ? TAG_UPDATING : TAG_INVALIDATING);
            for (GroupAddress address : list) {
                address.save(w);
            }
            w.writeEndElement();
        }
    }

    public List<String> locations() {
        return this.locations;
    }
}

