/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.log.LogService;

public abstract class DPTXlator {
    public static final String LOG_SERVICE = "calimero.dptxlator.DptXlator";
    protected static final Logger logger = LogService.getLogger("calimero.dptxlator.DptXlator");
    protected short[] data;
    protected DPT dpt;
    protected final int typeSize;
    private final int bitSize;
    protected boolean appendUnit = true;

    DPTXlator(boolean reserved, int bitSize) {
        this.bitSize = bitSize;
        this.typeSize = bitSize / 8;
        this.data = new short[this.typeSize == 0 ? 1 : this.typeSize];
    }

    public DPTXlator(int dataTypeSize) {
        this(false, dataTypeSize * 8);
    }

    public void setValues(String ... values) throws KNXFormatException {
        if (values.length > 0) {
            short[] buf = new short[(this.typeSize > 0 ? this.typeSize : 1) * values.length];
            for (int i = 0; i < values.length; ++i) {
                this.toDPT(values[i], buf, i);
            }
            this.data = buf;
        }
    }

    public abstract String[] getAllValues();

    public void setValue(String value) throws KNXFormatException {
        short[] buf = new short[this.typeSize > 0 ? this.typeSize : 1];
        this.toDPT(value, buf, 0);
        this.data = buf;
    }

    public String getValue() {
        return this.getAllValues()[0];
    }

    public double getNumericValue() throws KNXFormatException {
        throw new KNXFormatException("No simple numeric representation possible");
    }

    public final void setData(byte[] data) {
        this.setData(data, 0);
    }

    public void setData(byte[] data, int offset) {
        if (offset < 0 || offset > data.length) {
            throw new KNXIllegalArgumentException("illegal offset " + offset);
        }
        int size = Math.max(1, this.getTypeSize());
        int length = (data.length - offset) / size * size;
        if (length == 0) {
            throw new KNXIllegalArgumentException("DPT " + this.dpt.getID() + " " + this.dpt.getDescription() + ": data length " + (data.length - offset) + " < required datapoint type width " + size);
        }
        this.data = new short[length];
        for (int i = 0; i < length; ++i) {
            this.data[i] = DPTXlator.ubyte(data[offset + i]);
        }
    }

    public byte[] getData() {
        return this.getData(new byte[this.data.length], 0);
    }

    public byte[] getData(byte[] dst, int offset) {
        int end;
        int min = Math.min(this.data.length, dst.length - offset);
        int n = end = this.typeSize > 0 ? min / this.typeSize * this.typeSize : min;
        if (min > 0 && end == 0) {
            throw new KNXIllegalArgumentException("insufficient space in destination range for DPT " + this.dpt.getID() + " (data length " + min + " < " + Math.max(1, this.getTypeSize()) + ")");
        }
        for (int i = 0; i < end; ++i) {
            dst[offset + i] = (byte)this.data[i];
        }
        return dst;
    }

    public final void setAppendUnit(boolean append) {
        this.appendUnit = append;
    }

    public int getItems() {
        return this.typeSize == 0 ? this.data.length : this.data.length / this.typeSize;
    }

    public final DPT getType() {
        return this.dpt;
    }

    public abstract Map<String, DPT> getSubTypes();

    public int bitSize() {
        return this.bitSize;
    }

    public int getTypeSize() {
        return this.typeSize;
    }

    public List<DPTXlator> split() {
        if (this.getItems() > 1) {
            ArrayList<DPTXlator> l = new ArrayList<DPTXlator>();
            int size = Math.max(this.getTypeSize(), 1);
            byte[] range = new byte[size];
            try {
                Constructor<?> c = this.getClass().getConstructor(DPT.class);
                for (int offset = 0; offset < this.data.length; offset += size) {
                    for (int i = 0; i < size; ++i) {
                        range[i] = (byte)this.data[offset + i];
                    }
                    DPTXlator t = (DPTXlator)c.newInstance(this.getType());
                    t.setData(range);
                    l.add(t);
                }
                return l;
            }
            catch (IllegalArgumentException | ReflectiveOperationException exception) {
                // empty catch block
            }
        }
        return Collections.singletonList(this);
    }

    public String toString() {
        return "DPT " + this.dpt.getID() + " " + Arrays.asList(this.getAllValues()).toString();
    }

    protected abstract void toDPT(String var1, short[] var2, int var3) throws KNXFormatException;

    protected void setTypeID(Map<String, DPT> availableTypes, String dptID) throws KNXFormatException {
        DPT t = availableTypes.get(dptID);
        if (t == null) {
            throw new KNXFormatException("DPT " + dptID + " is not available", dptID);
        }
        this.dpt = t;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        throw new IllegalStateException("invoke on specific translator");
    }

    final String appendUnit(String value) {
        if (this.appendUnit) {
            return value + " " + this.dpt.getUnit();
        }
        return value;
    }

    final String removeUnit(String value) {
        int i;
        if (this.dpt.getUnit().length() > 0 && (i = value.lastIndexOf(this.dpt.getUnit())) > -1) {
            return value.substring(0, i).trim();
        }
        return value.trim();
    }

    static final short ubyte(int value) {
        return (short)(value & 0xFF);
    }

    static Map<String, DPT> loadDatapointTypes(Class<? extends DPTXlator> translator) {
        HashMap<String, DPT> types = new HashMap<String, DPT>();
        Field[] fields = translator.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                Object o = fields[i].get(null);
                if (!(o instanceof DPT)) continue;
                DPT dpt = (DPT)o;
                types.put(dpt.getID(), dpt);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return types;
    }

    final KNXFormatException newException(String msg, String item, Exception cause) {
        String s = this.dpt.getID() + " " + this.dpt.getDescription() + ": " + msg;
        return new KNXFormatException(s, item, cause);
    }

    final KNXFormatException newException(String msg, String item) {
        return this.newException(msg, item, null);
    }
}

