/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlator2ByteUnsigned
extends DPTXlator {
    public static final DPT DPT_VALUE_2_UCOUNT = new DPT("7.001", "Unsigned count", "0", "65535", "pulses");
    public static final DPT DPT_TIMEPERIOD = new DPT("7.002", "Time period in ms", "0", "65535", "ms");
    public static final DPT DPT_TIMEPERIOD_10 = new DPT("7.003", "Time period (resolution 10 ms)", "0", "655.35", "s");
    public static final DPT DPT_TIMEPERIOD_100 = new DPT("7.004", "Time period (resolution 100 ms)", "0", "6553.5", "s");
    public static final DPT DPT_TIMEPERIOD_SEC = new DPT("7.005", "Time period in seconds", "0", "65535", "s");
    public static final DPT DPT_TIMEPERIOD_MIN = new DPT("7.006", "Time period in minutes", "0", "65535", "min");
    public static final DPT DPT_TIMEPERIOD_HOURS = new DPT("7.007", "Time period in hours", "0", "65535", "h");
    public static final DPT DPT_PROP_DATATYPE = new DPT("7.010", "Interface object type", "0", "65535", "");
    public static final DPT DPT_LENGTH = new DPT("7.011", "Length in mm", "0", "65535", "mm");
    public static final DPT DPT_ELECTRICAL_CURRENT = new DPT("7.012", "Electrical current", "0", "65535", "mA");
    public static final DPT DPT_BRIGHTNESS = new DPT("7.013", "Brightness", "0", "65535", "lx");
    public static final DPT DPT_ABSOLUTE_COLOR_TEMPERATURE = new DPT("7.600", "Absolute color temperature", "0", "65535", "K");
    private static final Map<String, DPT> types = DPTXlator2ByteUnsigned.loadDatapointTypes(DPTXlator2ByteUnsigned.class);
    private final NumberFormat formatter = NumberFormat.getNumberInstance();
    private final double max;

    public DPTXlator2ByteUnsigned(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlator2ByteUnsigned(String dptID) throws KNXFormatException {
        super(2);
        this.setTypeID(types, dptID);
        this.max = this.getLimit(this.dpt.getUpperValue());
        this.data = new short[2];
        this.formatter.setMinimumFractionDigits(0);
        this.formatter.setMaximumFractionDigits(2);
        this.formatter.setParseIntegerOnly(!this.dpt.equals(DPT_TIMEPERIOD_10) && !this.dpt.equals(DPT_TIMEPERIOD_100));
    }

    @Override
    public String getValue() {
        return this.makeString(0);
    }

    public final void setValue(int value) throws KNXFormatException {
        if (this.dpt.equals(DPT_TIMEPERIOD_10) || this.dpt.equals(DPT_TIMEPERIOD_100)) {
            this.setValue((double)value / 1000.0);
        } else {
            this.setValue((double)value);
        }
    }

    public final void setValue(double value) throws KNXFormatException {
        short[] buf = new short[2];
        this.toDPT(value, buf, 0);
        this.data = buf;
    }

    public final int getValueUnsigned() {
        return (int)this.fromDPT(0, true);
    }

    @Override
    public final double getNumericValue() {
        return this.getValueUnsigned();
    }

    @Override
    public String[] getAllValues() {
        String[] s = new String[this.data.length / 2];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.makeString(i);
        }
        return s;
    }

    public final void setTimePeriod(long milliseconds) throws KNXFormatException {
        this.data = this.toDPT(milliseconds);
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private double fromDPT(int index, boolean timeperiodMillis) {
        int v = this.data[2 * index] << 8 | this.data[2 * index + 1];
        if (this.dpt.equals(DPT_TIMEPERIOD_10)) {
            return timeperiodMillis ? (double)(v * 10) : (double)v / 100.0;
        }
        if (this.dpt.equals(DPT_TIMEPERIOD_100)) {
            return timeperiodMillis ? (double)(v * 100) : (double)v / 10.0;
        }
        return v;
    }

    private String makeString(int index) {
        return this.appendUnit(this.formatter.format(this.fromDPT(index, false)));
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        try {
            double v;
            String s = this.removeUnit(value);
            if (this.dpt.equals(DPT_TIMEPERIOD_10) || this.dpt.equals(DPT_TIMEPERIOD_100)) {
                v = this.formatter.parse(s).doubleValue();
            } else {
                try {
                    v = Integer.decode(s).intValue();
                }
                catch (NumberFormatException e) {
                    v = this.formatter.parse(s).longValue();
                }
            }
            this.toDPT(v, dst, index);
        }
        catch (NumberFormatException | ParseException e) {
            throw this.newException("wrong value format", value);
        }
    }

    private short[] toDPT(long ms) throws KNXFormatException {
        if (ms < 0L) {
            throw this.newException("negative input value", Long.toString(ms));
        }
        double v = ms;
        if (this.dpt.equals(DPT_TIMEPERIOD_10) || this.dpt.equals(DPT_TIMEPERIOD_100)) {
            v = (double)ms / 1000.0;
        } else if (this.dpt.equals(DPT_TIMEPERIOD_SEC)) {
            v = Math.round((double)ms / 1000.0);
        } else if (this.dpt.equals(DPT_TIMEPERIOD_MIN)) {
            v = Math.round((double)ms / 1000.0 / 60.0);
        } else if (this.dpt.equals(DPT_TIMEPERIOD_HOURS)) {
            v = Math.round((double)ms / 1000.0 / 60.0 / 60.0);
        }
        short[] buf = new short[2];
        this.toDPT(v, buf, 0);
        return buf;
    }

    private void toDPT(double value, short[] dst, int index) throws KNXFormatException {
        if (value < 0.0 || value > this.max) {
            throw this.newException("translation error, input value out of range [" + this.dpt.getLowerValue() + ".." + this.dpt.getUpperValue() + "]", Double.toString(value));
        }
        int v = this.dpt.equals(DPT_TIMEPERIOD_10) ? (int)Math.round(value * 100.0) : (this.dpt.equals(DPT_TIMEPERIOD_100) ? (int)Math.round(value * 10.0) : (int)value);
        dst[2 * index] = DPTXlator2ByteUnsigned.ubyte(v >> 8);
        dst[2 * index + 1] = DPTXlator2ByteUnsigned.ubyte(v);
    }

    private double getLimit(String limit) throws KNXFormatException {
        try {
            double upper;
            double d = Double.parseDouble(limit);
            double d2 = this.dpt.equals(DPT_TIMEPERIOD_10) ? 655.35 : (upper = this.dpt.equals(DPT_TIMEPERIOD_100) ? 6553.5 : 65535.0);
            if (d >= 0.0 && d <= upper) {
                return d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw this.newException("limit not in valid DPT range", limit);
    }
}

