/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlatorBoolean;

public class DPTXlator3BitControlled
extends DPTXlator {
    public static final DPT DPT_CONTROL_DIMMING = new DPT3BitControlled("3.007", "Dimming", DPTXlatorBoolean.DPT_STEP);
    public static final DPT DPT_CONTROL_BLINDS = new DPT3BitControlled("3.008", "Blinds", DPTXlatorBoolean.DPT_UPDOWN);
    private static final Map<String, DPT> types = new HashMap<String, DPT>(3);

    public DPTXlator3BitControlled(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlator3BitControlled(String dptID) throws KNXFormatException {
        super(false, 4);
        this.setTypeID(types, dptID);
        this.data = new short[1];
    }

    public final void setValue(int value) {
        this.setValue(value >= 0, Math.abs(value));
    }

    public final int getValueSigned() {
        return this.control(0) ? this.stepcode(0) : -this.stepcode(0);
    }

    public final void setValue(boolean control, int stepcode) {
        this.data = new short[1];
        this.setControlBit(control);
        this.setStepCode(stepcode);
    }

    @Override
    public String[] getAllValues() {
        String[] buf = new String[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            buf[i] = this.fromDPT(i);
        }
        return buf;
    }

    public final void setControlBit(boolean value) {
        this.data[0] = value ? (short)(this.data[0] | 8) : (short)(this.data[0] & 0xFFFFFFF7);
    }

    public final boolean getControlBit() {
        return this.control(0);
    }

    public final void setStepCode(int value) {
        if (value < 0 || value > 7) {
            throw new KNXIllegalArgumentException("stepcode out of range [0..7]");
        }
        this.data[0] = (short)(this.data[0] & 8 | value);
    }

    public final int getStepCode() {
        return this.stepcode(0);
    }

    public final void setIntervals(int numberOfIntervals) {
        if (numberOfIntervals < 1 || numberOfIntervals > 64) {
            throw new KNXIllegalArgumentException("intervals out of range [1..64]");
        }
        int code = 7;
        for (int thres = 48; thres >= numberOfIntervals; thres >>= 1) {
            --code;
        }
        this.setStepCode(code);
    }

    public final int getIntervals() {
        int code = this.stepcode(0);
        return code == 0 ? 0 : 1 << code - 1;
    }

    @Override
    public void setData(byte[] data, int offset) {
        if (offset < 0 || offset > data.length) {
            throw new KNXIllegalArgumentException("illegal offset " + offset);
        }
        int size = data.length - offset;
        if (size == 0) {
            throw new KNXIllegalArgumentException("data length " + size + " < KNX data type width " + Math.max(1, this.getTypeSize()));
        }
        this.data = new short[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = (short)(data[offset + i] & 0xF);
        }
    }

    @Override
    public byte[] getData(byte[] dst, int offset) {
        int end = Math.min(this.data.length, dst.length - offset);
        for (int i = 0; i < end; ++i) {
            dst[offset + i] = (byte)(dst[offset + i] & 0xF0 | this.data[i]);
        }
        return dst;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private int stepcode(int index) {
        return this.data[index] & 7;
    }

    private boolean control(int index) {
        return (this.data[index] & 8) != 0;
    }

    private String fromDPT(int index) {
        StringBuilder sb = new StringBuilder();
        DPT dptCtrl = ((DPT3BitControlled)this.dpt).getControlDPT();
        sb.append(this.control(index) ? dptCtrl.getUpperValue() : dptCtrl.getLowerValue());
        sb.append(' ');
        int steps = this.stepcode(index);
        if (steps == 0) {
            return sb.append("break").toString();
        }
        sb.append(steps);
        if (this.appendUnit) {
            sb.append(" steps");
        }
        return sb.toString();
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        StringTokenizer token = new StringTokenizer(value);
        if (token.countTokens() == 0) {
            throw this.newException("wrong value format", value);
        }
        String s = token.nextToken();
        if ("break".equals(s)) {
            dst[index] = 0;
            return;
        }
        if (token.countTokens() < 1) {
            throw this.newException("wrong value format", value);
        }
        int ctrl = 0;
        DPT dptCtrl = ((DPT3BitControlled)this.dpt).getControlDPT();
        if (s.equalsIgnoreCase(dptCtrl.getUpperValue())) {
            ctrl = 8;
        } else if (!s.equalsIgnoreCase(dptCtrl.getLowerValue())) {
            throw this.newException("translation error, unknown control value string", s);
        }
        try {
            short code;
            s = token.nextToken();
            if (s.equalsIgnoreCase("break")) {
                s = "0";
            }
            if ((code = Short.decode(s).shortValue()) >= 0 && code < 8) {
                dst[index] = (short)(ctrl + code);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw this.newException("invalid stepcode", s);
    }

    static {
        types.put(DPT_CONTROL_DIMMING.getID(), DPT_CONTROL_DIMMING);
        types.put(DPT_CONTROL_BLINDS.getID(), DPT_CONTROL_BLINDS);
    }

    public static class DPT3BitControlled
    extends DPT {
        private final DPT ctrl;

        public DPT3BitControlled(String typeID, String description, DPT control) {
            super(typeID, description, control.getLowerValue() + " 7", control.getUpperValue() + " 7");
            this.ctrl = control;
        }

        public final DPT getControlDPT() {
            return this.ctrl;
        }
    }
}

