/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlator4ByteFloat
extends DPTXlator {
    public static final DPT DPT_ACCELERATION = new DPT("14.000", "Acceleration", "-3.40282347e+38f", "3.40282347e+38f", "ms\u207b\u00b2");
    public static final DPT DPT_ACCELERATION_ANGULAR = new DPT("14.001", "Acceleration, angular", "-3.40282347e+38f", "3.40282347e+38f", "rad s\u207b\u00b2");
    public static final DPT DPT_ACTIVATION_ENERGY = new DPT("14.002", "Activation energy", "-3.40282347e+38f", "3.40282347e+38f", "J/mol");
    public static final DPT DPT_ACTIVITY = new DPT("14.003", "Activity", "-3.40282347e+38f", "3.40282347e+38f", "s\u207b\u00b9");
    public static final DPT DPT_MOL = new DPT("14.004", "Mol", "-3.40282347e+38f", "3.40282347e+38f", "mol");
    public static final DPT DPT_AMPLITUDE = new DPT("14.005", "Amplitude", "-3.40282347e+38f", "3.40282347e+38f");
    public static final DPT DPT_ANGLE_RAD = new DPT("14.006", "Angle", "-3.40282347e+38f", "3.40282347e+38f", "rad");
    public static final DPT DPT_ANGLE_DEG = new DPT("14.007", "Angle", "-3.40282347e+38f", "3.40282347e+38f", "\u00b0");
    public static final DPT DPT_ANGULAR_MOMENTUM = new DPT("14.008", "Momentum", "-3.40282347e+38f", "3.40282347e+38f", "Js");
    public static final DPT DPT_ANGULAR_VELOCITY = new DPT("14.009", "Angular velocity", "-3.40282347e+38f", "3.40282347e+38f", "rad/s");
    public static final DPT DPT_AREA = new DPT("14.010", "Area", "-3.40282347e+38f", "3.40282347e+38f", "m\u00b2");
    public static final DPT DPT_CAPACITANCE = new DPT("14.011", "Capacitance", "-3.40282347e+38f", "3.40282347e+38f", "F");
    public static final DPT DPT_CHARGE_DENSITY_SURFACE = new DPT("14.012", "Charge density (surface)", "-3.40282347e+38f", "3.40282347e+38f", "C m\u207b\u00b2");
    public static final DPT DPT_CHARGE_DENSITY_VOLUME = new DPT("14.013", "Charge density (volume)", "-3.40282347e+38f", "3.40282347e+38f", "C m\u207b\u00b3");
    public static final DPT DPT_COMPRESSIBILITY = new DPT("14.014", "Compressibility", "-3.40282347e+38f", "3.40282347e+38f", "m\u00b2/N");
    public static final DPT DPT_CONDUCTANCE = new DPT("14.015", "Conductance", "-3.40282347e+38f", "3.40282347e+38f", "\u03a9\u207b\u00b9");
    public static final DPT DPT_ELECTRICAL_CONDUCTIVITY = new DPT("14.016", "Conductivity, electrical", "-3.40282347e+38f", "3.40282347e+38f", "\u03a9\u207b\u00b9m\u207b\u00b9");
    public static final DPT DPT_DENSITY = new DPT("14.017", "Density", "-3.40282347e+38f", "3.40282347e+38f", "kg m\u207b\u00b3");
    public static final DPT DPT_ELECTRIC_CHARGE = new DPT("14.018", "Electric charge", "-3.40282347e+38f", "3.40282347e+38f", "C");
    public static final DPT DPT_ELECTRIC_CURRENT = new DPT("14.019", "Electric current", "-3.40282347e+38f", "3.40282347e+38f", "A");
    public static final DPT DPT_ELECTRIC_CURRENTDENSITY = new DPT("14.020", "Electric current density", "-3.40282347e+38f", "3.40282347e+38f", "A m\u207b\u00b2");
    public static final DPT DPT_ELECTRIC_DIPOLEMOMENT = new DPT("14.021", "Electric dipole moment", "-3.40282347e+38f", "3.40282347e+38f", "Cm");
    public static final DPT DPT_ELECTRIC_DISPLACEMENT = new DPT("14.022", "Electric displacement", "-3.40282347e+38f", "3.40282347e+38f", "C m\u207b\u00b2");
    public static final DPT DPT_ELECTRIC_FIELDSTRENGTH = new DPT("14.023", "Electric field strength", "-3.40282347e+38f", "3.40282347e+38f", "V/m");
    public static final DPT DPT_ELECTRIC_FLUX = new DPT("14.024", "Electric flux", "-3.40282347e+38f", "3.40282347e+38f", "Vm");
    public static final DPT DPT_ELECTRIC_FLUX_DENSITY = new DPT("14.025", "Electric flux density", "-3.40282347e+38f", "3.40282347e+38f", "C m\u207b\u00b2");
    public static final DPT DPT_ELECTRIC_POLARIZATION = new DPT("14.026", "Electric polarization", "-3.40282347e+38f", "3.40282347e+38f", "C m\u207b\u00b2");
    public static final DPT DPT_ELECTRIC_POTENTIAL = new DPT("14.027", "Electric potential", "-3.40282347e+38f", "3.40282347e+38f", "V");
    public static final DPT DPT_ELECTRIC_POTENTIAL_DIFFERENCE = new DPT("14.028", "Electric potential difference", "-3.40282347e+38f", "3.40282347e+38f", "V");
    public static final DPT DPT_ELECTROMAGNETIC_MOMENT = new DPT("14.029", "Electromagnetic moment", "-3.40282347e+38f", "3.40282347e+38f", "A m\u00b2");
    public static final DPT DPT_ELECTROMOTIVE_FORCE = new DPT("14.030", "Electromotive force", "-3.40282347e+38f", "3.40282347e+38f", "V");
    public static final DPT DPT_ENERGY = new DPT("14.031", "Energy", "-3.40282347e+38f", "3.40282347e+38f", "J");
    public static final DPT DPT_FORCE = new DPT("14.032", "Force", "-3.40282347e+38f", "3.40282347e+38f", "N");
    public static final DPT DPT_FREQUENCY = new DPT("14.033", "Frequency", "-3.40282347e+38f", "3.40282347e+38f", "Hz");
    public static final DPT DPT_ANGULAR_FREQUENCY = new DPT("14.034", "Frequency, angular", "-3.40282347e+38f", "3.40282347e+38f", "rad/s");
    public static final DPT DPT_HEAT_CAPACITY = new DPT("14.035", "Heat capacity", "-3.40282347e+38f", "3.40282347e+38f", "J/K");
    public static final DPT DPT_HEAT_FLOWRATE = new DPT("14.036", "Heat flow rate", "-3.40282347e+38f", "3.40282347e+38f", "W");
    public static final DPT DPT_HEAT_QUANTITY = new DPT("14.037", "Heat quantity", "-3.40282347e+38f", "3.40282347e+38f", "J");
    public static final DPT DPT_IMPEDANCE = new DPT("14.038", "Impedance", "-3.40282347e+38f", "3.40282347e+38f", "\u03a9");
    public static final DPT DPT_LENGTH = new DPT("14.039", "Length", "-3.40282347e+38f", "3.40282347e+38f", "m");
    public static final DPT DPT_LIGHT_QUANTITY = new DPT("14.040", "Quantity of Light", "-3.40282347e+38f", "3.40282347e+38f", "J");
    public static final DPT DPT_LUMINANCE = new DPT("14.041", "Luminance", "-3.40282347e+38f", "3.40282347e+38f", "cd m\u207b\u00b2");
    public static final DPT DPT_LUMINOUS_FLUX = new DPT("14.042", "Luminous flux", "-3.40282347e+38f", "3.40282347e+38f", "lm");
    public static final DPT DPT_LUMINOUS_INTENSITY = new DPT("14.043", "Luminous intensity", "-3.40282347e+38f", "3.40282347e+38f", "cd");
    public static final DPT DPT_MAGNETIC_FIELDSTRENGTH = new DPT("14.044", "Magnetic field strength", "-3.40282347e+38f", "3.40282347e+38f", "A/m");
    public static final DPT DPT_MAGNETIC_FLUX = new DPT("14.045", "Magnetic flux", "-3.40282347e+38f", "3.40282347e+38f", "Wb");
    public static final DPT DPT_MAGNETIC_FLUX_DENSITY = new DPT("14.046", "Magnetic flux density", "-3.40282347e+38f", "3.40282347e+38f", "T");
    public static final DPT DPT_MAGNETIC_MOMENT = new DPT("14.047", "Magnetic moment", "-3.40282347e+38f", "3.40282347e+38f", "A m\u00b2");
    public static final DPT DPT_MAGNETIC_POLARIZATION = new DPT("14.048", "Magnetic polarization", "-3.40282347e+38f", "3.40282347e+38f", "T");
    public static final DPT DPT_MAGNETIZATION = new DPT("14.049", "Magnetization", "-3.40282347e+38f", "3.40282347e+38f", "A/m");
    public static final DPT DPT_MAGNETOMOTIVE_FORCE = new DPT("14.050", "Magneto motive force", "-3.40282347e+38f", "3.40282347e+38f", "A");
    public static final DPT DPT_MASS = new DPT("14.051", "Mass", "-3.40282347e+38f", "3.40282347e+38f", "kg");
    public static final DPT DPT_MASS_FLUX = new DPT("14.052", "Mass flux", "-3.40282347e+38f", "3.40282347e+38f", "kg/s");
    public static final DPT DPT_MOMENTUM = new DPT("14.053", "Momentum", "-3.40282347e+38f", "3.40282347e+38f", "N/s");
    public static final DPT DPT_PHASE_ANGLE_RAD = new DPT("14.054", "Phase angle, radiant", "-3.40282347e+38f", "3.40282347e+38f", "rad");
    public static final DPT DPT_PHASE_ANGLE_DEG = new DPT("14.055", "Phase angle, degree", "-3.40282347e+38f", "3.40282347e+38f", "\u00b0");
    public static final DPT DPT_POWER = new DPT("14.056", "Power", "-3.40282347e+38f", "3.40282347e+38f", "W");
    public static final DPT DPT_POWER_FACTOR = new DPT("14.057", "Power factor", "-3.40282347e+38f", "3.40282347e+38f");
    public static final DPT DPT_PRESSURE = new DPT("14.058", "Pressure", "-3.40282347e+38f", "3.40282347e+38f", "Pa");
    public static final DPT DPT_REACTANCE = new DPT("14.059", "Reactance", "-3.40282347e+38f", "3.40282347e+38f", "\u03a9");
    public static final DPT DPT_RESISTANCE = new DPT("14.060", "Resistance", "-3.40282347e+38f", "3.40282347e+38f", "\u03a9");
    public static final DPT DPT_RESISTIVITY = new DPT("14.061", "Resistivity", "-3.40282347e+38f", "3.40282347e+38f", "\u03a9m");
    public static final DPT DPT_SELF_INDUCTANCE = new DPT("14.062", "Self inductance", "-3.40282347e+38f", "3.40282347e+38f", "H");
    public static final DPT DPT_SOLID_ANGLE = new DPT("14.063", "Solid angle", "-3.40282347e+38f", "3.40282347e+38f", "sr");
    public static final DPT DPT_SOUND_INTENSITY = new DPT("14.064", "Sound intensity", "-3.40282347e+38f", "3.40282347e+38f", "W m\u207b\u00b2");
    public static final DPT DPT_SPEED = new DPT("14.065", "Speed", "-3.40282347e+38f", "3.40282347e+38f", "m/s");
    public static final DPT DPT_STRESS = new DPT("14.066", "Stress", "-3.40282347e+38f", "3.40282347e+38f", "Pa");
    public static final DPT DPT_SURFACE_TENSION = new DPT("14.067", "Surface tension", "-3.40282347e+38f", "3.40282347e+38f", "N/m");
    public static final DPT DPT_COMMON_TEMPERATURE = new DPT("14.068", "Temperature in Celsius Degree", "-3.40282347e+38f", "3.40282347e+38f", "\u00b0C");
    public static final DPT DPT_ABSOLUTE_TEMPERATURE = new DPT("14.069", "Temperature, absolute", "-3.40282347e+38f", "3.40282347e+38f", "K");
    public static final DPT DPT_TEMPERATURE_DIFFERENCE = new DPT("14.070", "Temperature difference", "-3.40282347e+38f", "3.40282347e+38f", "K");
    public static final DPT DPT_THERMAL_CAPACITY = new DPT("14.071", "Thermal capacity", "-3.40282347e+38f", "3.40282347e+38f", "J/K");
    public static final DPT DPT_THERMAL_CONDUCTIVITY = new DPT("14.072", "Thermal conductivity", "-3.40282347e+38f", "3.40282347e+38f", "W/m K\u207b\u00b9");
    public static final DPT DPT_THERMOELECTRIC_POWER = new DPT("14.073", "Thermoelectric power", "-3.40282347e+38f", "3.40282347e+38f", "V/K");
    public static final DPT DPT_TIME = new DPT("14.074", "Time", "-3.40282347e+38f", "3.40282347e+38f", "s");
    public static final DPT DPT_TORQUE = new DPT("14.075", "Torque", "-3.40282347e+38f", "3.40282347e+38f", "Nm");
    public static final DPT DPT_VOLUME = new DPT("14.076", "Volume", "-3.40282347e+38f", "3.40282347e+38f", "m\u00b3");
    public static final DPT DPT_VOLUME_FLUX = new DPT("14.077", "Volume flux", "-3.40282347e+38f", "3.40282347e+38f", "m\u00b3/s");
    public static final DPT DPT_WEIGHT = new DPT("14.078", "Weight", "-3.40282347e+38f", "3.40282347e+38f", "N");
    public static final DPT DPT_WORK = new DPT("14.079", "Work", "-3.40282347e+38f", "3.40282347e+38f", "J");
    public static final DPT DPT_APPARENT_POWER = new DPT("14.080", "Apparent Power", "-3.40282347e+38f", "3.40282347e+38f", "VA");
    private static final Map<String, DPT> types = DPTXlator4ByteFloat.loadDatapointTypes(DPTXlator4ByteFloat.class);
    private final float min;
    private final float max;

    public DPTXlator4ByteFloat(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlator4ByteFloat(String dptId) throws KNXFormatException {
        super(4);
        this.setTypeID(types, dptId);
        this.min = this.getLimit(this.dpt.getLowerValue());
        this.max = this.getLimit(this.dpt.getUpperValue());
        this.data = new short[4];
    }

    public void setValue(float value) throws KNXFormatException {
        short[] buf = new short[4];
        this.toDPT(value, buf, 0);
        this.data = buf;
    }

    public final float getValueFloat() {
        return this.fromDPT(0);
    }

    @Override
    public final double getNumericValue() {
        return this.getValueFloat();
    }

    @Override
    public String[] getAllValues() {
        String[] buf = new String[this.data.length / 4];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = this.makeString(i);
        }
        return buf;
    }

    @Override
    public Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String makeString(int index) {
        String s;
        float f = this.fromDPT(index);
        if (Math.abs(f) < 100000.0f) {
            s = String.valueOf(f);
        } else {
            NumberFormat dcf = NumberFormat.getInstance(Locale.US);
            if (dcf instanceof DecimalFormat) {
                ((DecimalFormat)dcf).applyPattern("0.#####E0");
            }
            s = dcf.format(f);
        }
        return this.appendUnit(s);
    }

    private float fromDPT(int index) {
        int i = 4 * index;
        int bits = this.data[i] << 24 | this.data[i + 1] << 16 | this.data[i + 2] << 8 | this.data[i + 3];
        return Float.intBitsToFloat(bits);
    }

    private void toDPT(float value, short[] dst, int index) throws KNXFormatException {
        if (value < this.min || value > this.max) {
            throw this.newException("translation error, value out of range [" + this.dpt.getLowerValue() + ".." + this.dpt.getUpperValue() + "]", Float.toString(value));
        }
        int raw = Float.floatToRawIntBits(value);
        int i = 4 * index;
        dst[i] = DPTXlator4ByteFloat.ubyte(raw >>> 24);
        dst[i + 1] = DPTXlator4ByteFloat.ubyte(raw >>> 16);
        dst[i + 2] = DPTXlator4ByteFloat.ubyte(raw >>> 8);
        dst[i + 3] = DPTXlator4ByteFloat.ubyte(raw);
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        try {
            this.toDPT(Float.parseFloat(this.removeUnit(value)), dst, index);
        }
        catch (NumberFormatException e) {
            throw this.newException("wrong value format", value);
        }
    }

    private float getLimit(String limit) throws KNXFormatException {
        try {
            return Float.parseFloat(limit);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.newException("limit not in valid DPT range", limit);
        }
    }
}

