/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlator64BitSigned
extends DPTXlator {
    public static final DPT DPT_ACTIVE_ENERGY = new DPT("29.010", "Active Energy", "-9223372036854775808", "9223372036854775807", "Wh");
    public static final DPT DPT_APPARENT_ENERGY = new DPT("29.011", "Apparent energy", "-9223372036854775808", "9223372036854775807", "VAh");
    public static final DPT DPT_REACTIVE_ENERGY = new DPT("29.012", "Reactive energy", "-9223372036854775808", "9223372036854775807", "VARh");
    private static final Map<String, DPT> types = DPTXlator64BitSigned.loadDatapointTypes(DPTXlator64BitSigned.class);

    public DPTXlator64BitSigned(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlator64BitSigned(String dptId) throws KNXFormatException {
        super(8);
        this.setTypeID(types, dptId);
        this.data = new short[8];
    }

    public final void setValue(long value) {
        this.data = DPTXlator64BitSigned.toDPT(value, new short[8], 0);
    }

    public final long getValueSigned() {
        return this.fromDPT(0);
    }

    @Override
    public final double getNumericValue() {
        return this.getValueSigned();
    }

    @Override
    public String getValue() {
        return this.makeString(0);
    }

    @Override
    public String[] getAllValues() {
        String[] s = new String[this.data.length / 8];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.makeString(i);
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private long fromDPT(int index) {
        int i = 8 * index;
        return (long)this.data[i] << 56 | (long)this.data[i + 1] << 48 | (long)this.data[i + 2] << 40 | (long)this.data[i + 3] << 32 | (long)this.data[i + 4] << 24 | (long)(this.data[i + 5] << 16) | (long)(this.data[i + 6] << 8) | (long)this.data[i + 7];
    }

    private String makeString(int index) {
        return this.appendUnit(Long.toString(this.fromDPT(index)));
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        try {
            DPTXlator64BitSigned.toDPT(Long.decode(this.removeUnit(value)), dst, index);
        }
        catch (NumberFormatException e) {
            throw this.newException("wrong value format", value);
        }
    }

    private static short[] toDPT(long value, short[] dst, int index) {
        int i = 8 * index;
        dst[i] = (short)(value >> 56 & 0xFFL);
        dst[i + 1] = (short)(value >> 48 & 0xFFL);
        dst[i + 2] = (short)(value >> 40 & 0xFFL);
        dst[i + 3] = (short)(value >> 32 & 0xFFL);
        dst[i + 4] = (short)(value >> 24 & 0xFFL);
        dst[i + 5] = (short)(value >> 16 & 0xFFL);
        dst[i + 6] = (short)(value >> 8 & 0xFFL);
        dst[i + 7] = (short)(value & 0xFFL);
        return dst;
    }
}

