/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.text.DecimalFormat;
import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlator8BitUnsigned
extends DPTXlator {
    public static final DPT DPT_SCALING = new DPT("5.001", "Scaling", "0", "100", "%");
    public static final DPT DPT_ANGLE = new DPT("5.003", "Angle", "0", "360", "\u00b0");
    public static final DPT DPT_PERCENT_U8 = new DPT("5.004", "Percent (8 Bit)", "0", "255", "%");
    public static final DPT DPT_DECIMALFACTOR = new DPT("5.005", "Decimal factor", "0", "255", "ratio");
    public static final DPT DPT_TARIFF = new DPT("5.006", "Tariff information", "0", "254");
    public static final DPT DPT_VALUE_1_UCOUNT = new DPT("5.010", "Unsigned count", "0", "255", "counter pulses");
    public static final DPT DptFanStage = new DPT("5.100", "fan stage", "0", "255", "fan stage");
    private static final Map<String, DPT> types = DPTXlator8BitUnsigned.loadDatapointTypes(DPTXlator8BitUnsigned.class);

    public DPTXlator8BitUnsigned(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlator8BitUnsigned(String dptID) throws KNXFormatException {
        super(1);
        this.setSubType(dptID);
    }

    @Override
    public String getValue() {
        return this.makeString(0);
    }

    public final void setValue(int scaled) throws KNXFormatException {
        this.data = new short[]{this.toDPT(scaled)};
    }

    public final short getValueUnsigned() {
        return this.fromDPT(this.data[0]);
    }

    @Override
    public final double getNumericValue() {
        return this.toValue(this.data[0]);
    }

    public final void setValueUnscaled(int unscaled) {
        this.data = new short[]{DPTXlator8BitUnsigned.ubyte(unscaled)};
    }

    public final short getValueUnscaled() {
        return this.data[0];
    }

    @Override
    public String[] getAllValues() {
        String[] s = new String[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            s[i] = this.makeString(i);
        }
        return s;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private void setSubType(String dptID) throws KNXFormatException {
        this.setTypeID(types, dptID);
        this.data = new short[1];
    }

    private double toValue(short data) {
        double maxPercent = 100.0;
        double maxAngle = 360.0;
        if (this.dpt.equals(DPT_SCALING)) {
            return (double)data * 100.0 / 255.0;
        }
        if (this.dpt.equals(DPT_ANGLE)) {
            return (double)data * 360.0 / 255.0;
        }
        return data;
    }

    private short fromDPT(short data) {
        short value = data;
        if (this.dpt.equals(DPT_SCALING)) {
            value = (short)Math.round((float)data * 100.0f / 255.0f);
        } else if (this.dpt.equals(DPT_ANGLE)) {
            value = (short)Math.round((float)data * 360.0f / 255.0f);
        }
        return value;
    }

    private String makeString(int index) {
        String s = new DecimalFormat("##.#").format(this.toValue(this.data[index]));
        return this.appendUnit(s);
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        try {
            try {
                dst[index] = this.toDPT(Double.parseDouble(this.removeUnit(value).replace(',', '.')));
            }
            catch (NumberFormatException e) {
                dst[index] = this.toDPT(Short.decode(this.removeUnit(value)).shortValue());
            }
        }
        catch (NumberFormatException e) {
            throw this.newException("wrong value format", value);
        }
    }

    private short toDPT(double value) throws KNXFormatException {
        try {
            if (value < 0.0 || value > (double)Integer.parseInt(this.dpt.getUpperValue())) {
                throw this.newException("translation error, input value out of range [" + this.dpt.getLowerValue() + ".." + this.dpt.getUpperValue() + "]", Double.toString(value));
            }
        }
        catch (NumberFormatException e) {
            throw this.newException("parsing upper limit of " + this.dpt, this.dpt.getUpperValue());
        }
        if (this.dpt.equals(DPT_SCALING)) {
            return (short)Math.round(value * 255.0 / 100.0);
        }
        if (this.dpt.equals(DPT_ANGLE)) {
            return (short)Math.round(value * 255.0 / 360.0);
        }
        return (short)value;
    }
}

