/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlatorBoolean
extends DPTXlator {
    public static final DPT DPT_SWITCH = new DPT("1.001", "Switch", "off", "on");
    public static final DPT DPT_BOOL = new DPT("1.002", "Boolean", "false", "true");
    public static final DPT DPT_ENABLE = new DPT("1.003", "Enable", "disable", "enable");
    public static final DPT DPT_RAMP = new DPT("1.004", "Ramp", "no ramp", "ramp");
    public static final DPT DPT_ALARM = new DPT("1.005", "Alarm", "no alarm", "alarm");
    public static final DPT DPT_BINARYVALUE = new DPT("1.006", "Binary value", "low", "high");
    public static final DPT DPT_STEP = new DPT("1.007", "Step", "decrease", "increase");
    public static final DPT DPT_UPDOWN = new DPT("1.008", "Up/Down", "up", "down");
    public static final DPT DPT_OPENCLOSE = new DPT("1.009", "Open/Close", "open", "close");
    public static final DPT DPT_START = new DPT("1.010", "Start", "stop", "start");
    public static final DPT DPT_STATE = new DPT("1.011", "State", "inactive", "active");
    public static final DPT DPT_INVERT = new DPT("1.012", "Invert", "not inverted", "inverted");
    public static final DPT DPT_DIMSENDSTYLE = new DPT("1.013", "Dim send-style", "start/stop", "cyclic");
    public static final DPT DPT_INPUTSOURCE = new DPT("1.014", "Input source", "fixed", "calculated");
    public static final DPT DPT_RESET = new DPT("1.015", "Reset", "no action", "reset");
    public static final DPT DPT_ACK = new DPT("1.016", "Acknowledge", "no action", "acknowledge");
    public static final DPT DPT_TRIGGER = new DPT("1.017", "Trigger", "trigger", "trigger");
    public static final DPT DPT_OCCUPANCY = new DPT("1.018", "Occupancy", "not occupied", "occupied");
    public static final DPT DPT_WINDOW_DOOR = new DPT("1.019", "Window/Door", "closed", "open");
    public static final DPT DPT_LOGICAL_FUNCTION = new DPT("1.021", "Logical function", "OR", "AND");
    public static final DPT DPT_SCENE_AB = new DPT("1.022", "Scene A/B", "scene A", "scene B");
    public static final DPT DPT_SHUTTER_BLINDS_MODE = new DPT("1.023", "Shutter/Blinds mode", "only move up/down", "move up/down + step-stop");
    public static final DPT DptDayNight = new DPT("1.024", "day/night", "day", "night");
    public static final DPT DPT_HEAT_COOL = new DPT("1.100", "Heat/Cool", "cooling", "heating");
    public static final DPT DPT_CONSUMER_PRODUCER = new DPT("1.1200", "Consumer/Producer", "consumer", "producer");
    public static final DPT DPT_ENERGY_DIRECTION = new DPT("1.1201", "Energy direction", "positive", "negative");
    private static final Map<String, DPT> types = DPTXlatorBoolean.loadDatapointTypes(DPTXlatorBoolean.class);

    public DPTXlatorBoolean(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlatorBoolean(String dptID) throws KNXFormatException {
        super(false, 1);
        this.setTypeID(types, dptID);
        this.data = new short[1];
    }

    public final void setValue(boolean value) {
        this.data = new short[]{(short)(value ? 1 : 0)};
    }

    public final boolean getValueBoolean() {
        return (this.data[0] & 1) != 0;
    }

    @Override
    public String getValue() {
        return this.fromDPT(0);
    }

    @Override
    public String[] getAllValues() {
        String[] buf = new String[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            buf[i] = this.fromDPT(i);
        }
        return buf;
    }

    @Override
    public final double getNumericValue() {
        return this.getValueBoolean() ? 1.0 : 0.0;
    }

    @Override
    public void setData(byte[] data, int offset) {
        if (offset < 0 || offset > data.length) {
            throw new KNXIllegalArgumentException("illegal offset " + offset);
        }
        int size = data.length - offset;
        if (size == 0) {
            throw new KNXIllegalArgumentException("data length " + size + " < KNX data type width " + Math.max(1, this.getTypeSize()));
        }
        this.data = new short[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = (short)(data[offset + i] & 1);
        }
    }

    @Override
    public byte[] getData(byte[] dst, int offset) {
        int end = Math.min(this.data.length, dst.length - offset);
        for (int i = 0; i < end; ++i) {
            if (this.data[i] != 0) {
                int n = offset + i;
                dst[n] = (byte)(dst[n] | 1);
                continue;
            }
            int n = offset + i;
            dst[n] = (byte)(dst[n] & 0xFFFFFFFE);
        }
        return dst;
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        if (this.dpt.getLowerValue().equalsIgnoreCase(value)) {
            dst[index] = 0;
        } else if (this.dpt.getUpperValue().equalsIgnoreCase(value)) {
            dst[index] = 1;
        } else {
            throw this.newException("translation error, value not recognized", value);
        }
    }

    private String fromDPT(int index) {
        return this.data[index] != 0 ? this.dpt.getUpperValue() : this.dpt.getLowerValue();
    }
}

