/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlatorDateTime
extends DPTXlator {
    public static final String Description = "Date with Time";
    public static final DPT DPT_DATE_TIME = new DPT("19.001", "Date with time", "1900/01/01 00:00:00", "2155/12/31 24:00:00", "yr/mth/day hr:min:sec");
    public static final int YEAR = 0;
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DAY_OF_WEEK = 3;
    public static final int WORKDAY = 4;
    private static final int DAYLIGHT = 5;
    public static final int MIN_YEAR = 1900;
    public static final int MAX_YEAR = 2155;
    private static final int MONTH = 1;
    private static final int DAY = 2;
    private static final int HOUR = 3;
    private static final int MINUTE = 4;
    private static final int SECOND = 5;
    private static final int DOW = 6;
    private static final String DAYLIGHT_SIGN = "DST";
    private static final String WORKDAY_SIGN = "workday";
    private static final String HOLIDAY_SIGN = "holiday";
    private static final String SYNC_SIGN = "sync";
    private static final String[] DAYS = new String[]{"Any day", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private static final String[] FIELDS = new String[]{"year", "month", "day", "hour", "minute", "second"};
    private static final int[] MIN_VALUES = new int[]{1900, 1, 1, 0, 0, 0, 0};
    private static final int[] MAX_VALUES = new int[]{2155, 12, 31, 24, 59, 59, 7};
    private static final int DST = 1;
    private static final int NO_TIME = 2;
    private static final int NO_DOW = 4;
    private static final int NO_DATE = 8;
    private static final int NO_YEAR = 16;
    private static final int NO_WD = 32;
    private static final int WD = 64;
    private static final int FAULT = 128;
    private static final int QUALITY = 128;
    private static final int SyncSourceReliability = 64;
    private static final int[] FIELD_MASKS = new int[]{16, 8, 2, 4, 32};
    private static final int[] FLAG_MASKS = new int[]{64, 1, 128, 128};
    private static final short[] defaultData = new short[]{0, 1, 1, 0, 0, 0, 36, 0};
    private static Calendar c;
    private static final Map<String, DPT> types;
    private boolean extFormat = true;

    public DPTXlatorDateTime() {
        super(8);
        this.dpt = DPT_DATE_TIME;
        this.data = (short[])defaultData.clone();
    }

    public DPTXlatorDateTime(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlatorDateTime(String dptID) throws KNXFormatException {
        super(8);
        this.setTypeID(types, dptID);
        this.data = (short[])defaultData.clone();
    }

    @Override
    public String[] getAllValues() {
        String[] buf = new String[this.data.length / 8];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = this.fromDPT(i);
        }
        return buf;
    }

    public final void setDate(int year, int month, int day) {
        DPTXlatorDateTime.set(this.data, 0, 0, year);
        DPTXlatorDateTime.set(this.data, 0, 1, month);
        DPTXlatorDateTime.set(this.data, 0, 2, day);
    }

    public final short getYear() {
        return (short)(this.data[0] + 1900);
    }

    public final int getMonth() {
        return this.data[1];
    }

    public final int getDay() {
        return this.data[2];
    }

    public final void setDayOfWeek(int day) {
        DPTXlatorDateTime.set(this.data, 0, 6, day);
    }

    public final int getDayOfWeek() {
        return this.data[3] >> 5;
    }

    public final void setTime(int hour, int minute, int second) {
        if (!DPTXlatorDateTime.check24Hours(hour, minute, second)) {
            throw new KNXIllegalArgumentException("incorrect time");
        }
        DPTXlatorDateTime.set(this.data, 0, 3, hour);
        DPTXlatorDateTime.set(this.data, 0, 4, minute);
        DPTXlatorDateTime.set(this.data, 0, 5, second);
    }

    public final int getHour() {
        return this.data[3] & 0x1F;
    }

    public final int getMinute() {
        return this.data[4];
    }

    public final int getSecond() {
        return this.data[5];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setValue(long milliseconds) {
        DPTXlatorDateTime.initCalendar();
        Calendar calendar = c;
        synchronized (calendar) {
            c.clear();
            c.setTimeInMillis(milliseconds);
            this.data = new short[8];
            DPTXlatorDateTime.set(this.data, 0, 0, c.get(1));
            DPTXlatorDateTime.set(this.data, 0, 1, c.get(2) + 1);
            DPTXlatorDateTime.set(this.data, 0, 2, c.get(5));
            DPTXlatorDateTime.set(this.data, 0, 3, c.get(11));
            DPTXlatorDateTime.set(this.data, 0, 4, c.get(12));
            DPTXlatorDateTime.set(this.data, 0, 5, c.get(13));
            int dow = c.get(7);
            DPTXlatorDateTime.set(this.data, 0, 6, dow == 1 ? 7 : dow - 1);
            this.setBit(0, 1, c.get(16) != 0);
            this.data[6] = (short)(this.data[6] | 0x20);
        }
    }

    public final long getValueMilliseconds() throws KNXFormatException {
        return this.fromDPTMilliseconds(0);
    }

    @Override
    public double getNumericValue() throws KNXFormatException {
        return this.getValueMilliseconds();
    }

    public final void setFaultyClock(boolean faulty) {
        this.setBit(0, 128, faulty);
    }

    public final boolean isFaultyClock() {
        return this.isBitSet(0, 128);
    }

    public final void setClockSync(boolean externalSync) {
        this.setBitEx(0, 128, externalSync);
    }

    public final boolean isSyncClock() {
        return this.isBitSetEx(0, 128);
    }

    public final boolean isReliableSyncSource() {
        return this.isBitSetEx(0, 64);
    }

    public final void setWorkday(boolean workday) {
        this.setValidField(4, true);
        this.setBit(0, 64, workday);
    }

    public final boolean isWorkday() {
        return this.getDateTimeFlag(0, 4);
    }

    public final void setDst(boolean dst) {
        this.setBit(0, 1, dst);
    }

    public final boolean isDst() {
        return this.getDateTimeFlag(0, 5);
    }

    public final void setValidField(int field, boolean valid) {
        if (field < 0 || field >= FIELD_MASKS.length) {
            throw new KNXIllegalArgumentException("illegal field");
        }
        this.setBit(0, FIELD_MASKS[field], !valid);
    }

    public final boolean isValidField(int field) {
        if (field < 0 || field >= FIELD_MASKS.length) {
            throw new KNXIllegalArgumentException("illegal field");
        }
        return !this.isBitSet(0, FIELD_MASKS[field]);
    }

    public final boolean validate() {
        try {
            for (int i = 0; i < this.data.length / 8; ++i) {
                if (!this.isValidField(i, 0) || !this.isValidField(i, 1)) continue;
                this.fromDPTMilliseconds(i);
            }
        }
        catch (KNXFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public void setData(byte[] data, int offset) {
        if (offset < 0 || offset > data.length) {
            throw new KNXIllegalArgumentException("illegal offset " + offset);
        }
        int size = data.length - offset & 0xFFFFFFF8;
        if (size == 0) {
            throw new KNXIllegalArgumentException("DPT " + this.dpt.getID() + " " + this.dpt.getDescription() + ": data length " + (data.length - offset) + " < required datapoint type width " + Math.max(1, this.getTypeSize()));
        }
        short[] buf = new short[size];
        int[] mask = new int[]{255, 15, 31, 255, 63, 63, 255, 192};
        for (int i = 0; i < size; ++i) {
            int field = i & 7;
            buf[i] = (short)(data[offset + i] & mask[field]);
            if ((DPTXlatorDateTime.ubyte(data[offset + i]) & ~mask[field]) != 0) {
                logger.warn("DPT " + this.dpt.getID() + " " + this.dpt.getDescription() + ": reserved bit not 0");
            }
            if (field == 6 && (buf[i] & 8) == 0) {
                DPTXlatorDateTime.checkRange(1, buf[i - 5]);
                DPTXlatorDateTime.checkRange(2, buf[i - 4]);
            }
            if (field != 6 || (buf[i] & 2) != 0) continue;
            DPTXlatorDateTime.checkRange(3, buf[i - 3] & 0x1F);
            DPTXlatorDateTime.checkRange(4, buf[i - 2]);
            DPTXlatorDateTime.checkRange(5, buf[i - 1]);
            if (DPTXlatorDateTime.check24Hours(buf[i - 3] & 0x1F, buf[i - 2], buf[i - 1])) continue;
            throw new KNXIllegalArgumentException("incorrect time");
        }
        this.data = buf;
    }

    public final void useValueFormat(boolean extended) {
        this.extFormat = extended;
    }

    @Override
    public Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private static void checkRange(int field, int v) {
        if (v < MIN_VALUES[field] || v > MAX_VALUES[field]) {
            throw new KNXIllegalArgumentException(FIELDS[field] + " out of range: " + v);
        }
    }

    private static boolean check24Hours(int hr, int min, int sec) {
        return hr != 24 || min == 0 && sec == 0;
    }

    private String fromDPT(int index) {
        if (this.isBitSet(index, 128)) {
            return "corrupted date/time";
        }
        StringBuilder sb = new StringBuilder(20);
        int i = index * 8;
        if (!this.isBitSet(index, 16)) {
            sb.append(this.data[i] + 1900);
        }
        if (!this.isBitSet(index, 8)) {
            sb.append('/').append(this.data[i + 1]);
            sb.append('/').append(this.data[i + 2]);
        }
        if (this.extFormat) {
            if (!this.isBitSet(index, 4)) {
                sb.append(", ").append(DAYS[this.data[i + 3] >> 5]);
            }
            if (!this.isBitSet(index, 32)) {
                sb.append(" (").append(this.isBitSet(index, 64) ? WORKDAY_SIGN : HOLIDAY_SIGN).append(')');
            }
        }
        if (!this.isBitSet(index, 2)) {
            sb.append(' ').append(this.data[i + 3] & 0x1F);
            sb.append(':').append(this.data[i + 4]).append(':').append(this.data[i + 5]);
            if (this.extFormat && this.isBitSet(index, 1)) {
                sb.append(' ').append(DAYLIGHT_SIGN);
            }
        }
        if (this.extFormat && this.isBitSetEx(index, 128)) {
            sb.append(" (sync)");
        }
        return sb.toString();
    }

    private long fromDPTMilliseconds(int index) throws KNXFormatException {
        if (this.isBitSet(index, 128) || !this.isValidField(index, 0) || !this.isValidField(index, 1)) {
            throw new KNXFormatException("insufficient information for calendar");
        }
        DPTXlatorDateTime.initCalendar();
        int i = index * 8;
        Calendar calendar = c;
        synchronized (calendar) {
            c.clear();
            c.set(this.data[i] + 1900, this.data[i + 1] - 1, this.data[i + 2]);
            if (this.isValidField(index, 2)) {
                boolean cheat = (this.data[i + 3] & 0x1F) == 24;
                c.set(11, cheat ? 23 : this.data[i + 3] & 0x1F);
                c.set(12, cheat ? 59 : this.data[i + 4]);
                c.set(13, cheat ? 59 : this.data[i + 5]);
                if (cheat) {
                    c.set(14, 999);
                }
            }
            try {
                long ms = c.getTimeInMillis();
                if (this.isValidField(index, 3)) {
                    int day = c.get(7);
                    int n = day = day == 1 ? 7 : day - 1;
                    if (this.data[i + 3] >> 5 != day) {
                        throw new KNXFormatException("differing day of week");
                    }
                }
                if (this.getDateTimeFlag(index, 5) != (c.get(16) != 0)) {
                    throw new KNXFormatException("differing daylight saving time");
                }
                return ms;
            }
            catch (IllegalArgumentException e) {
                throw new KNXFormatException("invalid calendar value", e.getMessage());
            }
        }
    }

    private boolean getDateTimeFlag(int index, int field) {
        int f = field - 4;
        if (f < 0 || f >= FLAG_MASKS.length) {
            throw new KNXIllegalArgumentException("illegal field");
        }
        return this.isBitSet(index, FLAG_MASKS[f]);
    }

    private boolean isValidField(int index, int field) {
        return !this.isBitSet(index, FIELD_MASKS[field]);
    }

    private boolean isBitSet(int index, int mask) {
        return (this.data[8 * index + 6] & mask) != 0;
    }

    private boolean isBitSetEx(int index, int mask) {
        return (this.data[8 * index + 7] & mask) != 0;
    }

    private static void set(short[] dst, int index, int field, int v) {
        DPTXlatorDateTime.checkRange(field, v);
        int i = 8 * index + field;
        if (field == 0) {
            dst[i] = (short)(v - 1900);
        } else if (field == 6) {
            dst[i - 3] = (short)(v << 5 | dst[i - 3] & 0x1F);
        } else {
            dst[i] = field == 3 ? (short)(v | dst[i] & 0xE0) : (short)v;
        }
    }

    private void setBit(int index, int mask, boolean bit) {
        DPTXlatorDateTime.setBit(this.data, index, mask, bit);
    }

    private static void setBit(short[] dst, int index, int mask, boolean bit) {
        if (bit) {
            int n = 8 * index + 6;
            dst[n] = (short)(dst[n] | mask);
        } else {
            int n = 8 * index + 6;
            dst[n] = (short)(dst[n] & ~mask);
        }
    }

    private void setBitEx(int index, int mask, boolean bit) {
        DPTXlatorDateTime.setBitEx(this.data, index, mask, bit);
    }

    private static void setBitEx(short[] v, int index, int mask, boolean bit) {
        if (bit) {
            int n = 8 * index + 7;
            v[n] = (short)(v[n] | mask);
        } else {
            int n = 8 * index + 7;
            v[n] = (short)(v[n] & ~mask);
        }
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        int field;
        StringTokenizer t = new StringTokenizer(value, ":-/ (,.)");
        int k = 8 * index;
        dst[k + 6] = 62;
        int sync = 0;
        int day = 0;
        int workingDay = 0;
        int maxTokens = 10;
        short[] numbers = new short[10];
        int count = 0;
        for (int i = 0; i < 10 && t.hasMoreTokens(); ++i) {
            String s = t.nextToken();
            try {
                short no = Short.parseShort(s);
                if (no < 0) {
                    throw this.newException("negative date/time " + s, s);
                }
                if (no >= 1900 && no <= 2155) {
                    DPTXlatorDateTime.set(dst, index, 0, no);
                    DPTXlatorDateTime.setBit(dst, index, 16, false);
                    continue;
                }
                numbers[count++] = no;
                continue;
            }
            catch (NumberFormatException e) {
                if (s.equalsIgnoreCase(DAYLIGHT_SIGN)) {
                    DPTXlatorDateTime.setBit(dst, index, 1, true);
                    continue;
                }
                if (s.equalsIgnoreCase(WORKDAY_SIGN) || s.equalsIgnoreCase(HOLIDAY_SIGN)) {
                    if (++workingDay > 1) {
                        boolean wd = (dst[k + 6] & 0x40) != 0;
                        throw this.newException("working day information already set to " + (wd ? "'working day'" : "'holiday'"), s);
                    }
                    DPTXlatorDateTime.setBit(dst, index, 32, false);
                    DPTXlatorDateTime.setBit(dst, index, 64, s.equalsIgnoreCase(WORKDAY_SIGN));
                    continue;
                }
                if (s.equalsIgnoreCase(SYNC_SIGN)) {
                    if (++sync > 1) {
                        throw this.newException("duplicate flag", s);
                    }
                    DPTXlatorDateTime.setBitEx(dst, index, 128, true);
                    continue;
                }
                if (s.length() == 3 && ++day == 1) {
                    boolean anyday;
                    int dow;
                    String prefix = s.toLowerCase();
                    for (dow = DAYS.length - 1; dow >= 0 && !DAYS[dow].toLowerCase().startsWith(prefix); --dow) {
                    }
                    boolean bl = anyday = dow == 0 && t.hasMoreTokens() && t.nextToken().equalsIgnoreCase("day");
                    if (dow <= 0 && !anyday) {
                        throw this.newException(s + ": wrong weekday", s, null);
                    }
                    DPTXlatorDateTime.set(dst, index, 6, dow);
                    DPTXlatorDateTime.setBit(dst, index, 4, false);
                    continue;
                }
                throw this.newException("wrong date/time " + s, s, null);
            }
        }
        if (count == 0) {
            return;
        }
        if (count == 1 || count == 4) {
            throw this.newException("ambiguous date/time", value);
        }
        int n = field = count == 3 ? 3 : 1;
        if (field == 3 || count == 5) {
            DPTXlatorDateTime.setBit(dst, index, 2, false);
        }
        if (field == 1) {
            DPTXlatorDateTime.setBit(dst, index, 8, false);
        }
        int i = 0;
        while (i < count) {
            DPTXlatorDateTime.set(dst, index, field, numbers[i]);
            ++i;
            ++field;
        }
        if (field == 6 && !DPTXlatorDateTime.check24Hours(numbers[count - 3], numbers[count - 2], numbers[count - 1])) {
            throw this.newException("incorrect time", value);
        }
    }

    private static synchronized void initCalendar() {
        if (c == null) {
            c = Calendar.getInstance();
            c.setLenient(false);
        }
    }

    static {
        types = new HashMap<String, DPT>(3);
        types.put(DPT_DATE_TIME.getID(), DPT_DATE_TIME);
    }
}

