/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlatorTime
extends DPTXlator {
    public static final DPT DPT_TIMEOFDAY = new DPT("10.001", "Time of day", "no-day, 00:00:00", "Sun, 23:59:59", "dow, hh:mm:ss");
    private static final int DOW = 0;
    private static final int HOUR = 0;
    private static final int MINUTE = 1;
    private static final int SECOND = 2;
    private static final Map<Long, String> dow = new HashMap<Long, String>();
    private static final ResolverStyle defaultResolverStyle = ResolverStyle.STRICT;
    static final DateTimeFormatterBuilder builder;
    private static volatile DateTimeFormatter dtf;
    private static final Map<String, DPT> types;

    public DPTXlatorTime() {
        super(3);
        this.dpt = DPT_TIMEOFDAY;
    }

    public DPTXlatorTime(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlatorTime(String dptId) throws KNXFormatException {
        super(3);
        this.setTypeID(types, dptId);
    }

    public static final void useValueFormat(String pattern) {
        DPTXlatorTime.useValueFormat(DateTimeFormatter.ofPattern(pattern).withResolverStyle(defaultResolverStyle));
    }

    public static final void useValueFormat(DateTimeFormatter formatter) {
        dtf = formatter;
    }

    @Override
    public String[] getAllValues() {
        String[] buf = new String[this.data.length / 3];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = this.fromDPT(i);
        }
        return buf;
    }

    public final void setValue(int dayOfWeek, int hour, int minute, int second) {
        this.data = DPTXlatorTime.set(dayOfWeek, hour, minute, second, new short[3], 0);
    }

    public final int getDayOfWeek() {
        return this.data[0] >> 5;
    }

    Optional<DayOfWeek> dayOfWeek() {
        int dayOfWeek = this.getDayOfWeek();
        return dayOfWeek == 0 ? Optional.empty() : Optional.of(DayOfWeek.of(dayOfWeek));
    }

    public final int getHour() {
        return this.data[0] & 0x1F;
    }

    public final int getMinute() {
        return this.data[1];
    }

    public final int getSecond() {
        return this.data[2];
    }

    public final LocalTime localTime() {
        return this.localTime(0);
    }

    public final void setValue(long milliseconds) {
        this.data = DPTXlatorTime.toDPT(milliseconds, new short[3], 0);
    }

    public final long getValueMilliseconds() {
        return this.fromDPTMillis(0);
    }

    @Override
    public double getNumericValue() {
        return this.getValueMilliseconds();
    }

    @Override
    public void setData(byte[] data, int offset) {
        if (offset < 0 || offset > data.length) {
            throw new KNXIllegalArgumentException("illegal offset " + offset);
        }
        int size = (data.length - offset) / 3 * 3;
        if (size == 0) {
            throw new KNXIllegalArgumentException("DPT " + this.dpt.getID() + " " + this.dpt.getDescription() + ": data length " + size + " < required datapoint type width " + Math.max(1, this.getTypeSize()));
        }
        short[] buf = new short[size];
        int item = 0;
        for (int i = offset; i < size + offset; i += 3) {
            DPTXlatorTime.set((data[i + 0] & 0xE0) >> 5, data[i + 0] & 0x1F, data[i + 1] & 0x3F, data[i + 2] & 0x3F, buf, item++);
            if ((data[i + 1] & 0xFFFFFFC0) + (data[i + 2] & 0xFFFFFFC0) == 0) continue;
            logger.warn("DPT " + this.dpt.getID() + " " + this.dpt.getDescription() + ": reserved bit not 0");
        }
        this.data = buf;
    }

    @Override
    public Map<String, DPT> getSubTypes() {
        return types;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDPT(int index) {
        int i = index * 3;
        int day = this.data[i + 0] >> 5;
        String prefix = day == 0 ? "" : dow.get(day) + ", ";
        return prefix + dtf.format(this.localTime(index));
    }

    private long fromDPTMillis(int index) {
        return ZonedDateTime.now().with(this.localTime(index)).toInstant().toEpochMilli();
    }

    private LocalTime localTime(int index) {
        int i = index * 3;
        int h = this.data[i + 0] & 0x1F;
        short m = this.data[i + 1];
        short s = this.data[i + 2];
        return LocalTime.of(h, m, s);
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        try {
            TemporalAccessor time = dtf.parse(value.trim());
            long dow = time.isSupported(ChronoField.DAY_OF_WEEK) ? time.getLong(ChronoField.DAY_OF_WEEK) : 0L;
            int h = time.get(ChronoField.HOUR_OF_DAY);
            int m = time.get(ChronoField.MINUTE_OF_HOUR);
            int s = time.get(ChronoField.SECOND_OF_MINUTE);
            DPTXlatorTime.set((int)dow, h, m, s, dst, index);
        }
        catch (DateTimeParseException e) {
            throw this.newException("invalid time", value, e);
        }
    }

    private static short[] toDPT(long milliseconds, short[] dst, int index) {
        ZonedDateTime atZone = Instant.ofEpochMilli(milliseconds).atZone(ZoneId.systemDefault());
        LocalTime time = atZone.toLocalTime();
        DPTXlatorTime.set(atZone.getDayOfWeek().getValue(), time.getHour(), time.getMinute(), time.getSecond(), dst, index);
        return dst;
    }

    private static short[] set(int dow, int hour, int minute, int second, short[] dst, int index) {
        if (dow < 0 || dow > 7) {
            throw new KNXIllegalArgumentException("day of week out of range [0..7]");
        }
        if (hour < 0 || hour > 23) {
            throw new KNXIllegalArgumentException("hour out of range [0..23]");
        }
        if (minute < 0 || minute > 59) {
            throw new KNXIllegalArgumentException("minute out of range [0..59]");
        }
        if (second < 0 || second > 59) {
            throw new KNXIllegalArgumentException("second out of range [0..59]");
        }
        int i = 3 * index;
        dst[i + 0] = (short)(dow << 5 | hour);
        dst[i + 1] = (short)minute;
        dst[i + 2] = (short)second;
        return dst;
    }

    static {
        types = new HashMap<String, DPT>(3);
        types.put(DPT_TIMEOFDAY.getID(), DPT_TIMEOFDAY);
        dow.put(0L, "no-day");
        dow.put(1L, "Mon");
        dow.put(2L, "Tue");
        dow.put(3L, "Wed");
        dow.put(4L, "Thu");
        dow.put(5L, "Fri");
        dow.put(6L, "Sat");
        dow.put(7L, "Sun");
        builder = new DateTimeFormatterBuilder().parseCaseInsensitive().parseStrict().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, dow).optionalStart().appendLiteral(',').optionalEnd().appendLiteral(' ').optionalEnd().append(DateTimeFormatter.ISO_TIME);
        dtf = builder.toFormatter();
    }
}

