/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.dptxlator;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;

public class DPTXlatorUtf8
extends DPTXlator {
    public static final DPT DPT_UTF8 = new DPT("28.001", "UTF-8", "", "");
    private static final Map<String, DPT> types = new HashMap<String, DPT>(5);
    private static final int maxLength = 0x100000;
    private int items = 1;

    public DPTXlatorUtf8(DPT dpt) throws KNXFormatException {
        this(dpt.getID());
    }

    public DPTXlatorUtf8(String dptID) throws KNXFormatException {
        super(1);
        this.setTypeID(types, dptID);
        this.data = new short[1];
    }

    @Override
    public void setValues(String ... values) throws KNXFormatException {
        if (values.length == 0) {
            return;
        }
        int length = 0;
        for (int i = 0; i < values.length; ++i) {
            length += this.toUtf8(values[i]).length + 1;
        }
        short[] buf = new short[length];
        for (int i = 0; i < values.length; ++i) {
            this.toDPT(values[i], buf, i);
        }
        this.data = buf;
        this.items = values.length;
    }

    @Override
    public String[] getAllValues() {
        String[] buf = new String[this.getItems()];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = this.fromDPT(i);
        }
        return buf;
    }

    @Override
    public void setValue(String value) throws KNXFormatException {
        this.setValues(value);
    }

    @Override
    public void setData(byte[] data, int offset) {
        if (offset < 0 || offset > data.length) {
            throw new KNXIllegalArgumentException("illegal offset " + offset);
        }
        this.toDPT(data, offset);
    }

    @Override
    public int getItems() {
        return this.items;
    }

    @Override
    public final int getTypeSize() {
        return DPTXlatorUtf8.findOffsetFor(1, this.data);
    }

    @Override
    public final Map<String, DPT> getSubTypes() {
        return types;
    }

    @Override
    public List<DPTXlator> split() {
        if (this.getItems() == 1) {
            return Collections.singletonList(this);
        }
        ArrayList<DPTXlator> l = new ArrayList<DPTXlator>();
        int from = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != 0) continue;
            try {
                l.add(new DPTXlatorUtf8(this.getType()));
            }
            catch (KNXFormatException kNXFormatException) {
                // empty catch block
            }
            int to = i + 1;
            ((DPTXlator)l.get((int)(l.size() - 1))).data = Arrays.copyOfRange(this.data, from, to);
            from = to;
        }
        return l;
    }

    protected static Map<String, DPT> getSubTypesStatic() {
        return types;
    }

    private String fromDPT(int index) {
        int offset = DPTXlatorUtf8.findOffsetFor(index, this.data);
        int length = 0;
        for (int i = offset; i < this.data.length && this.data[i] != 0; ++i) {
            ++length;
        }
        byte[] utfdata = new byte[length];
        for (int i = 0; i < utfdata.length; ++i) {
            utfdata[i] = (byte)this.data[offset + i];
        }
        return new String(utfdata, 0, length, StandardCharsets.UTF_8);
    }

    private void toDPT(byte[] buf, int offset) {
        int length = buf.length - offset;
        if (length <= 0) {
            throw new KNXIllegalArgumentException("data length " + length + " < minimum of 1 byte for empty string");
        }
        if (length > 0x100000) {
            throw new KNXIllegalArgumentException("data length " + length + " exceeds translator limit of 1048576 bytes");
        }
        if (buf[buf.length - 1] != 0) {
            throw new KNXIllegalArgumentException("UTF-8 string not NULL terminated");
        }
        this.data = new short[length];
        for (int i = 0; i < length; ++i) {
            this.data[i] = DPTXlatorUtf8.ubyte(buf[offset + i]);
        }
        this.countItems();
    }

    @Override
    protected void toDPT(String value, short[] dst, int index) throws KNXFormatException {
        byte[] utfdata = this.toUtf8(value);
        int offset = DPTXlatorUtf8.findOffsetFor(index, dst);
        for (int i = 0; i < utfdata.length; ++i) {
            dst[offset + i] = DPTXlatorUtf8.ubyte(utfdata[i]);
        }
        if (utfdata.length == 0 || utfdata[utfdata.length - 1] != 0) {
            dst[offset + utfdata.length] = 0;
        }
    }

    private byte[] toUtf8(String value) throws KNXFormatException {
        byte[] utfdata = value.getBytes(StandardCharsets.UTF_8);
        if (utfdata.length > 1048575) {
            throw this.newException("UTF-8 string exceeds translator limit of 1048576 bytes", value);
        }
        return utfdata;
    }

    private static int findOffsetFor(int index, short[] dst) {
        int offset = 0;
        int idx = index;
        while (idx > 0) {
            if (offset >= dst.length) {
                throw new KNXIllegalArgumentException("index " + index + " past last string");
            }
            if (dst[offset++] != 0) continue;
            --idx;
        }
        return offset;
    }

    private void countItems() {
        int found = 0;
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != 0) continue;
            ++found;
        }
        this.items = found;
    }

    static {
        types.put(DPT_UTF8.getID(), DPT_UTF8);
    }
}

